/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushContractApproveAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncYcPayResultSettleLineBO;
import com.tydic.fsc.common.busi.api.FscSyncYcPayResultBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncYcPayResultBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncYcPayResultBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayConfirmAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityRspBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSyncYcPayResultBusiServiceImpl
implements FscSyncYcPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncYcPayResultBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscPayConfirmAbilityService fscPayConfirmAbilityService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscPushContractApproveAbilityService fscPushContractApproveAbilityService;

    @Override
    @FscDuplicateCommitLimit
    public FscSyncYcPayResultBusiRspBO syncYcPayResult(FscSyncYcPayResultBusiReqBO reqBO) {
        FscSyncYcPayResultBusiRspBO rspBO = new FscSyncYcPayResultBusiRspBO();
        log.info("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId(reqBO.getPAY_ID());
        logAbilityReqBO.setObjectNo(reqBO.getPAY_NO());
        logAbilityReqBO.setType(FscConstants.FscPushType.PAY_RESULT);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)((Object)reqBO)));
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setOrderNo(reqBO.getPAY_NO());
        queryVo.setFscOrderId(reqBO.getPAY_ID());
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(queryVo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f!");
        }
        rspBO.setFscOrderId(modelBy.getFscOrderId());
        BigDecimal totalPayAmount = reqBO.getPAY_OFFINE_AMT();
        if (reqBO.getPAY_BANK_AMT() != null) {
            totalPayAmount = reqBO.getPAY_OFFINE_AMT().add(reqBO.getPAY_BANK_AMT());
        }
        if (totalPayAmount.compareTo(modelBy.getToPayAmount()) > 0) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u672a\u4ed8\u91d1\u989d!");
        }
        LinkedList<FscShouldPayPO> shouldUpdateList = new LinkedList<FscShouldPayPO>();
        BigDecimal toPayAmount = modelBy.getTotalCharge();
        if (totalPayAmount.compareTo(toPayAmount) == 0) {
            if (modelBy.getTradeMode() != null && modelBy.getTradeMode() == 2 && modelBy.getSettlePlatform() != null && modelBy.getSettlePlatform() == 2) {
                FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
                fscDealPaySuccessAtomReqBO.setPayFscOrderId(Arrays.asList(modelBy.getFscOrderId()));
                fscDealPaySuccessAtomReqBO.setPayTime(new Date());
                this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
                FscOrderPO fsc = new FscOrderPO();
                fsc.setFscOrderId(modelBy.getFscOrderId());
                fsc.setPostingStatus("1");
                fsc.setOrderState(Integer.valueOf(1008));
                fsc.setUpdateTime(new Date());
                fsc.setUpdateTimeEnd(new Date());
                fsc.setPostingDate(new Date());
                this.fscOrderMapper.updateById(fsc);
                if (modelBy.getFscOrderId() != null) {
                    this.sendMq(modelBy.getFscOrderId());
                }
            } else {
                FscPayConfirmAbilityReqBO abilityReqBO = new FscPayConfirmAbilityReqBO();
                abilityReqBO.setFscOrderIds(Collections.singletonList(modelBy.getFscOrderId()));
                abilityReqBO.setPayFlag(Boolean.valueOf(true));
                abilityReqBO.setUserName(reqBO.getPERSON_NAME());
                abilityReqBO.setUserId(Long.valueOf(reqBO.getPERSON_ID()));
                abilityReqBO.setYcPayFlag(Boolean.valueOf(true));
                abilityReqBO.setPayTime(reqBO.getPAY_TIME());
                FscPayConfirmAbilityRspBO fscPayConfirmAbilityRspBO = this.fscPayConfirmAbilityService.dealPayConfirm(abilityReqBO);
                if (!fscPayConfirmAbilityRspBO.getRespCode().equals("0000")) {
                    log.error("\u8c03\u7528\u6d41\u7a0b\u5931\u8d25\uff01" + fscPayConfirmAbilityRspBO.getRespDesc());
                    throw new FscBusinessException(fscPayConfirmAbilityRspBO.getRespCode(), fscPayConfirmAbilityRspBO.getRespDesc());
                }
            }
        } else {
            if (!CollectionUtils.isEmpty(reqBO.getSettleInfoList())) {
                HashMap<Long, BigDecimal> payAmountMap = new HashMap<Long, BigDecimal>(reqBO.getSettleInfoList().size());
                for (FscSyncYcPayResultSettleLineBO settleLineBo : reqBO.getSettleInfoList()) {
                    payAmountMap.put(settleLineBo.getPC_SETTLE_ID(), settleLineBo.getPAY_AMT());
                }
                List shouldPayList = this.fscShouldPayMapper.getByFscOrderId(reqBO.getPAY_ID());
                for (Long fscOrderId : payAmountMap.keySet()) {
                    BigDecimal bigDecimal = (BigDecimal)payAmountMap.get(fscOrderId);
                    BigDecimal amount = BigDecimal.ZERO;
                    for (FscShouldPayPO fscShouldPayPo : shouldPayList) {
                        if (!fscOrderId.equals(fscShouldPayPo.getFscOrderId())) continue;
                        amount = amount.add(fscShouldPayPo.getPayingAmount());
                    }
                    if (bigDecimal.compareTo(amount) == 0) continue;
                    throw new FscBusinessException("190000", "\u5408\u5e76\u540e\u7684\u5e94\u4ed8\u5355\u91d1\u989d\u548c\u4e1a\u8d22\u8fd4\u56de\u7684\u91d1\u989d\u4e0d\u76f8\u7b49\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)shouldPayList)) {
                    throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u76f8\u5173\u4fe1\u606f!");
                }
                for (FscShouldPayPO fscShouldPayPo : shouldPayList) {
                    if (payAmountMap.get(fscShouldPayPo.getObjectId()) == null) continue;
                    BigDecimal payAmt = (BigDecimal)payAmountMap.get(fscShouldPayPo.getObjectId());
                    if (payAmt.compareTo(fscShouldPayPo.getPayingAmount() == null ? BigDecimal.ZERO : fscShouldPayPo.getPayingAmount()) >= 0) {
                        fscShouldPayPo.setPayingAmount(fscShouldPayPo.getPayingAmount().subtract(fscShouldPayPo.getPayingAmount()));
                        fscShouldPayPo.setPaidAmount(fscShouldPayPo.getPayAmount().add(fscShouldPayPo.getPayingAmount()));
                        fscShouldPayPo.setToPayAmount(fscShouldPayPo.getToPayAmount().subtract(fscShouldPayPo.getPayingAmount()));
                    }
                    shouldUpdateList.add(fscShouldPayPo);
                }
            }
            if (!CollectionUtils.isEmpty(shouldUpdateList)) {
                this.fscShouldPayMapper.updateAmountBatch(shouldUpdateList);
            }
            if (modelBy.getFscOrderId() != null) {
                this.sendMq(modelBy.getFscOrderId());
            }
        }
        log.info("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\uff0c\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3-------");
        CompletableFuture.runAsync(() -> {
            try {
                FscPushContractPayAbilityReqBO fscPushContractPayAbilityReqBO = new FscPushContractPayAbilityReqBO();
                fscPushContractPayAbilityReqBO.setFscOrderId(modelBy.getFscOrderId());
                FscPushContractPayAbilityRspBO abilityRspBO = this.fscPushContractApproveAbilityService.dealPushContractPay(fscPushContractPayAbilityReqBO);
                if (Objects.nonNull(abilityRspBO) && "0000".equals(abilityRspBO.getRespCode())) {
                    log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + abilityRspBO.getRespDesc());
                }
            }
            catch (Exception exception) {
                log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + exception);
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

