/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceBudgetAtomService;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceOrderReleaseWriteAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomRspBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderReleaseWriteAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderReleaseWriteAtomRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceBillFallbackStatementBusiService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealBillFallbackStatementBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealBillFallbackStatementBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceBillFallbackStatementBusiServiceImpl
implements FscFinanceBillFallbackStatementBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBillFallbackStatementBusiServiceImpl.class);
    private static final String BUSI_NAME = "\u5171\u4eab\u5355\u636e\u56de\u9000";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscFinanceOrderReleaseWriteAtomService fscFinanceOrderReleaseWriteAtomService;
    @Autowired
    private FscFinanceBudgetAtomService fscFinanceBudgetAtomService;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceReleasePayInfoBusiService fscFinanceReleasePayInfoBusiService;
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;

    @Override
    public FscFinanceDealBillFallbackStatementBusiRspBO dealStatement(FscFinanceDealBillFallbackStatementBusiReqBO reqBO) {
        FscFinanceDealBillFallbackStatementBusiRspBO rspBo = new FscFinanceDealBillFallbackStatementBusiRspBO();
        FscFinanceOrderReleaseWriteAtomReqBO atomReqBO = new FscFinanceOrderReleaseWriteAtomReqBO();
        atomReqBO.setFscOrderId(reqBO.getFscOrderId());
        FscFinanceOrderReleaseWriteAtomRspBO atomRspBO = this.fscFinanceOrderReleaseWriteAtomService.dealFinanceOrderReleaseWrite(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", atomRspBO.getRespDesc());
        }
        FscFinanceBudgetReleaseAtomReqBO budgetReleaseAtomReqBO = new FscFinanceBudgetReleaseAtomReqBO();
        budgetReleaseAtomReqBO.setFscOrderId(reqBO.getFscOrderId());
        FscFinanceBudgetReleaseAtomRspBO budgetReleaseAtomRspBO = this.fscFinanceBudgetAtomService.releaseFinanceBudget(budgetReleaseAtomReqBO);
        if (Objects.nonNull(budgetReleaseAtomRspBO) && !"0000".equals(budgetReleaseAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", budgetReleaseAtomRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("skigFlag", FscConstants.BillOrderSkigFlag.FINANCE_BACK);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderFinancePO.setExt2(reqBO.getBackRemark());
        fscOrderFinancePO.setPushFinanceStatus(Integer.valueOf(3));
        fscOrderFinancePO.setUpdateUserId(reqBO.getOperAccount());
        fscOrderFinancePO.setUpdateUserName(reqBO.getOperName());
        fscOrderFinancePO.setUpdateTime(new Date());
        int result = this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
        if (result < 1) {
            rspBo.setRespCode("190000");
            rspBo.setRespDesc("\u5931\u8d25");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public FscFinanceDealBillFallbackStatementBusiRspBO dealJgjfStatement(FscFinanceDealBillFallbackStatementBusiReqBO reqBO) {
        FscFinanceDealBillFallbackStatementBusiRspBO rspBo = new FscFinanceDealBillFallbackStatementBusiRspBO();
        FscFinanceOrderReleaseWriteAtomReqBO atomReqBO = new FscFinanceOrderReleaseWriteAtomReqBO();
        atomReqBO.setFscOrderId(reqBO.getFscOrderId());
        FscFinanceOrderReleaseWriteAtomRspBO atomRspBO = this.fscFinanceOrderReleaseWriteAtomService.dealFinanceOrderReleaseWrite(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", atomRspBO.getRespDesc());
        }
        FscFinanceBudgetReleaseAtomReqBO budgetReleaseAtomReqBO = new FscFinanceBudgetReleaseAtomReqBO();
        budgetReleaseAtomReqBO.setFscOrderId(reqBO.getFscOrderId());
        FscFinanceBudgetReleaseAtomRspBO budgetReleaseAtomRspBO = this.fscFinanceBudgetAtomService.releaseFinanceBudget(budgetReleaseAtomReqBO);
        if (Objects.nonNull(budgetReleaseAtomRspBO) && !"0000".equals(budgetReleaseAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", budgetReleaseAtomRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("skigFlag", FscConstants.BillOrderSkigFlag.FINANCE_BACK);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderFinancePO.setExt2(reqBO.getBackRemark());
        fscOrderFinancePO.setPushFinanceStatus(Integer.valueOf(3));
        fscOrderFinancePO.setUpdateUserId(reqBO.getOperAccount());
        fscOrderFinancePO.setUpdateUserName(reqBO.getOperName());
        fscOrderFinancePO.setUpdateTime(new Date());
        int result = this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
        if (result < 1) {
            rspBo.setRespCode("190000");
            rspBo.setRespDesc("\u5931\u8d25");
            return rspBo;
        }
        Long payOrderId = this.fscShouldPayMapper.getFinancePayOrderId(reqBO.getFscOrderId());
        fscOrderFinancePO.setFscOrderId(payOrderId);
        fscOrderFinancePO.setExt2(reqBO.getBackRemark());
        fscOrderFinancePO.setPushFinanceStatus(Integer.valueOf(3));
        fscOrderFinancePO.setUpdateUserId(reqBO.getOperAccount());
        fscOrderFinancePO.setUpdateUserName(reqBO.getOperName());
        fscOrderFinancePO.setUpdateTime(new Date());
        this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
        FscFinanceReleasePayInfoReqBO fscFinanceReleasePayInfoReqBO = new FscFinanceReleasePayInfoReqBO();
        fscFinanceReleasePayInfoReqBO.setFscOrderId(reqBO.getFscOrderId());
        FscFinanceReleasePayInfoRspBO fscFinanceReleasePayInfoRspBO = this.fscFinanceReleasePayInfoBusiService.dealReleasePayInfo(fscFinanceReleasePayInfoReqBO);
        log.debug("\u91ca\u653e\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)fscFinanceReleasePayInfoRspBO));
        rspBo.setPayOrderId(payOrderId);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

