/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscBillRecvClaimChangePushStatusCallBackAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillRecvClaimChangePushStatusCallBackAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillRecvClaimChangePushStatusCallBackAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillRecvClaimChangePushStatusCallBackAbilityService"})
public class FscBillRecvClaimChangePushStatusCallBackAbilityServiceImpl
implements FscBillRecvClaimChangePushStatusCallBackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillRecvClaimChangePushStatusCallBackAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;

    @PostMapping(value={"pushStatusCallBack"})
    public FscBillRecvClaimChangePushStatusCallBackAbilityRspBO pushStatusCallBack(@RequestBody FscBillRecvClaimChangePushStatusCallBackAbilityReqBO reqBO) {
        if (reqBO == null || reqBO.getChangId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)reqBO.getBackReason())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9519\u8bef\u539f\u56e0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getChangId());
        if (fscRecvClaimChangePO == null) {
            throw new FscBusinessException("190000", "\u53d8\u66f4\u5355\u4e0d\u5b58\u5728\uff01");
        }
        FscPushLogPO fscPushLogPO = new FscPushLogPO();
        fscPushLogPO.setObjectId(fscRecvClaimChangePO.getChangeId());
        fscPushLogPO.setType(Integer.valueOf(10));
        fscPushLogPO.setStatus(Integer.valueOf(1));
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(fscPushLogPO);
        FscPushLogPO logPO = new FscPushLogPO();
        logPO.setObjectId(fscRecvClaimChangePO.getChangeId());
        logPO.setObjectNo(fscRecvClaimChangePO.getChangeNo());
        if (lastPushLog != null && !StringUtils.isBlank((String)lastPushLog.getObjData())) {
            logPO.setObjData(lastPushLog.getObjData());
        }
        logPO.setPushParseData(reqBO.getBackReason());
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData(reqBO.getBackReason());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        logPO.setRespData(decryptionAbilityRspBO.getData());
        this.saveLog(FscConstants.FscPushStatus.FAIL, logPO);
        try {
            FscRecvClaimChangePO changePO = new FscRecvClaimChangePO();
            changePO.setPushStatus(Integer.valueOf(2));
            changePO.setPushDate(new Date());
            changePO.setFailReason(decryptionAbilityRspBO.getData());
            changePO.setChangeId(reqBO.getChangId());
            this.fscRecvClaimChangeMapper.updatePushStatus(changePO);
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u6536\u6b3e\u8ba4\u9886\u53d8\u66f4\u5355\u4e3b\u5355\u63a8\u9001\u72b6\u6001\u5931\u8d25\uff01");
        }
        return new FscBillRecvClaimChangePushStatusCallBackAbilityRspBO();
    }

    private void saveLog(Integer status, FscPushLogPO fscPushLogPo) {
        try {
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM_CHANGE_PUSH_STATUS_BACK);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            int count = this.fscPushLogMapper.insert(fscPushLogPo);
            if (count == 0) {
                throw new ZTBusinessException("\u5b58\u50a8\u5931\u8d25\uff0c\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u7684\u6761\u6570\u4e3a0");
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }
}

