/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService"})
public class FscComApprovalprocessListQryAbilityServiceImpl
implements FscComApprovalprocessListQryAbilityService {
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    private final String REFUND_CANCEL_STR = "\u9000\u7968\u5355\u53d6\u6d88";

    @PostMapping(value={"getFscApprovalprocessListQry"})
    public FscComApprovalprocessListQryAbilityRspBO getFscApprovalprocessListQry(@RequestBody FscComApprovalprocessListQryAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getObjType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setObjId(abilityReqBO.getFscOrderId().toString());
        uacQryAuditLogReqBO.setObjType(abilityReqBO.getObjType());
        uacQryAuditLogReqBO.setPageNo(abilityReqBO.getPageNo());
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(100));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        ArrayList rows = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
            List<ApprovalLogBO> list = uacQryAuditLogRspBO.getRows().stream().sorted(Comparator.comparing(ApprovalLogBO::getDealTime)).collect(Collectors.toList());
            list.forEach(approvalLogBO -> {
                FscApprovalprocessListBO bo = new FscApprovalprocessListBO();
                bo.setOperId(approvalLogBO.getOperid());
                bo.setOperName(approvalLogBO.getOperName());
                bo.setAudit(approvalLogBO.getAudit());
                bo.setAdvice(approvalLogBO.getAuditAdvice());
                bo.setTime(approvalLogBO.getDealTime());
                bo.setStepId(approvalLogBO.getStepId());
                bo.setStepName(approvalLogBO.getStepName());
                if (approvalLogBO.getProcessTime() != null) {
                    String timeConsuming = this.formatTime(approvalLogBO.getProcessTime());
                    bo.setTimeConsuming(timeConsuming);
                }
                if ("\u6d41\u91cf\u8d39\u5ba1\u6279\u64a4\u56de".equals(bo.getAdvice())) {
                    bo.setAudit("\u64a4\u56de");
                }
                if ("\u9000\u7968\u5355\u53d6\u6d88".equals(bo.getAdvice())) {
                    bo.setAudit("\u53d6\u6d88");
                }
                bo.setOrgName(approvalLogBO.getOperDept());
                bo.setNextStationId(approvalLogBO.getNextStationId());
                bo.setFinish(approvalLogBO.getFinish());
                rows.add(bo);
            });
        }
        FscComApprovalprocessListQryAbilityRspBO rspBO = new FscComApprovalprocessListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(uacQryAuditLogRspBO.getPageNo());
        rspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords());
        rspBO.setTotal(uacQryAuditLogRspBO.getTotalPages());
        return rspBO;
    }

    String formatTime(Long time) {
        long hours = time / 3600000L;
        long minutes = (time - hours * 3600000L) / 60000L;
        long s = (time - hours * 3600000L - minutes * 60000L) / 1000L;
        return hours + "\u65f6" + minutes + "\u5206" + s + "\u79d2";
    }
}

