/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscReleaseFundPlanAbilityService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.FscReleaseFundPlanAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscReleaseFundPlanAbilityRspBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscReleaseFundPlanAbilityService"})
public class FscReleaseFundPlanAbilityServiceImpl
implements FscReleaseFundPlanAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReleaseFundPlanAbilityServiceImpl.class);
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"releasePlan"})
    public FscReleaseFundPlanAbilityRspBO releasePlan(@RequestBody FscReleaseFundPlanAbilityReqBO reqBO) {
        List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(reqBO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new FscReleaseFundPlanAbilityRspBO();
        }
        FscBillAddPushLogBusiReqBO logBusiReqBO = new FscBillAddPushLogBusiReqBO();
        logBusiReqBO.setPushStatus(Integer.valueOf(0));
        logBusiReqBO.setStatus(Integer.valueOf(0));
        logBusiReqBO.setObjectId(reqBO.getFscOrderId());
        logBusiReqBO.setCreateTime(new Date());
        logBusiReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(reqBO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (1 == reqBO.getType()) {
            reqBO.setAgentAccount(orderExtPO.getAgentAccount());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        List paymentList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        Integer shouldPayMethod = ((FscOrderPayItemPO)paymentList.get(0)).getShouldPayMethod();
        try {
            QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
            qryUnifySettleTokenReqBO.setUserId(reqBO.getAgentAccount());
            QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
            if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
            }
            logBusiReqBO.setObjectNo(fscOrder.getOrderNo());
            FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (FscOperateCapitalPlanPO x : list) {
                JSONObject bo = new JSONObject();
                bo.put("period", (Object)x.getPeriod());
                bo.put("itemId", (Object)x.getItemId());
                bo.put("itemName", (Object)x.getItemName());
                bo.put("controlMode", (Object)x.getControlMode());
                bo.put("exeType", (Object)(reqBO.getType() == 0 ? "ZY" : "RZY"));
                bo.put("planAmount", (Object)(reqBO.getType() == 0 ? x.getPlanAmount() : x.getPlanAmount().negate()));
                bo.put("amount", (Object)(reqBO.getType() == 0 ? x.getUseAmount() : x.getUseAmount().negate()));
                bo.put("fromSource", (Object)"EBAY");
                bo.put("contractNum", (Object)x.getContractNum());
                if ("BILL".equals(x.getControlMode())) {
                    bo.put("billId", (Object)reqBO.getFscOrderId());
                    bo.put("billNum", (Object)fscOrder.getOrderNo());
                }
                bo.put("recOrgName", (Object)fscOrder.getPayeeName());
                bo.put("fromBillId", (Object)(reqBO.getFscOrderId() + ""));
                bo.put("fromBillLineId", (Object)x.getId());
                bo.put("deptId", (Object)x.getDeptId());
                bo.put("deptName", (Object)x.getDeptName());
                bo.put("orgId", x.getOrgId() != null ? x.getOrgId() : orderExtPO.getUnifyOrgId());
                if (reqBO.getType() == 1 && Objects.nonNull(shouldPayMethod)) {
                    bo.put("billType", (Object)(shouldPayMethod == 0 ? "YFK" : "HTJS"));
                    bo.put("fromBillType", (Object)(shouldPayMethod == 0 ? "YFK" : "FK"));
                } else {
                    bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                    bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                }
                jsonArray.add((Object)bo);
            }
            jsonObject.put("head", (Object)jsonArray);
            JSONArray jsonArray1 = new JSONArray();
            jsonArray1.add((Object)jsonObject);
            logBusiReqBO.setPushData(jsonArray1.toJSONString());
            logBusiReqBO.setObjData(jsonArray1.toJSONString());
            planReqBO.setJsonObject(jsonArray1);
            planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
            FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
            logBusiReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
            logBusiReqBO.setRespData(fundingPlanRspBO.getRespData());
            logBusiReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
            if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25" + fundingPlanRspBO.getRespDesc());
            }
            logBusiReqBO.setPushStatus(Integer.valueOf(1));
            logBusiReqBO.setStatus(Integer.valueOf(1));
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8d44\u91d1\u8ba1\u5212\u5360\u7528/\u91ca\u653e\u63a5\u53e3\u5931\u8d25,\u7ed3\u7b97\u5355id{},\u5165\u53c2{}", (Object)reqBO.getFscOrderId(), (Object)e.getMessage());
            if (logBusiReqBO.getRespData() == null) {
                logBusiReqBO.setRespData(e.getMessage());
            }
        }
        finally {
            if (fscOrder.getTradeMode() == 1) {
                this.fscBillAddPushLogBusiService.addPushLog(logBusiReqBO);
            } else {
                this.fscBillAddPushLogBusiService.addPurchasePushLog(logBusiReqBO);
            }
        }
        return new FscReleaseFundPlanAbilityRspBO();
    }
}

