/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceSubmitLedgerSaveAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceChargeBudgetSaveBackLedgerVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceSubmitLedgerSaveAbilityService"})
public class FscFinanceSubmitLedgerSaveAbilityServiceImpl
implements FscFinanceSubmitLedgerSaveAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSubmitLedgerSaveAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fsFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"saveSubmitLedger"})
    public FscFinanceSubmitLedgerSaveRspBO saveSubmitLedger(@RequestBody FscFinanceSubmitLedgerSaveReqBO reqBo) {
        FscFinanceSubmitLedgerSaveRspBO rspBO = new FscFinanceSubmitLedgerSaveRspBO();
        this.valid(reqBo);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fsFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainUrl), (String)"\u672a\u914d\u7f6e\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u5efa\u8bbe\u9879\u76ee\u63a5\u53e3");
            HashMap header = Maps.newHashMap();
            String token = financeShareTokenRspBO.getToken();
            header.put("Authorization", token);
            String body = JSON.toJSONString((Object)reqBo.getSubmitLedgerSaveList());
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u5360\u7528\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587 url:{} params:{} token:{}", new Object[]{this.fscShareFinanceServiceConfiguration.getBu102(), body, token});
            String json = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getBu102()), (String)body, (Map)header);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u5360\u7528\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)json);
            rspBO.setRespData(json);
            FscFinanceChargeBudgetSaveBackLedgerVO vo = (FscFinanceChargeBudgetSaveBackLedgerVO)JSON.parseObject((String)json, FscFinanceChargeBudgetSaveBackLedgerVO.class);
            Assert.isTrue((vo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3a\u7a7a");
            Assert.isTrue((vo.getCode() == 0 ? 1 : 0) != 0, (String)vo.getMsg());
            rspBO.setData(vo.getData());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u5360\u7528\u63a5\u53e3\uff1a%s", e.getMessage()));
        }
        return rspBO;
    }

    private void valid(FscFinanceSubmitLedgerSaveReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscFinanceSubmitLedgerSaveListReqBO listReqBO : reqBO.getSubmitLedgerSaveList()) {
            if (StringUtils.isBlank((CharSequence)listReqBO.getBillGuid())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636eGUID[billGuid]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getBillCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7f16\u53f7[billCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getOrgId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5f53\u524d\u7528\u6237\u673a\u6784id[orgId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getBizSmallTypeCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e1a\u52a1\u5c0f\u7c7b\u7f16\u7801[bizSmallTypeCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getBizSmallTypeName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e1a\u52a1\u5c0f\u7c7b\u540d\u79f0[bizSmallTypeName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getCostCenterCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u7f16\u7801[costCenterCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getSubTypeCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ec6\u5206\u7c7b\u578b\u7f16\u53f7[subTypeCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getSubTypeName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ec6\u5206\u7c7b\u578b\u540d\u79f0[subTypeName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getBizDate())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e1a\u52a1\u65e5\u671f[bizDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)listReqBO.getAccountDate())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5165\u8d26\u65e5\u671f[accountDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (listReqBO.getLocalHoldAmt() != null) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u672c\u6b21\u5360\u7528\u91d1\u989d[localHoldAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

