/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.common.busi.api.FscAccountRegulationApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountRegulationMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscRegulationStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountRegulationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountRegulationApprovalBusiServiceImpl
implements FscAccountRegulationApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountRegulationApprovalBusiServiceImpl.class);
    private FscAccountRegulationMapper fscAccountRegulationMapper;
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    public static final String PASS = "0";
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;

    @Override
    public FscAccountRegulationApprovalBusiRspBO dealRegulationApproval(FscAccountRegulationApprovalBusiReqBO reqBO) {
        this.valid(reqBO);
        Integer count = this.fscOrderMapper.getRegulationAuditCount(reqBO.getRegulationId(), reqBO.getStationsList());
        if (count == 0) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        FscAccountRegulationPO fscAccountRegulationPo = new FscAccountRegulationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountRegulationPo);
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.dealApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscAccountRegulationPO fscAccountRegulationPO = this.fscAccountRegulationMapper.queryById(reqBO.getRegulationId());
        if (finish.booleanValue()) {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO;
            if (PASS.equals(auditResult)) {
                fscAccountRegulationPo.setStatus(FscRegulationStatusEnum.APPROVED.getCode());
                fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscAccountRegulationPO.getRegulationNo() + "\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + "\u5ba1\u6279\u901a\u8fc7");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + fscAccountRegulationPO.getRegulationNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscAccountRegulationPO.getUserId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            } else {
                fscAccountRegulationPo.setStatus(FscRegulationStatusEnum.NOT_APPROVED.getCode());
                fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscAccountRegulationPO.getRegulationNo() + "\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + "\u5ba1\u6279\u9a73\u56de");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + fscAccountRegulationPO.getRegulationNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscAccountRegulationPO.getUserId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
            fscAccountRegulationPo.setAuditTime(new Date());
            fscAccountRegulationPo.setAuditUserId(reqBO.getUserId());
            fscAccountRegulationPo.setAuditUserName(reqBO.getName());
            this.fscAccountRegulationMapper.update(fscAccountRegulationPo);
        } else {
            FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
            taskPo.setFscOrderId(reqBO.getRegulationId());
            List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
            if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
                DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                    FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                    fscSendNotificationExtAtomReqBO.setTitel(fscAccountRegulationPO.getRegulationNo() + "\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + "\u5f85\u5ba1\u6279");
                    fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + fscAccountRegulationPO.getRegulationNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                    fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                    this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                }
            }
        }
        FscAccountRegulationApprovalBusiRspBO rspBO = new FscAccountRegulationApprovalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFinish(finish);
        return rspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO dealApprovalResult(FscAccountRegulationApprovalBusiReqBO reqBO) {
        String stepId = this.fscAccountRegulationMapper.selectStepId(reqBO.getRegulationId(), FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL, UacCommConstant.STATUS.UNDER_REVIEW);
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        auditReqBO.setObjId(Stream.of(reqBO.getRegulationId()).collect(Collectors.toList()));
        auditReqBO.setStepId(stepId);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditMsg())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditMsg());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u8d26\u5ba1\u6279\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u8d26\u5ba1\u6279\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    public void valid(FscAccountRegulationApprovalBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegulationId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8c03\u8d26\u5355id[regulationId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6838\u7ed3\u679c[auditResult]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditMsg())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u610f\u89c1[auditMsg]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Autowired
    public void setFscAccountRegulationMapper(FscAccountRegulationMapper fscAccountRegulationMapper) {
        this.fscAccountRegulationMapper = fscAccountRegulationMapper;
    }

    @Autowired
    public void setUacNoTaskAuditOrderAuditAbilityService(UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService) {
        this.uacNoTaskAuditOrderAuditAbilityService = uacNoTaskAuditOrderAuditAbilityService;
    }
}

