/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.busi.api.FscPushMemPayFeeBusiService;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiRspBO;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcMemberConfigQryDetailSAbilityervice;
import com.tydic.umc.general.ability.api.UmcMemberFeePushAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushMemPayFeeBusiServiceImpl
implements FscPushMemPayFeeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushMemPayFeeBusiServiceImpl.class);
    @Autowired
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UmcMemberFeePushAbilityService umcMemberFeePushAbilityService;
    @Autowired
    private UmcMemberConfigQryDetailSAbilityervice umcMemberConfigQryDetailSAbilityervice;

    @Override
    public FscPushMemPayFeeBusiRspBO dealFscPushMemFee(FscPushMemPayFeeBusiReqBO reqBO) {
        UmcMemberFeePushAbilityRspBO abilityRspBO;
        boolean needPushFz;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscMemPayInfoPO payInfoPo = new FscMemPayInfoPO();
        payInfoPo.setFscOrderId(reqBO.getFscOrderId());
        payInfoPo = this.fscMemPayInfoMapper.getModelBy(payInfoPo);
        if (payInfoPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u8d39\u76f8\u5173\u4fe1\u606f\uff01" + reqBO.getFscOrderId());
        }
        List<Integer> typeList = this.queryMemConfig(payInfoPo);
        UmcMemberFeePushAbilityReqBO pushReqBo = this.buildPushReqBo(payInfoPo);
        FscMemPayInfoPO payInfo = new FscMemPayInfoPO();
        payInfo.setFscOrderId(payInfoPo.getFscOrderId());
        payInfo.setMemId(payInfoPo.getMemId());
        StringBuilder sb = new StringBuilder();
        boolean needPushZb = payInfoPo.getIsPushZb() == 2 || payInfoPo.getIsPushZb() == 0 && typeList.contains(2);
        boolean bl = needPushFz = payInfoPo.getIsPushFz() == 2 || payInfoPo.getIsPushFz() == 0 && typeList.contains(1);
        if (!needPushZb && !needPushFz) {
            throw new FscBusinessException("198888", "\u8be5\u4f1a\u5458\u8d39\u4e0d\u6ee1\u8db3\u91cd\u65b0\u63a8\u9001\u72b6\u6001\uff01" + reqBO.getFscOrderId());
        }
        if (needPushZb) {
            log.debug("\u63a8\u9001\u62db\u6807\u4f1a\u5458\u8d39\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)pushReqBo));
            abilityRspBO = this.umcMemberFeePushAbilityService.dealPushZbMemFee(pushReqBo);
            log.debug("\u63a8\u9001\u62db\u6807\u4f1a\u5458\u8d39\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            payInfo.setIsPushZb(Integer.valueOf(1));
            if (!abilityRspBO.getRespCode().equals("0000")) {
                payInfo.setIsPushZb(Integer.valueOf(2));
                payInfo.setPushZbFailedReason(abilityRspBO.getRespDesc());
                sb.append(abilityRspBO.getRespDesc());
            }
        }
        if (needPushFz) {
            log.debug("\u63a8\u9001\u975e\u62db\u4f1a\u5458\u8d39\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)pushReqBo));
            abilityRspBO = this.umcMemberFeePushAbilityService.dealPushFzMemFee(pushReqBo);
            log.debug("\u63a8\u9001\u975e\u62db\u4f1a\u5458\u8d39\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            payInfo.setIsPushFz(Integer.valueOf(1));
            if (!abilityRspBO.getRespCode().equals("0000")) {
                payInfo.setIsPushFz(Integer.valueOf(2));
                payInfo.setPushFzFailedReason(abilityRspBO.getRespDesc());
                sb.append(abilityRspBO.getRespDesc());
            }
        }
        this.fscMemPayInfoMapper.update(payInfo);
        FscPushMemPayFeeBusiRspBO rspBO = new FscPushMemPayFeeBusiRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private List<Integer> queryMemConfig(FscMemPayInfoPO payInfoPo) {
        Long memLevelId = payInfoPo.getMemLevelId();
        List<Integer> types = new ArrayList<Integer>();
        if (memLevelId != null) {
            UmcMemberConfigQryDetailReqBO memberConfigQryDetailReqBO = new UmcMemberConfigQryDetailReqBO();
            memberConfigQryDetailReqBO.setMemberLevelId(memLevelId);
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailReqBO));
            UmcMemberConfigQryDetailRspBO memberConfigQryDetailRspBO = this.umcMemberConfigQryDetailSAbilityervice.qryMemberConfigDetail(memberConfigQryDetailReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailRspBO));
            if (memberConfigQryDetailRspBO != null && !CollectionUtils.isEmpty((Collection)memberConfigQryDetailRspBO.getPurchWayInfo())) {
                types = memberConfigQryDetailRspBO.getPurchWayInfo().stream().map(e -> e.getType()).collect(Collectors.toList());
            }
        }
        return types;
    }

    private UmcMemberFeePushAbilityReqBO buildPushReqBo(FscMemPayInfoPO payInfoPo) {
        UmcMemberFeePushAbilityReqBO reqBO = new UmcMemberFeePushAbilityReqBO();
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(payInfoPo.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (orderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u8d39\u76f8\u5173\u4fe1\u606f\uff01" + payInfoPo.getFscOrderId());
        }
        reqBO.setMemberLevelCode(payInfoPo.getMemLevelCode());
        reqBO.setMemberLevelName(payInfoPo.getMemLevelName());
        reqBO.setSupplierId(orderPo.getSupplierId());
        reqBO.setMemLevelId(payInfoPo.getMemLevelId());
        reqBO.setSupplierNo(payInfoPo.getSupplierNo());
        reqBO.setTransactionId(payInfoPo.getMemId());
        reqBO.setType("1");
        reqBO.setStartTime(payInfoPo.getEffDate());
        reqBO.setEndTime(payInfoPo.getExpDate());
        return reqBO;
    }
}

