/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.BillInfoYCBo;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentSettleBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyPayBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyPayBillService;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyPrePayBillService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcPayBillService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.common.busi.api.FscPushYcPayBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcPayBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcPayBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscDraftInfoPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayRelationPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocPrePayOrderInfoQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPrePayOrderInfoQueryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPrePayOrderInfoQueryAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcPayBillBusiServiceImpl
implements FscPushYcPayBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcPayBillBusiServiceImpl.class);
    @Autowired
    private FscPushYcPayBillService fscPushYcPayBillService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operOrgId;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private UocPrePayOrderInfoQueryAbilityService uocPrePayOrderInfoQueryAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    public static final String BUSI_NAME = "\u4ed8\u6b3e\u767b\u8bb0";
    public static final String BUSI_CODE = "1080";
    public static final String BUSI_NAME_MAIN = "\u63a8\u9001\u5931\u8d25";
    public static final String BUSI_CODE_MAIN = "1083";
    @Autowired
    private FscPushUnifyPrePayBillService fscPushUnifyPrePayBillService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscPushUnifyPayBillService fscPushUnifyPayBillService;

    @Override
    public FscPushYcPayBillBusiRspBO pushYcPayBill(FscPushYcPayBillBusiReqBO reqBO) {
        FscPushYcPayBillBusiRspBO rspBO = new FscPushYcPayBillBusiRspBO();
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setPayerId(this.operOrgId);
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrder == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u9700\u8981\u63a8\u9001\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getInitFlag())) {
            FscPushLogPO pushQueryVo = new FscPushLogPO();
            pushQueryVo.setObjectId(reqBO.getOrderId());
            pushQueryVo.setType(Integer.valueOf(1));
            FscPushLogPO fscPushLogPO = this.fscPushLogMapper.getLastPushLogByObjectAndType(pushQueryVo);
            if (fscPushLogPO != null && fscPushLogPO.getStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8bf7\u52ff\u91cd\u590d\u8fdb\u884c\u63a8\u9001\uff01");
                return rspBO;
            }
        }
        rspBO = fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ADVANCE_PAY) || fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY) || fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY) || fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.PAYMENT_PRE_PAY) ? this.dealPrePayBill(fscOrder, reqBO) : this.dealPayBill(fscOrder, reqBO);
        return rspBO;
    }

    private FscPushYcPayBillBusiRspBO dealPrePayBill(FscOrderPO fscOrderPo, FscPushYcPayBillBusiReqBO reqBO) {
        FscPushUnifyPayBillRspBO billRspBO = new FscPushUnifyPayBillRspBO();
        FscPushYcPrePayBillReqBO prePayBillReqBO = new FscPushYcPrePayBillReqBO();
        FscPushLogPO fscPushLogPO = new FscPushLogPO();
        try {
            List list = this.fscShouldPayMapper.getByFscOrderId(fscOrderPo.getFscOrderId());
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u76f8\u5173\u4fe1\u606f\uff01");
            }
            UocPrePayOrderInfoQueryAbilityReqBO uocPrePayOrderInfoQueryAbilityReqBO = new UocPrePayOrderInfoQueryAbilityReqBO();
            uocPrePayOrderInfoQueryAbilityReqBO.setOrderId(((FscShouldPayPO)list.get(0)).getOrderId());
            UocPrePayOrderInfoQueryAbilityRspBO uocPrePayOrderInfoQueryAbilityRspBO = this.uocPrePayOrderInfoQueryAbilityService.queryOrderInfo(uocPrePayOrderInfoQueryAbilityReqBO);
            if (!uocPrePayOrderInfoQueryAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\uff01");
            }
            UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPo.getPayeeId());
            UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
            if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
            }
            if (StringUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
                throw new FscBusinessException("190000", "\u4f9b\u5e94\u5546erp\u7f16\u7801\u4e3a\u7a7a\uff01\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546erp\u7f16\u7801\uff01");
            }
            FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
            dicDictionaryExernalPO.setExernalSysCode("YC");
            List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
            String orderSource = fscOrderPo.getOrderType() + "";
            List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource)).map(FscDicDictionaryExernalPO::getExernalTitle).collect(Collectors.toList());
            FscPurchasePrePaymentBO prePaymentBO = new FscPurchasePrePaymentBO();
            prePaymentBO.setINIT_FLAG(reqBO.getInitFlag());
            prePaymentBO.setORG_ID(this.operationOrgId);
            prePaymentBO.setORG_NAME(this.operationOrgName);
            prePaymentBO.setDEPT_ID(fscOrderPo.getYcDeptId());
            prePaymentBO.setDEPT_NAME(fscOrderPo.getYcDeptName());
            prePaymentBO.setPERSON_ID(fscOrderPo.getYcPersonId());
            prePaymentBO.setPERSON_NAME(fscOrderPo.getYcPersonName());
            prePaymentBO.setEG_PREPAY_NUM(fscOrderPo.getOrderNo());
            prePaymentBO.setPREPAY_NAME("");
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("FSC_PAY_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            prePaymentBO.setPREPAY_TYPE(dicMap.get(uocPrePayOrderInfoQueryAbilityRspBO.getOrderType().toString()));
            prePaymentBO.setCONTRACT_NUMBER(fscOrderPo.getContractNo());
            prePaymentBO.setBILL_DATE(DateFormatUtils.format((Date)fscOrderPo.getCreateTime(), (String)"yyyy-MM-dd"));
            prePaymentBO.setDESCRIPTIONS(fscOrderPo.getRemark());
            prePaymentBO.setCONTRACT_NAME("");
            prePaymentBO.setVENDOR_NUM(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
            prePaymentBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
            prePaymentBO.setAMOUNT(this.dealAmount(fscOrderPo.getToPayAmount()));
            prePaymentBO.setEG_PREPAY_ID(fscOrderPo.getFscOrderId());
            prePaymentBO.setEG_PAY_TERMS_ID(fscOrderPo.getFscOrderId());
            prePaymentBO.setSTATUS("Y");
            prePaymentBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
            prePaymentBO.setUSER_ID(fscOrderPo.getYcUserId());
            prePaymentBO.setBUZ_PROPERTY_DIS((String)fscTypeList.get(0));
            prePaymentBO.setSTAGE("FIRST");
            prePaymentBO.setCOM_CODE("");
            prePaymentBO.setVENDOR_SITE_CODE("");
            prePaymentBO.setDOC_COUNT("");
            prePaymentBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
            prePaymentBO.setBANK_NUM(fscOrderPo.getPayeeBankAccount() == null ? "0" : fscOrderPo.getPayeeBankAccount());
            prePaymentBO.setPAY_TERMS("");
            prePaymentBO.setPAY_TERMS_ID("");
            LinkedList<FscPurchasePrePaymentLineBO> paymentLineBoList = new LinkedList<FscPurchasePrePaymentLineBO>();
            FscPurchasePrePaymentLineBO prePaymentLineBO = new FscPurchasePrePaymentLineBO();
            prePaymentLineBO.setVENDOR_NUM(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
            prePaymentLineBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
            prePaymentLineBO.setBANK_ACCOUNT_NAME(fscOrderPo.getPayeeAccountName());
            if (fscOrderPo.getPaymentMethod() != null) {
                eternalPo.setPCode("FSC_PAYMENT_TYPE");
                Map<String, String> payMethodMap = this.getDicMap(eternalPo);
                prePaymentLineBO.setPAY_MODE(payMethodMap.get(fscOrderPo.getPaymentMethod().toString()));
            }
            prePaymentLineBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
            prePaymentLineBO.setBANK_ACCOUNT_NUM(fscOrderPo.getPayeeBankAccount() == null ? "0" : fscOrderPo.getPayeeBankAccount());
            prePaymentLineBO.setAMOUNT(this.dealAmount(fscOrderPo.getToPayAmount()));
            prePaymentLineBO.setEG_ID(fscOrderPo.getFscOrderId());
            prePaymentLineBO.setCONTRACT_NUM("");
            prePaymentLineBO.setCONTACT_NAME("");
            prePaymentLineBO.setCONTRACT_AMT("");
            prePaymentLineBO.setEG_PREPAY_NUM(prePaymentBO.getEG_PREPAY_NUM());
            paymentLineBoList.add(prePaymentLineBO);
            prePayBillReqBO.setPurchaseAdPayment(prePaymentBO);
            prePayBillReqBO.setPurchaseAdPaymentLine(paymentLineBoList);
            prePayBillReqBO.setUserId(fscOrderPo.getPayerId());
            if (fscOrderPo.getPaymentMethod() != null && fscOrderPo.getPaymentMethod() == 2) {
                FscDraftInfoPO infoPO = new FscDraftInfoPO();
                infoPO.setFscOrderId(fscOrderPo.getFscOrderId());
                List infoPOS = this.fscDraftInfoMapper.selectList(infoPO);
                if (!CollectionUtils.isEmpty((Collection)infoPOS)) {
                    prePayBillReqBO.setBillInfo(infoPOS.stream().map(x -> {
                        BillInfoYCBo draftLineBO = new BillInfoYCBo();
                        draftLineBO.setBILL_ID(x.getDraftId());
                        return draftLineBO;
                    }).collect(Collectors.toList()));
                }
            }
            ArrayList ceLine = new ArrayList();
            ArrayList annexBOS = new ArrayList();
            prePayBillReqBO.setCeline(ceLine);
            prePayBillReqBO.setFileList(annexBOS);
            billRspBO = this.dealParamToPreYc(fscOrderPo.getFscOrderId(), prePayBillReqBO, fscPushLogPO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u4ed8\u6b3e\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff1a" + FscCommonUtils.dealStackTrace((Exception)e));
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.FAIL, fscPushLogPO);
            this.saveFailLog(fscOrderPo.getFscOrderId(), e.getMessage());
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                this.dealFailFlow(fscOrderPo, reqBO);
            }
            FscPushYcPayBillBusiRspBO rspBO = new FscPushYcPayBillBusiRspBO();
            rspBO.setRespDesc("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("190000");
            return rspBO;
        }
        if (!billRspBO.getRespCode().equals("0000")) {
            this.saveFailLog(fscOrderPo.getFscOrderId(), billRspBO.getRespDesc());
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.FAIL, fscPushLogPO);
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                this.dealFailFlow(fscOrderPo, reqBO);
            }
        } else if (fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.SUCCESS, fscPushLogPO);
            this.dealSuccessFlow(fscOrderPo, reqBO);
        } else {
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.SUCCESS, fscPushLogPO);
        }
        return (FscPushYcPayBillBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)billRspBO), FscPushYcPayBillBusiRspBO.class));
    }

    private FscPushYcPayBillBusiRspBO dealPayBill(FscOrderPO fscOrderPo, FscPushYcPayBillBusiReqBO reqBO) {
        FscPushUnifyPayBillRspBO payBillRspBO = new FscPushUnifyPayBillRspBO();
        FscPushYcPayBillReqBO payBillReqBO = new FscPushYcPayBillReqBO();
        FscPushLogPO fscPushLogPO = new FscPushLogPO();
        try {
            UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPo.getPayeeId());
            UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
            if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
            }
            if (StringUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
                throw new FscBusinessException("190000", "\u4f9b\u5e94\u5546erp\u7f16\u7801\u4e3a\u7a7a\uff01\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546erp\u7f16\u7801\uff01");
            }
            FscPurchasePaymentBO purchasePaymentBO = new FscPurchasePaymentBO();
            purchasePaymentBO.setINIT_FLAG(reqBO.getInitFlag());
            purchasePaymentBO.setORG_ID(this.operationOrgId);
            purchasePaymentBO.setORG_NAME(this.operationOrgName);
            purchasePaymentBO.setDEPT_ID(fscOrderPo.getYcDeptId());
            purchasePaymentBO.setDEPT_NAME(fscOrderPo.getYcDeptName());
            purchasePaymentBO.setPERSON_ID(fscOrderPo.getYcPersonId());
            purchasePaymentBO.setPERSON_NAME(fscOrderPo.getYcPersonName());
            purchasePaymentBO.setEG_PAYMENT_NUM(fscOrderPo.getOrderNo());
            purchasePaymentBO.setPAYMENT_NAME("");
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("FSC_PREPAY_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            purchasePaymentBO.setCONTRACT_NUMBER(fscOrderPo.getContractNo());
            purchasePaymentBO.setBRAND("");
            purchasePaymentBO.setVENDOR_NUM(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
            purchasePaymentBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
            purchasePaymentBO.setBILL_DATE(DateFormatUtils.format((Date)fscOrderPo.getCreateTime(), (String)"yyyy-MM-dd"));
            purchasePaymentBO.setDESCRIPTIONS(fscOrderPo.getRemark());
            purchasePaymentBO.setTAX_RATE(null);
            purchasePaymentBO.setEG_PAYMENT_ID(fscOrderPo.getFscOrderId());
            purchasePaymentBO.setAMOUNT(fscOrderPo.getTotalCharge());
            if (fscOrderPo.getOrderType() != null) {
                purchasePaymentBO.setPAYMENT_TYPE(dicMap.get(fscOrderPo.getOrderType().toString()));
            }
            purchasePaymentBO.setSTAGE("Y");
            purchasePaymentBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
            purchasePaymentBO.setUSER_ID(fscOrderPo.getYcUserId());
            purchasePaymentBO.setSTAGE("FIRST");
            purchasePaymentBO.setCOM_CODE("");
            purchasePaymentBO.setVENDOR_SITE_CODE("");
            purchasePaymentBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
            purchasePaymentBO.setBANK_NUM(fscOrderPo.getPayeeBankAccount() == null ? "0" : fscOrderPo.getPayeeBankAccount());
            purchasePaymentBO.setDOC_COUNT("");
            purchasePaymentBO.setPAY_DATE("");
            LinkedList<FscPurchasePaymentSettleBO> settleBOList = new LinkedList<FscPurchasePaymentSettleBO>();
            LinkedList<Long> fscOrderIds = new LinkedList<Long>();
            List relationList = this.fscOrderMapper.getPayOrderShouldPayFscOrder(Collections.singletonList(fscOrderPo.getFscOrderId()));
            HashMap<Long, BigDecimal> payAmountMap = new HashMap<Long, BigDecimal>();
            for (FscOrderPayRelationPO relationPo : relationList) {
                fscOrderIds.add(relationPo.getFscOrderId());
                if (payAmountMap.get(relationPo.getFscOrderId()) != null) {
                    payAmountMap.put(relationPo.getFscOrderId(), ((BigDecimal)payAmountMap.get(relationPo.getFscOrderId())).add(relationPo.getPayAmount() == null ? BigDecimal.ZERO : relationPo.getPayAmount()));
                    continue;
                }
                payAmountMap.put(relationPo.getFscOrderId(), relationPo.getPayAmount() == null ? BigDecimal.ZERO : relationPo.getPayAmount());
            }
            FscOrderPO queryPo = new FscOrderPO();
            queryPo.setFscOrderIds(fscOrderIds);
            List fscOrderPoList = this.fscOrderMapper.getList(queryPo);
            if (CollectionUtils.isEmpty((Collection)fscOrderPoList)) {
                fscOrderPoList = relationList.get(0) != null && FscConstants.ShouldPayType.PAYMENT_GRADING_PAY.equals(((FscOrderPayRelationPO)relationList.get(0)).getShouldPayType()) ? this.fscOrderMapper.selectSettleInfoByOrderIds(fscOrderIds, fscOrderPo.getPayeeId()) : this.fscOrderMapper.selectSettleInfoByInspectionIds(fscOrderIds, fscOrderPo.getPayeeId());
            }
            for (FscOrderPO fscOrder : fscOrderPoList) {
                BigDecimal amount = (BigDecimal)payAmountMap.get(fscOrder.getFscOrderId());
                if (amount == null) {
                    amount = (BigDecimal)payAmountMap.get(fscOrder.getAcceptOrderId());
                }
                FscPurchasePaymentSettleBO settleBO = new FscPurchasePaymentSettleBO();
                settleBO.setEG_BALANCE_NUM(fscOrder.getOrderNo());
                settleBO.setPC_SETTLE_NAME("");
                settleBO.setBALANCE_AMT(this.dealAmount(fscOrder.getTotalCharge()));
                settleBO.setAMOUNT(this.dealAmount(amount));
                settleBO.setBAL_REAMOUNT(this.dealAmount(fscOrder.getTotalCharge().subtract(fscOrder.getPaidAmount() == null ? BigDecimal.ZERO : fscOrder.getPaidAmount()).subtract(settleBO.getAMOUNT())));
                settleBO.setEG_ID(fscOrder.getFscOrderId());
                settleBO.setORG_ID(purchasePaymentBO.getORG_ID());
                settleBO.setORG_NAME(purchasePaymentBO.getORG_NAME());
                settleBO.setEG_PAYMENT_NUM(purchasePaymentBO.getEG_PAYMENT_NUM());
                settleBO.setCONTRACT_NAME("");
                settleBO.setCONTRACT_NUM("");
                settleBO.setCONTRACT_AMOUNT("");
                settleBOList.add(settleBO);
            }
            ArrayList<FscPurchasePaymentLineBO> paymentLineBOList = new ArrayList<FscPurchasePaymentLineBO>();
            FscPurchasePaymentLineBO paymentLineBO = new FscPurchasePaymentLineBO();
            if (fscOrderPo.getPaymentMethod() != null) {
                eternalPo.setPCode("FSC_PAYMENT_TYPE");
                Map<String, String> payMethodMap = this.getDicMap(eternalPo);
                paymentLineBO.setPAY_MODE(payMethodMap.get(fscOrderPo.getPaymentMethod().toString()));
            }
            paymentLineBO.setPAYEE_ID(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
            paymentLineBO.setPAYEE_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
            paymentLineBO.setBANK_ACCOUNT_ID(null);
            paymentLineBO.setBANK_ACCOUNT_NAME(fscOrderPo.getPayeeAccountName());
            paymentLineBO.setBANK_ACCOUNT_NUM(fscOrderPo.getPayeeBankAccount());
            paymentLineBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
            paymentLineBO.setAMOUNT(this.dealAmount(fscOrderPo.getTotalCharge()));
            paymentLineBO.setTESCO_ID(fscOrderPo.getFscOrderId());
            paymentLineBO.setBANK_ID("");
            paymentLineBO.setBANK_ACC_ID("");
            paymentLineBO.setBANK_ACC_NAME("");
            paymentLineBO.setBANK_ACC("");
            paymentLineBO.setORG_NAME(purchasePaymentBO.getORG_NAME());
            paymentLineBO.setORG_ID(purchasePaymentBO.getORG_ID());
            paymentLineBO.setEG_PAYMENT_NUM(purchasePaymentBO.getEG_PAYMENT_NUM());
            paymentLineBO.setEG_PAYMENT_ID(purchasePaymentBO.getEG_PAYMENT_ID() + "");
            paymentLineBO.setUSER_ID(purchasePaymentBO.getUSER_ID());
            paymentLineBOList.add(paymentLineBO);
            payBillReqBO.setPurchasePayment(purchasePaymentBO);
            payBillReqBO.setPurchasePaymentSettlementInfo(paymentLineBOList);
            payBillReqBO.setPurchasePaymentInfo(settleBOList);
            payBillReqBO.setUserId(fscOrderPo.getPayerId());
            if (fscOrderPo.getPaymentMethod() != null && fscOrderPo.getPaymentMethod() == 2) {
                FscDraftInfoPO infoPO = new FscDraftInfoPO();
                infoPO.setFscOrderId(fscOrderPo.getFscOrderId());
                List infoPOS = this.fscDraftInfoMapper.selectList(infoPO);
                if (!CollectionUtils.isEmpty((Collection)infoPOS)) {
                    payBillReqBO.setBillInfo(infoPOS.stream().map(x -> {
                        BillInfoYCBo draftLineBO = new BillInfoYCBo();
                        draftLineBO.setBILL_ID(x.getDraftId());
                        return draftLineBO;
                    }).collect(Collectors.toList()));
                }
            }
            ArrayList ceLine = new ArrayList();
            ArrayList annexBOS = new ArrayList();
            payBillReqBO.setCeline(ceLine);
            payBillReqBO.setFileList(annexBOS);
            payBillRspBO = this.dealParamToPayYc(fscOrderPo.getFscOrderId(), payBillReqBO, fscPushLogPO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u4ed8\u6b3e\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff1a" + FscCommonUtils.dealStackTrace((Exception)e));
            this.saveFailLog(fscOrderPo.getFscOrderId(), e.getMessage());
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                this.dealFailFlow(fscOrderPo, reqBO);
            }
            FscPushYcPayBillBusiRspBO rspBO = new FscPushYcPayBillBusiRspBO();
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.FAIL, fscPushLogPO);
            rspBO.setRespDesc("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("190000");
            return rspBO;
        }
        if (!payBillRspBO.getRespCode().equals("0000")) {
            this.saveFailLog(fscOrderPo.getFscOrderId(), payBillRspBO.getRespDesc());
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.FAIL, fscPushLogPO);
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                this.dealFailFlow(fscOrderPo, reqBO);
            }
        } else if (fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.SUCCESS, fscPushLogPO);
            this.dealSuccessFlow(fscOrderPo, reqBO);
        } else {
            this.insertPushLog(fscOrderPo, FscConstants.FscPushStatus.SUCCESS, fscPushLogPO);
        }
        return (FscPushYcPayBillBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)payBillRspBO), FscPushYcPayBillBusiRspBO.class));
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalTitle));
    }

    public void saveFailLog(Long fscOrderId, String failReason) {
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(fscOrderId);
        orderPo.setFailReason(failReason);
        this.fscOrderMapper.updateById(orderPo);
    }

    public void insertPushLog(FscOrderPO fscOrderPO, Integer status, FscPushLogPO fscPushLogPO) {
        fscPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPushLogPO.setObjectId(fscOrderPO.getFscOrderId());
        fscPushLogPO.setObjectNo(fscOrderPO.getOrderNo());
        fscPushLogPO.setCreateTime(new Date());
        fscPushLogPO.setStatus(status);
        fscPushLogPO.setType(FscConstants.FscPushType.PAY);
        this.fscPushLogMapper.insert(fscPushLogPO);
    }

    public BigDecimal dealAmount(BigDecimal amount) {
        return amount == null ? BigDecimal.ZERO : amount.setScale(2, RoundingMode.DOWN);
    }

    private void dealSuccessFlow(FscOrderPO fscOrderPo, FscPushYcPayBillBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getInitFlag())) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
            flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME_MAIN);
            flowAtomReqBO.setBusiCode(BUSI_CODE_MAIN);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
    }

    private void dealFailFlow(FscOrderPO fscOrderPo, FscPushYcPayBillBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getInitFlag())) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
            flowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_REGISTER);
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag5);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
    }

    public static void main(String[] args) {
        FscPushYcPrePayBillRspBO billRspBO = new FscPushYcPrePayBillRspBO();
        System.out.println(JSONObject.toJSONString((Object)billRspBO));
    }

    private FscPushUnifyPayBillRspBO dealParamToPreYc(Long fscOrderId, FscPushYcPrePayBillReqBO prePayBillReqBO, FscPushLogPO fscPushLogPO) {
        FscOrderExtPO orderExtPOReqBO = new FscOrderExtPO();
        orderExtPOReqBO.setFscOrderId(fscOrderId);
        FscOrderExtPO orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPOReqBO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6269\u5c55\u76f8\u5173\u4fe1\u606f\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)prePayBillReqBO.getPurchaseAdPayment());
        jsonObject.put("conLine", (Object)prePayBillReqBO.getPurchaseAdPaymentLine());
        jsonObject.put("celine", (Object)prePayBillReqBO.getCeline());
        jsonObject.put("fileList", (Object)prePayBillReqBO.getFileList());
        jsonObject.put("billInfo", (Object)prePayBillReqBO.getBillInfo());
        jsonArray.add((Object)jsonObject);
        fscPushLogPO.setObjData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPO.setPushParseData(encryPtionRspBO.getData());
        FscPushUnifyPrePayBillReqBO pushUnifyPrePayBillReqBO = new FscPushUnifyPrePayBillReqBO();
        pushUnifyPrePayBillReqBO.setData(encryPtionRspBO.getData());
        pushUnifyPrePayBillReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscPushUnifyPayBillRspBO fscPushUnifyPayBillRspBO = this.fscPushUnifyPrePayBillService.pushUnifyPrePayBill(pushUnifyPrePayBillReqBO);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(fscPushUnifyPayBillRspBO.getRespCode()) ? fscPushUnifyPayBillRspBO.getData() : fscPushUnifyPayBillRspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPO.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPO.setRespParseData(fscPushUnifyPayBillRspBO.getRspData());
        fscPushUnifyPayBillRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        return fscPushUnifyPayBillRspBO;
    }

    private FscPushUnifyPayBillRspBO dealParamToPayYc(Long fscOrderId, FscPushYcPayBillReqBO payBillReqBO, FscPushLogPO fscPushLogPO) {
        FscOrderExtPO orderExtPOReqBO = new FscOrderExtPO();
        orderExtPOReqBO.setFscOrderId(fscOrderId);
        FscOrderExtPO orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPOReqBO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6269\u5c55\u76f8\u5173\u4fe1\u606f\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillReqBO.getPurchasePayment());
        jsonObject.put("conLine", (Object)payBillReqBO.getPurchasePaymentInfo());
        jsonObject.put("payLine", (Object)payBillReqBO.getPurchasePaymentSettlementInfo());
        jsonObject.put("celine", (Object)payBillReqBO.getCeline());
        jsonObject.put("fileList", (Object)payBillReqBO.getFileList());
        jsonObject.put("billInfo", (Object)payBillReqBO.getBillInfo());
        jsonArray.add((Object)jsonObject);
        fscPushLogPO.setObjData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPO.setPushParseData(encryPtionRspBO.getData());
        FscPushUnifyPayBillReqBO pushUnifyPrePayBillReqBO = new FscPushUnifyPayBillReqBO();
        pushUnifyPrePayBillReqBO.setData(encryPtionRspBO.getData());
        pushUnifyPrePayBillReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscPushUnifyPayBillRspBO fscPushUnifyPayBillRspBO = this.fscPushUnifyPayBillService.pushUnifyPayBill(pushUnifyPrePayBillReqBO);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(fscPushUnifyPayBillRspBO.getRespCode()) ? fscPushUnifyPayBillRspBO.getData() : fscPushUnifyPayBillRspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPO.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPO.setRespParseData(fscPushUnifyPayBillRspBO.getRspData());
        fscPushUnifyPayBillRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        return fscPushUnifyPayBillRspBO;
    }
}

