/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillGetYcPersonInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscNewYcUpdateCashService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillDeleteService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimDeleteBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimDeleteBusiServiceImpl
implements FscRecvClaimDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimDeleteBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscPushYcRecvClaimBillDeleteService fscPushYcRecvClaimBillDeleteService;
    @Autowired
    private FscBillGetYcPersonInfoService fscBillGetYcPersonInfoService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscNewYcUpdateCashService fscNewYcUpdateCashService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;

    @Override
    public FscRecvClaimDeleteBusiRspBO recvClaimDelete(FscRecvClaimDeleteBusiReqBO reqBO) {
        ArrayList<FscRecvClaimPO> fscRecvClaimPos = new ArrayList();
        fscRecvClaimPos = this.fscRecvClaimMapper.queryByIds(reqBO.getClaimIds());
        this.val(fscRecvClaimPos, reqBO);
        QryUnifySettleTokenAbilityReqBO tokenReqBO = new QryUnifySettleTokenAbilityReqBO();
        tokenReqBO.setUserId(reqBO.getAgentAccount());
        QryUnifySettleTokenAbilityRspBO tokenRspBO = this.fscUnifySettleTokenAbilityService.qryToken(tokenReqBO);
        if (!"0000".equals(tokenRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u83b7\u53d6token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenRspBO.getMsg());
        }
        ArrayList<Long> claimIds = new ArrayList<Long>();
        ArrayList<FscNewYcUpdateCashBO> bos = new ArrayList<FscNewYcUpdateCashBO>();
        FscNewYcUpdateCashReqBO fscNewYcUpdateCashReqBO = new FscNewYcUpdateCashReqBO();
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            claimIds.add(po.getClaimId());
            if (po.getSerialNumberId() == null) continue;
            FscNewYcUpdateCashBO fscNewYcUpdateCashBO = new FscNewYcUpdateCashBO();
            fscNewYcUpdateCashBO.setHEADER_ID(po.getSerialNumberId() + "");
            fscNewYcUpdateCashBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date()));
            bos.add(fscNewYcUpdateCashBO);
        }
        FscRecvClaimPO updateVo = new FscRecvClaimPO();
        updateVo.setClaimIds(claimIds);
        updateVo.setRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        fscNewYcUpdateCashReqBO.setBos(bos);
        fscNewYcUpdateCashReqBO.setToken(tokenRspBO.getData());
        FscNewYcUpdateCashRspBO fscNewYcUpdateCashRspBO = this.fscNewYcUpdateCashService.updateCash(fscNewYcUpdateCashReqBO);
        if (!fscNewYcUpdateCashRspBO.getRespCode().equals("0000")) {
            this.saveLog((FscRecvClaimPO)fscRecvClaimPos.get(0), FscConstants.FscPushStatus.FAIL, JSONObject.toJSONString((Object)fscNewYcUpdateCashReqBO));
            updateVo.setPushStatus(FscConstants.FscPushStatus.FAIL.toString());
        } else {
            updateVo.setPushStatus(FscConstants.FscPushStatus.SUCCESS.toString());
            this.saveLog((FscRecvClaimPO)fscRecvClaimPos.get(0), FscConstants.FscPushStatus.SUCCESS, JSONObject.toJSONString((Object)fscNewYcUpdateCashReqBO));
        }
        this.fscRecvClaimMapper.updateStatusBatch(updateVo);
        FscRecvClaimDeleteBusiRspBO rspBO = new FscRecvClaimDeleteBusiRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void val(List<FscRecvClaimPO> fscRecvClaimPos, FscRecvClaimDeleteBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscRecvClaimPos) || reqBO.getClaimIds().size() != fscRecvClaimPos.size()) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u5355\u76f8\u5173\u4fe1\u606f");
        }
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            if (StringUtils.isEmpty((Object)po.getRecvStatus()) || FscClaimRecvStatusEnum.DELETE.getCode().equals(po.getRecvStatus())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u6536\u6b3e\u72b6\u6001\u5f02\u5e38");
            }
            if (!StringUtils.isEmpty((Object)po.getClaimStatus()) && FscClaimStatusEnum.NOT_CLAIM.getCode().equals(po.getClaimStatus())) continue;
            throw new FscBusinessException("190000", "\u53ea\u80fd\u5220\u9664\u672a\u8ba4\u9886\u7684\u8ba4\u9886\u5355");
        }
    }

    private void saveLog(FscRecvClaimPO fscRecvClaimPo, Integer status, String jsonStr) {
        try {
            FscPushLogPO fscPushLogPo = new FscPushLogPO();
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimPo.getClaimId());
            fscPushLogPo.setObjectNo(fscRecvClaimPo.getClaimNo());
            fscPushLogPo.setType(FscConstants.FscPushType.SERIAL_NUMBER_OCCUPY);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            fscPushLogPo.setObjData(jsonStr);
            this.fscPushLogMapper.insert(fscPushLogPo);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }
}

