/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.bo.FscDictionaryBusiReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscDictionaryAbilityService"})
public class FscDictionaryAbilityServiceImpl
implements FscDictionaryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDictionaryAbilityServiceImpl.class);
    @Autowired
    private FscDictionaryBusiService dictionaryBusiService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"queryBypCodeBackPo"})
    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPo(@RequestBody FscQueryDictionaryAbilityReqBO abilityReqBO) {
        FscRspPageBaseBO result = new FscRspPageBaseBO();
        List busiList = this.dictionaryBusiService.queryBypCodeBackPo("FSC", abilityReqBO.getPcode(), abilityReqBO.getTitle());
        result.setRows(busiList);
        return result;
    }

    @PostMapping(value={"queryBypCodeBackPoPage"})
    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPoPage(@RequestBody FscQueryDictionaryAbilityReqBO abilityReqBO) {
        FscRspPageBaseBO result = new FscRspPageBaseBO();
        FscDictionaryBusiReqBO dictionaryBusiReqBO = new FscDictionaryBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)dictionaryBusiReqBO);
        FscRspPageBaseBO busiList = this.dictionaryBusiService.queryBypCodeBackPoPage(dictionaryBusiReqBO);
        BeanUtils.copyProperties((Object)busiList, (Object)result);
        return result;
    }

    @PostMapping(value={"updateDicDictionary"})
    public FscDictionaryAbilityRspBO updateDicDictionary(@RequestBody FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        fscDicDictionaryReqBO.setSysCode("FSC");
        fscDicDictionaryReqBO.setDelflag(FscConstants.DicDelFlag.YES);
        int result = this.dictionaryBusiService.updateDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u4fee\u6539\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @PostMapping(value={"deleteDicDictionary"})
    public FscDictionaryAbilityRspBO deleteDicDictionary(@RequestBody FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        int result = this.dictionaryBusiService.deleteDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u5220\u9664\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @PostMapping(value={"addDicDictionary"})
    public FscDictionaryAbilityRspBO addDicDictionary(@RequestBody FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult > 0) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        fscDicDictionaryReqBO.setDelflag(FscConstants.DicDelFlag.YES);
        fscDicDictionaryReqBO.setSysCode("FSC");
        int result = this.dictionaryBusiService.addDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("190000");
            dictionaryAbilityRspBO.setRespDesc("\u65b0\u589e\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @PostMapping(value={"queryBypCodeBackMap"})
    public Map<String, String> queryBypCodeBackMap(@RequestBody String pCode) {
        return this.dictionaryBusiService.queryBypCodeBackMap("FSC", pCode);
    }

    @PostMapping(value={"queryByBackMap"})
    public Map<String, String> queryByBackMap(@RequestBody FscQueryDictionaryAbilityReqBO reqBO) {
        return this.dictionaryBusiService.queryBypCodeBackMap("FSC", reqBO.getPcode());
    }

    @PostMapping(value={"queryDicByCache"})
    public List<FscDicDictionaryBO> queryDicByCache(@RequestBody String pCode) {
        if (StringUtils.isBlank((CharSequence)pCode)) {
            return new ArrayList<FscDicDictionaryBO>();
        }
        Object obj = this.cacheClient.get("PES_FSC_DIC_CACHE_REDIS_" + pCode);
        List busiList = (ArrayList)obj;
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            busiList = this.dictionaryBusiService.queryBypCodeBackPo("FSC", pCode, "");
            if (CollectionUtils.isEmpty((Collection)busiList)) {
                busiList = new ArrayList();
            }
            this.cacheClient.set("PES_UMC_DIC_CACHE_REDIS_" + pCode, busiList);
        }
        return busiList;
    }

    @PostMapping(value={"delCacheDic"})
    public FscDictionaryAbilityRspBO delCacheDic(@RequestBody FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        fscDicDictionaryReqBO.getPcodeList().forEach(pcode -> this.cacheClient.delete(pcode));
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        return dictionaryAbilityRspBO;
    }

    private void validationParamsInvoice(FscDicDictionaryReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new FscBusinessException("191000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[pcode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new FscBusinessException("191000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[code]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

