/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustPageReqBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustPageRspBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageReqBo;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageRspBo;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageRspBoList;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService"})
public class FscFinanceWriteOffPageAbilityServiceImpl
implements FscFinanceWriteOffPageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffPageAbilityServiceImpl.class);
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;

    @PostMapping(value={"financeWriteOffQryPage"})
    public FscFinanceWriteOffPageRspBo financeWriteOffQryPage(@RequestBody FscFinanceWriteOffPageReqBo reqBO) {
        ArrayList<Integer> orderTypeList;
        if (null == reqBO.getBillType()) {
            throw new FscBusinessException("190000", "\u5355\u636e\u7c7b\u578bbillType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscComOrderListPageQueryBusiReqBO qryReqBO = (FscComOrderListPageQueryBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscComOrderListPageQueryBusiReqBO.class);
        if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("1")) {
            orderTypeList = new ArrayList<Integer>();
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR_GOODS);
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR);
            qryReqBO.setOrderTypeList(orderTypeList);
            qryReqBO.setNoSettlePlatform(Integer.valueOf(2));
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("2")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.TH);
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("11")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
            qryReqBO.setTradeMode(Integer.valueOf(2));
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("5")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
        } else if (reqBO.getOrderBusiType() != null) {
            orderTypeList = new ArrayList();
            orderTypeList.add(reqBO.getOrderBusiType());
            qryReqBO.setOrderTypeList(orderTypeList);
        }
        qryReqBO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        qryReqBO.setFinanceWriteOffFlag(reqBO.getBillType());
        FscComOrderListPageQueryBusiRspBO orderList = this.fscEsQryComOrderListBusiService.esQryComOrderList(qryReqBO);
        FscFinanceWriteOffPageRspBo rspBO = new FscFinanceWriteOffPageRspBo();
        List collect = orderList.getRows().stream().map(e -> {
            log.info("FscComOrderListBO:{}", e);
            FscFinanceWriteOffPageRspBoList bo = (FscFinanceWriteOffPageRspBoList)BeanUtil.copyProperties((Object)e, FscFinanceWriteOffPageRspBoList.class);
            bo.setCreateOperTime(e.getCreateTime());
            bo.setBusinessType(e.getOrderBusiType());
            bo.setBusinessTypeStr(e.getOrderBusiTypeStr());
            bo.setBillAmount(null == e.getTotalChargeBill() ? BigDecimal.ZERO : e.getTotalChargeBill().setScale(2, 4));
            if (null == e.getPurPrePayAmount() || null == e.getPurWriteOffAmount()) {
                bo.setPaidAmount(BigDecimal.ZERO);
                bo.setPaidWriteOffAmount(BigDecimal.ZERO);
                bo.setRemainWriteOffAmount(BigDecimal.ZERO);
                return bo;
            }
            bo.setRemainWriteOffAmount(e.getPurNotWriteOffAmount());
            FscOrderFinancePO fscOrderFinancePo = new FscOrderFinancePO();
            fscOrderFinancePo.setFscOrderId(e.getFscOrderId());
            FscOrderFinancePO financePO = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePo);
            if (null == financePO || null == financePO.getExchangeRate()) {
                log.info("\u83b7\u53d6\u6c47\u7387\u5b57\u6bb5\u5931\u8d25,fscOrderId{}", (Object)e.getFscOrderId());
                return bo;
            }
            bo.setPaidWriteOffAmount(e.getPurWriteOffAmount().multiply(financePO.getExchangeRate()).setScale(2, 4));
            bo.setPaidAmount(e.getPurPrePayAmount().multiply(financePO.getExchangeRate()).setScale(2, 4));
            return bo;
        }).collect(Collectors.toList());
        rspBO.setRows(collect);
        rspBO.setTotal(orderList.getTotal());
        rspBO.setPageNo(orderList.getPageNo());
        rspBO.setRecordsTotal(orderList.getRecordsTotal());
        return rspBO;
    }

    @PostMapping(value={"financeWriteOffAdjustQryPage"})
    public FscFinanceWriteOffAdjustPageRspBO financeWriteOffAdjustQryPage(@RequestBody FscFinanceWriteOffAdjustPageReqBO reqBo) {
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = this.checkThis(reqBo);
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List list = this.fscFinanceWriteOffAdjustMapper.financeWriteOffAdjustQryPage(fscFinanceWriteOffAdjustPO, page);
        List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscFinanceWriteOffAdjustBO.class);
        FscFinanceWriteOffAdjustPageRspBO rspBO = new FscFinanceWriteOffAdjustPageRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBo.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscFinanceWriteOffAdjustPO checkThis(FscFinanceWriteOffAdjustPageReqBO reqBo) {
        if (reqBo.getTabId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[tabId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = (FscFinanceWriteOffAdjustPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBo), FscFinanceWriteOffAdjustPO.class);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        if (reqBo.getTabId() == 1) {
            billStatusList.add(FscConstants.WriteOffBillStatus.TO_AUDIT);
            fscFinanceWriteOffAdjustPO.setBillStatusList(billStatusList);
        } else if (reqBo.getTabId() == 2) {
            billStatusList.add(FscConstants.WriteOffBillStatus.AUDIT_FAIL);
            fscFinanceWriteOffAdjustPO.setBillStatusList(billStatusList);
        }
        return fscFinanceWriteOffAdjustPO;
    }
}

