/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.common.ability.api.FscRefundSyncChangeItemAbilityService;
import com.tydic.fsc.common.ability.bo.FscRefundSyncChangeItemAbilityBO;
import com.tydic.fsc.common.ability.bo.FscRefundSyncChangeItemAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundSyncChangeItemAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRefundSyncChangeItemBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRefundSyncChangeItemAbilityService"})
public class FscRefundSyncChangeItemAbilityServiceImpl
implements FscRefundSyncChangeItemAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundSyncChangeItemAbilityServiceImpl.class);
    @Autowired
    private FscRefundSyncChangeItemBusiService fscRefundSyncChangeItemBusiService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @PostMapping(value={"syncRefundChangeItem"})
    public FscRefundSyncChangeItemAbilityRspBO syncRefundChangeItem(@RequestBody FscRefundSyncChangeItemAbilityReqBO reqBO) {
        this.valid(reqBO);
        String rspStr = null;
        try {
            this.valid(reqBO);
            FscRefundSyncChangeItemAbilityRspBO rspBO = this.fscRefundSyncChangeItemBusiService.syncRefundChangeItem(reqBO);
            rspStr = JSONObject.toJSONString((Object)rspBO);
            FscRefundSyncChangeItemAbilityRspBO fscRefundSyncChangeItemAbilityRspBO = rspBO;
            return fscRefundSyncChangeItemAbilityRspBO;
        }
        catch (Exception e) {
            rspStr = e.getMessage();
            throw new FscBusinessException("191000", e.getMessage());
        }
        finally {
            this.saveLog(reqBO, rspStr);
        }
    }

    private void valid(FscRefundSyncChangeItemAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeItemList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[infoBos]\u4e3a\u7a7a");
        }
        for (FscRefundSyncChangeItemAbilityBO bo : reqBO.getChangeItemList()) {
            if (bo.getChangeItemId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[changeItemId]\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)bo.getYcChangeItemId())) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[ycChangeItemId]\u4e3a\u7a7a");
        }
    }

    private void saveLog(FscRefundSyncChangeItemAbilityReqBO reqBO, String rspStr) {
        try {
            FscBillDealPushLogAbilityReqBO fscBillDealPushLogAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
            fscBillDealPushLogAbilityReqBO.setObjectId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBillDealPushLogAbilityReqBO.setType(FscConstants.FscPushType.YC_CHANGE_ITEM);
            fscBillDealPushLogAbilityReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
            fscBillDealPushLogAbilityReqBO.setRespData(rspStr);
            fscBillDealPushLogAbilityReqBO.setCreateTime(new Date());
            this.fscBillAddPushLogAbilityService.savePushLog(fscBillDealPushLogAbilityReqBO);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
        }
    }
}

