/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.busibase.external.impl.esb.FscGetErpCustInfoServiceImpl;
import com.tydic.fsc.common.ability.api.finance.FscFinanceBankListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBankListDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBankListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBankListQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceBankListResultVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EntityToMapUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceBankListQryAbilityService"})
public class FscFinanceBankListQryAbilityServiceImpl
implements FscFinanceBankListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetErpCustInfoServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceBankList"})
    public FscFinanceBankListQryRspBO qryFinanceBankList(@RequestBody FscFinanceBankListQryReqBO reqBO) {
        FscFinanceBankListQryRspBO rspBO;
        this.valid(reqBO);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", financeShareTokenRspBO.getToken());
        log.info("\u83b7\u53d6Token\u4fe1\u606f\uff1a{}", (Object)financeShareTokenRspBO.getToken());
        HashMap paramMap = EntityToMapUtil.entityToMap((Object)reqBO);
        paramMap.remove("orgIdWeb");
        paramMap.put("orgId", reqBO.getOrgIdWeb());
        paramMap.put("interbankName", reqBO.getInterbankName());
        paramMap.put("accountNo", reqBO.getAccountNo());
        String param = EntityToMapUtil.transferParam((HashMap)paramMap);
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)param);
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(domainUrl + this.fscShareFinanceServiceConfiguration.getBa106()));
        String respStr = SSLClient.doGet((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getBa106() + param), headerMap);
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u62a5\u6587\uff1a{}", (Object)respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("191138", "\u83b7\u53d6\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            rspBO = this.resolveRreRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private void valid(FscFinanceBankListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrgIdWeb() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d22\u52a1\u5171\u4eab\u7ec4\u7ec7\u673a\u6784ID[orgIdWeb]\u4e3a\u7a7a");
        }
    }

    private FscFinanceBankListQryRspBO resolveRreRsp(String respStr) {
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscFinanceBankListQryRspBO rspBO = new FscFinanceBankListQryRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!Objects.equals(jsonObject.getString("code"), "0")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u67e5\u8be2\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01" + jsonObject.getString("msg"));
            return rspBO;
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List resultVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data), FscFinanceBankListResultVO.class);
        List detailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resultVOList), FscFinanceBankListDetailBO.class);
        rspBO.setBankList(detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u89e3\u6790\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u6570\u636e\u96c6\u5408\uff1a{}", (Object)detailList);
        return rspBO;
    }
}

