/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractHtGetTokenAbilityService;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityRspBO;
import com.tydic.fsc.common.atom.api.FscPushContractAtomService;
import com.tydic.fsc.common.atom.bo.FscPushContractAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractAtomRspBO;
import com.tydic.fsc.common.atom.bo.FscPushContractPayAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractPayAtomRspBO;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushContractAtomServiceImpl
implements FscPushContractAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPushContractAtomServiceImpl.class);
    @Value(value="${fsc_push_settle_contract_url:http://172.16.91.230:28880/}")
    private String pushSettleUrl;
    @Value(value="${fsc_push_pay_contract_url:http://172.16.91.230:28880/}")
    private String pushPayUrl;
    private static final String RSP_SUCCESS_CODE = "S";
    @Autowired
    private ContractHtGetTokenAbilityService contractHtGetTokenAbilityService;

    @Override
    public FscPushContractAtomRspBO pushContract(FscPushContractAtomReqBO reqBO) {
        FscPushContractAtomRspBO rspBO = new FscPushContractAtomRspBO();
        try {
            log.info("-----------\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5165\u53c2---------------{}", (Object)JSONObject.toJSONString((Object)reqBO));
            String token = this.getToken();
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", token);
            HashMap<String, String> reqMap = new HashMap<String, String>();
            reqMap.put("payload", JSON.toJSONString((Object)reqBO));
            log.info("-----------\u4ed8\u6b3e\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3map\u5165\u53c2---------------{}", (Object)JSONObject.toJSONString(reqMap));
            String result = SSLClient.doPostWithHeadMap((String)this.pushSettleUrl, (String)JSONObject.toJSONString(reqMap), headMap);
            log.info("-----------\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u51fa\u53c2---------------{}", (Object)result);
            if (Objects.isNull(result)) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8bf7\u6c42\u65e0\u54cd\u5e94\uff01");
            } else {
                JSONObject resultJSON = JSONObject.parseObject((String)result);
                JSONObject payloadJSON = resultJSON.getJSONObject("payload");
                if (payloadJSON != null) {
                    if (RSP_SUCCESS_CODE.equals(payloadJSON.getString("code"))) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u6210\u529f");
                    } else {
                        rspBO.setRespCode("190000");
                        rspBO.setRespDesc(payloadJSON.getString("desc"));
                    }
                } else {
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("payload\u51fa\u53c2\u4e3a\u7a7a");
                }
                rspBO.setRespData(JSON.toJSONString((Object)result));
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
            log.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3,\u539f\u56e0\u4e3a:" + e);
        }
        return rspBO;
    }

    @Override
    public FscPushContractPayAtomRspBO pushContractPay(FscPushContractPayAtomReqBO reqBO) {
        FscPushContractPayAtomRspBO rspBO = new FscPushContractPayAtomRspBO();
        try {
            log.info("-----------\u4ed8\u6b3e\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5165\u53c2---------------{}", (Object)JSONObject.toJSONString((Object)reqBO));
            String token = this.getToken();
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", token);
            HashMap<String, String> reqMap = new HashMap<String, String>();
            reqMap.put("payload", JSON.toJSONString((Object)reqBO));
            log.info("-----------\u4ed8\u6b3e\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3map\u5165\u53c2---------------{}", (Object)JSONObject.toJSONString(reqMap));
            String result = SSLClient.doPostWithHeadMap((String)this.pushPayUrl, (String)JSONObject.toJSONString(reqMap), headMap);
            log.info("-----------\u4ed8\u6b3e\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u51fa\u53c2---------------{}", (Object)result);
            if (Objects.isNull(result)) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8bf7\u6c42\u65e0\u54cd\u5e94\uff01");
            } else {
                JSONObject resultJSON = JSONObject.parseObject((String)result);
                JSONObject payloadJSON = resultJSON.getJSONObject("payload");
                if (payloadJSON != null) {
                    if (RSP_SUCCESS_CODE.equals(payloadJSON.getString("code"))) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u6210\u529f");
                    } else {
                        rspBO.setRespCode("190000");
                        rspBO.setRespDesc(payloadJSON.getString("desc"));
                    }
                } else {
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("payload\u51fa\u53c2\u4e3a\u7a7a");
                }
                rspBO.setRespData(JSON.toJSONString((Object)result));
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
            log.error("\u4ed8\u6b3e\u5355\u63a8\u9001\u5408\u540c\u4e2d\u5fc3,\u539f\u56e0\u4e3a:" + e);
        }
        return rspBO;
    }

    private String getToken() {
        ContractHtGetTokenAbilityReqBO abilityReqBO = new ContractHtGetTokenAbilityReqBO();
        ContractHtGetTokenAbilityRspBO abilityRspBO = this.contractHtGetTokenAbilityService.getHTToken(abilityReqBO);
        if (!StringUtils.isEmpty((Object)abilityRspBO.getToken())) {
            return abilityRspBO.getToken();
        }
        throw new ZTBusinessException("\u83b7\u53d6token\u5931\u8d25");
    }
}

