/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscPushUnifyFailBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyFailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyFailBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscPayOrderStateTyEnum;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uoc.base.constants.UocCoreConstant;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPushUnifyFailBusiServiceImpl
implements FscPushUnifyFailBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyFailBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97";
    public static final String BUSI_CODE = "1214";

    @Override
    public FscPushUnifyFailBusiRspBO dealPushUnifyFail(FscPushUnifyFailBusiReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(reqBO.getFscOrderId());
        orderExtPO.setFailReason(reqBO.getFailMsg());
        orderExtPO.setUnifyPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        this.fscOrderExtMapper.updateById(orderExtPO);
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(orderPO.getFscOrderId());
        pushLogPo.setObjectNo(orderPO.getOrderNo());
        pushLogPo.setPushData(reqBO.getFailMsg());
        pushLogPo.setType(reqBO.getPushType());
        pushLogPo.setPushStatus(FscConstants.FscPushStatus.FAIL);
        pushLogPo.setCreateTime(new Date());
        this.fscPurchasePushLogMapper.insert(pushLogPo);
        if (orderPO.getOrderState().equals(FscPayOrderStateTyEnum.TY_PUSHING.getCode())) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(orderPO.getFscOrderId());
            flowAtomReqBO.setCurStatus(orderPO.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
            paramMap.put("pushResult", FscConstants.UnifyPushResult.FAIL);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u7ed3\u7b97\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        FscPushUnifyFailBusiRspBO rspBO = new FscPushUnifyFailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscPushUnifyFailBusiRspBO dealPushUnifyChargeFail(FscPushUnifyFailBusiReqBO reqBO) {
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargePO chargePO = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        FscAccountChargePO extPO = new FscAccountChargePO();
        extPO.setChargeId(reqBO.getChargeId());
        extPO.setUnifyPushStatus(FscConstants.FscPushStatus.FAIL);
        extPO.setFailReason(reqBO.getFailMsg());
        this.fscAccountChargeMapper.update(extPO);
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(chargePO.getChargeId());
        pushLogPo.setObjectNo(chargePO.getAdvanceDepositNo());
        pushLogPo.setPushData(reqBO.getFailMsg());
        pushLogPo.setType(reqBO.getPushType());
        pushLogPo.setPushStatus(FscConstants.FscPushStatus.FAIL);
        pushLogPo.setCreateTime(new Date());
        this.fscPurchasePushLogMapper.insert(pushLogPo);
        FscPushUnifyFailBusiRspBO rspBO = new FscPushUnifyFailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

