/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcAttachmentReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcAttachmentRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcAttachmentService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.busi.api.FscPushYcAttachmentBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcAttachmentBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcAttachmentBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentExternalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentExternalPO;
import com.tydic.fsc.po.FscPushLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcAttachmentBusiServiceImpl
implements FscPushYcAttachmentBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcAttachmentBusiServiceImpl.class);
    @Autowired
    private FscAttachmentExternalMapper fscAttachmentExternalMapper;
    @Autowired
    private FscPushYcAttachmentService fscPushYcAttachmentService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;

    @Override
    public FscPushYcAttachmentBusiRspBO dealPushYcAttachment(FscPushYcAttachmentBusiReqBO reqBO) {
        FscUnifySettleDecryptionRspBO decryptionRspBO;
        FscPushYcAttachmentBusiRspBO rspBO = new FscPushYcAttachmentBusiRspBO();
        FscAttachmentExternalPO externalPO = new FscAttachmentExternalPO();
        if (FscConstants.FSC_YC_FILE_TYPE.PUCHASE_CONTRACT_TZ_CHANGE.equals(reqBO.getObjType())) {
            externalPO = this.buildExternalPo(reqBO);
        } else {
            externalPO.setObjId(reqBO.getObjId());
            externalPO.setObjType(reqBO.getObjType());
            externalPO = this.fscAttachmentExternalMapper.getModelBy(externalPO);
            if (externalPO != null && externalPO.getPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
                rspBO.setRespCode("0000");
                rspBO.setRespCode("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
                return rspBO;
            }
            if (externalPO == null) {
                externalPO = this.buildExternalPo(reqBO);
            }
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileList", reqBO.getFileList());
        jsonArray.add((Object)jsonObject);
        FscUnifySettleEncryPtionReqBO encryptionReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionReqBO.setData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionReqBO);
        if (!encryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionRspBO.getRespCode(), "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getRespDesc());
        }
        FscPushYcAttachmentReqBO attachmentReqBO = new FscPushYcAttachmentReqBO();
        attachmentReqBO.setData(encryptionRspBO.getData());
        FscPushYcAttachmentRspBO attachmentRspBO = this.fscPushYcAttachmentService.pushYcAttachment(attachmentReqBO);
        FscUnifySettleDecryptionReqBO decryptionReqBO = new FscUnifySettleDecryptionReqBO();
        if (StringUtils.isEmpty((Object)attachmentRspBO.getCode()) || !attachmentRspBO.getCode().equals("200")) {
            externalPO.setPushStatus(FscConstants.FscPushStatus.FAIL);
            decryptionReqBO.setData(attachmentRspBO.getMsg());
            decryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionReqBO);
            externalPO.setFailReason(decryptionRspBO.getData());
        } else {
            externalPO.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            decryptionReqBO.setData(attachmentRspBO.getData());
            decryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionReqBO);
        }
        if (!decryptionRspBO.getRespCode().equals("0000")) {
            log.error("\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionRspBO.getRespDesc());
        }
        FscPushLogPO pushLogPO = this.buildPushLog(reqBO);
        pushLogPO.setStatus(externalPO.getPushStatus());
        pushLogPO.setObjData(jsonArray.toJSONString());
        pushLogPO.setPushParseData(encryptionRspBO.getData());
        pushLogPO.setRespData(decryptionRspBO.getData());
        pushLogPO.setRespParseData(attachmentRspBO.getRespData());
        if (externalPO.getId() == null) {
            externalPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAttachmentExternalMapper.insert(externalPO);
        } else {
            externalPO.setUpdateTime(new Date());
            this.fscAttachmentExternalMapper.updateByPrimaryKey(externalPO);
        }
        this.fscPushLogMapper.insert(pushLogPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscPushLogPO buildPushLog(FscPushYcAttachmentBusiReqBO reqBO) {
        FscPushLogPO pushLogPO = new FscPushLogPO();
        pushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPO.setType(FscConstants.FscPushType.ATTACHMENT);
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setObjectId(reqBO.getObjId());
        pushLogPO.setObjectNo(reqBO.getObjNo());
        return pushLogPO;
    }

    private FscAttachmentExternalPO buildExternalPo(FscPushYcAttachmentBusiReqBO reqBO) {
        FscAttachmentExternalPO externalPO = new FscAttachmentExternalPO();
        externalPO.setObjId(reqBO.getObjId());
        externalPO.setObjType(reqBO.getObjType());
        externalPO.setObjNo(reqBO.getObjNo());
        externalPO.setAgentAccount(reqBO.getAgentAccount());
        externalPO.setAgentName(reqBO.getAgentName());
        externalPO.setCreateTime(new Date());
        externalPO.setUpdateTime(new Date());
        return externalPO;
    }
}

