/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.ability.api.FscAccountChargeApprovalAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeApprovalBusiService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiRspBO;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.po.FscOrderFinancePO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeApprovalAbilityService"})
public class FscAccountChargeApprovalAbilityServiceImpl
implements FscAccountChargeApprovalAbilityService {
    @Autowired
    private FscAccountChargeApprovalBusiService fscAccountChargeApprovalBusiService;
    @Autowired
    private FscFinanceReleasePayInfoBusiService fscFinanceReleasePayInfoBusiService;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TOPIC:FSC_PUSH_FINANCE_CHARGE_TOPIC}")
    private String fscPushFinanceChargeTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TAG:FSC_PUSH_FINANCE_CHARGE_TAG}")
    private String fscPushFinanceChargeTag;
    @Resource(name="fscPushFinanceChargeListMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceChargeListMqServiceProvider;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"dealAccountChargeApproval"})
    public FscAccountChargeApprovalAbilityRspBO dealAccountChargeApproval(@RequestBody FscAccountChargeApprovalAbilityReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscAccountChargeApprovalBusiReqBO busiReqBO = (FscAccountChargeApprovalBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscAccountChargeApprovalBusiReqBO.class));
        FscAccountChargeApprovalBusiRspBO busiRspBO = this.fscAccountChargeApprovalBusiService.dealAccountChargeApproval(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && busiRspBO.getFinish().booleanValue()) {
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderId(reqBO.getChargeId());
            financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
            if (reqBO.getAuditResult() == 0 && financePO != null) {
                FscFinancePushChargeAbilityReqBO abilityReqBO = new FscFinancePushChargeAbilityReqBO();
                abilityReqBO.setChargeId(reqBO.getChargeId());
                this.fscPushFinanceChargeListMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceChargeTopic, this.fscPushFinanceChargeTag, JSONObject.toJSONString((Object)abilityReqBO)));
            } else if (reqBO.getAuditResult() == 1 && financePO != null) {
                FscFinanceReleasePayInfoReqBO infoReqBO = new FscFinanceReleasePayInfoReqBO();
                infoReqBO.setFscOrderId(reqBO.getChargeId());
                this.fscFinanceReleasePayInfoBusiService.dealReleasePayInfo(infoReqBO);
            }
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscAccountChargeApprovalAbilityRspBO)JSONObject.parseObject((String)respString, FscAccountChargeApprovalAbilityRspBO.class);
    }
}

