/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscBillPayRefundApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushNewYcClaimRefundBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillPayRefundApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillPayRefundApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcClaimRefundBillAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscBillPayRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundApprovalBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillPayRefundApprovalAbilityService"})
public class FscBillPayRefundApprovalAbilityServiceImpl
implements FscBillPayRefundApprovalAbilityService {
    @Autowired
    private FscBillPayRefundApprovalBusiService fscBillPayRefundApprovalBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscSyncPushNewYcClaimRefundBillAbilityService fscSyncPushNewYcClaimRefundBillAbilityService;

    @PostMapping(value={"dealPayRefundApproval"})
    public FscBillPayRefundApprovalAbilityRspBO dealPayRefundApproval(@RequestBody FscBillPayRefundApprovalAbilityReqBO reqBO) {
        this.valid(reqBO);
        String errorInfo = "";
        for (Long refundId : reqBO.getRefundIds()) {
            FscBillPayRefundApprovalBusiReqBO busiReqBO = (FscBillPayRefundApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillPayRefundApprovalBusiReqBO.class));
            busiReqBO.setRefundId(refundId);
            FscBillPayRefundApprovalBusiRspBO busiRspBO = this.fscBillPayRefundApprovalBusiService.dealPayRefundApproval(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                errorInfo = errorInfo + "\u9000\u6b3e\u5355" + refundId + "\u5ba1\u6279\u5931\u8d25\uff0c" + busiRspBO.getRespDesc() + ";";
                continue;
            }
            FscOrderRefundPO refundPO = busiRspBO.getRefundPO();
            if (busiRspBO.getIsPush().booleanValue()) {
                FscPushNewYcClaimRefundBillAbilityReqBO fscPushNewYcClaimRefundBillAbilityReqBO = new FscPushNewYcClaimRefundBillAbilityReqBO();
                fscPushNewYcClaimRefundBillAbilityReqBO.setRefundId(refundId);
                this.fscSyncPushNewYcClaimRefundBillAbilityService.syncPushNewYcClaimRefundBill(fscPushNewYcClaimRefundBillAbilityReqBO);
            }
            this.sendMq(refundId);
        }
        FscBillPayRefundApprovalAbilityRspBO rspBO = new FscBillPayRefundApprovalAbilityRspBO();
        if (StringUtils.isEmpty((Object)errorInfo)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(errorInfo);
        }
        return rspBO;
    }

    private void valid(FscBillPayRefundApprovalAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u6b3e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuditResult() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncReqBO = new FscComRefundSyncAbilityReqBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        refundIds.add(refundId);
        syncReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(syncReqBO);
    }
}

