/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscAccountBillListBo;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscGetContractCapitalPlanListAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyChargeAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListBo;
import com.tydic.fsc.common.ability.bo.FscPushUnifyChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayBillBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayCapitalBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayContractBO;
import com.tydic.fsc.common.busi.api.FscPushUnifyChargeBusiService;
import com.tydic.fsc.common.busi.api.FscPushUnifyFailBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyChargeBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyFailBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcQuerySupplierDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.PebQryContractToPushChargeAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebQryContractToPushChargeReqBO;
import com.tydic.uoc.common.ability.bo.PebQryContractToPushChargeRspBO;
import com.tydic.uoc.common.ability.bo.UocQryContractToPushChargeBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushUnifyChargeAbilityService"})
public class FscPushUnifyChargeAbilityServiceImpl
implements FscPushUnifyChargeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyChargeAbilityServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountBillListQueryAbilityService fscAccountBillListQueryAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private PebQryContractToPushChargeAbilityService pebQryContractToPushChargeAbilityService;
    @Autowired
    private FscPushUnifyChargeBusiService fscPushUnifyChargeBusiService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private UmcQuerySupplierDetailAbilityService umcQuerySupplierDetailAbilityService;
    @Autowired
    private FscGetContractCapitalPlanListAbilityService fscGetContractCapitalPlanListAbilityService;
    @Autowired
    private FscPushUnifyFailBusiService fscPushUnifyFailBusiService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationOrgId;
    private static final Integer TAB_ID = 60001;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyCharge"})
    public FscPushUnifyChargeAbilityRspBO dealPushUnifyCharge(@RequestBody FscPushUnifyChargeAbilityReqBO reqBO) {
        FscPushUnifyChargeBusiReqBO pushReqBO;
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u5355id[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargePO chargePO = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (chargePO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscPushUnifyChargeAbilityRspBO rspBO = new FscPushUnifyChargeAbilityRspBO();
        try {
            pushReqBO = this.buildPrePayBillInfo(chargePO, reqBO);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u9884\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
            this.dealFail(chargePO.getChargeId(), e.getMessage());
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        FscPushUnifyChargeBusiRspBO pushRspBO = this.fscPushUnifyChargeBusiService.dealPushCharge(pushReqBO);
        return (FscPushUnifyChargeAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)pushRspBO)), FscPushUnifyChargeAbilityRspBO.class);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyChargeBatch"})
    public FscPushUnifyChargeAbilityRspBO dealPushUnifyChargeBatch(@RequestBody FscPushUnifyChargeAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getChargeIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u5355id\u96c6\u5408[chargeIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long chargeId : reqBO.getChargeIds()) {
            FscPushUnifyChargeAbilityReqBO billAbilityReqBO = new FscPushUnifyChargeAbilityReqBO();
            billAbilityReqBO.setChargeId(chargeId);
            FscPushUnifyChargeAbilityRspBO rspBO = this.dealPushUnifyCharge(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u5145\u503c[").append(chargeId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushUnifyChargeAbilityRspBO rspBO = new FscPushUnifyChargeAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPushUnifyChargeBusiReqBO buildPrePayBillInfo(FscAccountChargePO chargePO, FscPushUnifyChargeAbilityReqBO reqBO) {
        FscPushUnifyChargeBusiReqBO pushReqBO = new FscPushUnifyChargeBusiReqBO();
        FscUnifyPayBillBO payBillBO = this.buildPayInfo(reqBO);
        List<FscUnifyPayContractBO> contractList = this.buildContractInfo(chargePO, payBillBO, reqBO);
        List<FscUnifyPayCapitalBO> capitalList = this.buildCapitalInfo(contractList, chargePO, reqBO);
        if (!CollectionUtils.isEmpty(capitalList)) {
            BigDecimal capitalAmount = capitalList.stream().map(FscUnifyPayCapitalBO::getEXE_AMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = contractList.stream().map(FscUnifyPayContractBO::getAMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payAmount.compareTo(capitalAmount) != 0) {
                throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u548c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6b63\u540e\u63d0\u4ea4\uff01");
            }
        }
        ArrayList<FscUnifyAttachmentBO> attachmentBOList = new ArrayList<FscUnifyAttachmentBO>();
        this.buildFileInfo(attachmentBOList, chargePO, payBillBO);
        pushReqBO.setChargeId(chargePO.getChargeId());
        pushReqBO.setToken(payBillBO.getToken());
        payBillBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillBO);
        jsonObject.put("fileList", attachmentBOList);
        jsonObject.put("celine", capitalList);
        jsonObject.put("conLine", contractList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private void buildFileInfo(List<FscUnifyAttachmentBO> attachmentBOList, FscAccountChargePO chargePO, FscUnifyPayBillBO payBillBO) {
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(chargePO.getChargeId());
        List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
        for (FscAttachmentPO fscAttachmentPO : attachmentPOS) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
            uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setUUID("zjht");
            attachmentBO.setDOC_TYPE("8013");
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setUSER_NAME(payBillBO.getPERSON_NAME());
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBOList.add(attachmentBO);
            attachmentBO.setEG_PREPAY_NUM(chargePO.getAdvanceDepositNo());
        }
        payBillBO.setDOC_COUNT(Integer.valueOf(attachmentBOList.size()));
    }

    private List<FscUnifyPayContractBO> buildContractInfo(FscAccountChargePO chargePO, FscUnifyPayBillBO payBillBO, FscPushUnifyChargeAbilityReqBO reqBO) {
        ArrayList<Long> accountIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> backListMap = null;
        backListMap = "0".equals(reqBO.getOrderType()) ? this.buildElec(chargePO, reqBO, accountIdList) : this.buildEmp(chargePO, reqBO, accountIdList);
        PebQryContractToPushChargeReqBO pebQryContractToPushChargeReqBO = new PebQryContractToPushChargeReqBO();
        ArrayList<String> effDates = new ArrayList<String>(backListMap.keySet());
        pebQryContractToPushChargeReqBO.setEffDates(effDates);
        pebQryContractToPushChargeReqBO.setOrderType(reqBO.getOrderType());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u5408\u540c\u5165\u53c2:" + JSONObject.toJSONString((Object)pebQryContractToPushChargeReqBO));
        PebQryContractToPushChargeRspBO pebQryContractToPushChargeRspBO = this.pebQryContractToPushChargeAbilityService.qryContract(pebQryContractToPushChargeReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u5408\u51fa\u53c2:" + JSONObject.toJSONString((Object)pebQryContractToPushChargeRspBO));
        List contractBos = pebQryContractToPushChargeRspBO.getContractBos();
        ArrayList<FscUnifyPayContractBO> contractBOList = new ArrayList<FscUnifyPayContractBO>(contractBos.size());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u5408\u540c\u5165\u53c22:" + JSONObject.toJSONString((Object)contractBos));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u5408\u540cMap:" + JSONObject.toJSONString(backListMap));
        for (UocQryContractToPushChargeBO bo : contractBos) {
            FscUnifyPayContractBO contractBO = new FscUnifyPayContractBO();
            if (null != bo.getEffDate()) {
                contractBO.setAMOUNT(backListMap.get(bo.getEffDate()).setScale(2, RoundingMode.HALF_UP));
            }
            contractBO.setCONTRACT_NAME(bo.getContactName());
            contractBO.setCONTRACT_AMT(bo.getContactAmt().setScale(2, RoundingMode.HALF_UP));
            contractBO.setCONTRACT_NUM(bo.getContactNum());
            contractBO.setEG_PREPAY_NUM(payBillBO.getEG_PREPAY_NUM());
            contractBO.setORG_ID(payBillBO.getORG_ID());
            contractBO.setORG_NAME(payBillBO.getORG_NAME());
            contractBO.setCOM_CODE(payBillBO.getCOM_CODE());
            contractBOList.add(contractBO);
            contractBO.setTOTAL_PREPAY_AMT(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            contractBO.setTOTAL_PAY_AMT(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        }
        return contractBOList;
    }

    private HashMap<String, BigDecimal> buildElec(FscAccountChargePO chargePO, FscPushUnifyChargeAbilityReqBO reqBO, List<Long> accountIdList) {
        Map<Long, BigDecimal> chargeDetailMap;
        if (Objects.isNull(chargePO.getAccountId())) {
            List chargeDetailList = this.fscAccountChargeDetailMapper.queryByChargeId(chargePO.getChargeId());
            accountIdList = chargeDetailList.stream().map(FscAccountChargeDetailPO::getAccountId).collect(Collectors.toList());
            chargeDetailMap = chargeDetailList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getAccountId, FscAccountChargeDetailPO::getChargeAmount, (k1, k2) -> k1));
        } else {
            accountIdList.add(chargePO.getAccountId());
            chargeDetailMap = new HashMap<Long, BigDecimal>();
            chargeDetailMap.put(chargePO.getAccountId(), chargePO.getChargeAmount());
        }
        HashMap<String, BigDecimal> backListMap = new HashMap<String, BigDecimal>();
        accountIdList.forEach(e -> {
            BigDecimal chargeAmount = (BigDecimal)chargeDetailMap.get(e);
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(e);
            FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
            BigDecimal overdraftAmout = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount());
            if (overdraftAmout.compareTo(BigDecimal.ZERO) < 0) {
                FscAccountBillListQueryAbilityReqBO fscAccountBillListQueryAbilityReqBO = new FscAccountBillListQueryAbilityReqBO();
                fscAccountBillListQueryAbilityReqBO.setAccountId(e);
                fscAccountBillListQueryAbilityReqBO.setIsOverPay(Integer.valueOf(0));
                fscAccountBillListQueryAbilityReqBO.setPageNo(Integer.valueOf(-1));
                fscAccountBillListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
                ArrayList<Integer> tabIdList = new ArrayList<Integer>();
                tabIdList.add(TAB_ID);
                fscAccountBillListQueryAbilityReqBO.setTabIdList(tabIdList);
                fscAccountBillListQueryAbilityReqBO.setTabId(TAB_ID);
                FscAccountBillListQueryAbilityRspBO fscAccountBillListQueryAbilityRspBO = this.fscAccountBillListQueryAbilityService.qryAccountBillList(fscAccountBillListQueryAbilityReqBO);
                if (!"0000".equals(fscAccountBillListQueryAbilityRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u900f\u652f\u5f85\u8fd8\u8d26\u5355\u5f02\u5e38\uff01");
                }
                if (!CollectionUtils.isEmpty((Collection)fscAccountBillListQueryAbilityRspBO.getRows())) {
                    List busiOrderNoList = fscAccountBillListQueryAbilityRspBO.getRows().stream().map(FscAccountBillListBo::getBusiOrderNo).collect(Collectors.toList());
                    FscPayLogPO fscPayLogPO = new FscPayLogPO();
                    fscPayLogPO.setAccountId(e);
                    fscPayLogPO.setBusiOrderNoList(busiOrderNoList);
                    ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                    busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
                    busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
                    fscPayLogPO.setBusiCategoryList(busiCategoryList);
                    fscPayLogPO.setIsOverPay(Integer.valueOf(0));
                    fscPayLogPO.setOrderBy("overdraft_amt asc");
                    List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
                    if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                        Date reimbursementDate = new Date();
                        for (FscPayLogPO po : fscPayLogPOList) {
                            if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                            FscPayLogPO backPayLog = new FscPayLogPO();
                            backPayLog.setId(po.getId());
                            backPayLog.setBusiOrderId(po.getBusiOrderId());
                            backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                            backPayLog.setBusiTime(po.getBusiTime());
                            BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                            if (chargeAmount.compareTo(notBackAmt) >= 0) {
                                backPayLog.setReimbursementAmount(notBackAmt);
                                chargeAmount = chargeAmount.subtract(notBackAmt);
                                backPayLog.setReimbursementDate(reimbursementDate);
                            } else {
                                backPayLog.setReimbursementAmount(chargeAmount);
                                chargeAmount = BigDecimal.ZERO;
                            }
                            String busiYear = DateFormatUtils.format((Date)backPayLog.getBusiTime(), (String)"yyyy");
                            if (null != backListMap.get(busiYear)) {
                                BigDecimal bigDecimal = (BigDecimal)backListMap.get(busiYear);
                                backListMap.put(busiYear, bigDecimal.add(backPayLog.getReimbursementAmount()));
                                continue;
                            }
                            backListMap.put(busiYear, backPayLog.getReimbursementAmount());
                        }
                        if (chargeAmount.compareTo(BigDecimal.ZERO) > 0) {
                            this.buildMap(backListMap, chargeAmount, reqBO);
                        }
                    }
                }
            } else {
                this.buildMap(backListMap, chargeAmount, reqBO);
            }
        });
        return backListMap;
    }

    private HashMap<String, BigDecimal> buildEmp(FscAccountChargePO chargePO, FscPushUnifyChargeAbilityReqBO reqBO, List<Long> accountIdList) {
        Map<Long, Object> chargeDetailMap;
        List chargeDetailList = this.fscAccountChargeDetailMapper.queryByChargeId(reqBO.getChargeId());
        if (Objects.isNull(chargePO.getAccountId())) {
            accountIdList = chargeDetailList.stream().map(FscAccountChargeDetailPO::getAccountId).collect(Collectors.toList());
            chargeDetailMap = chargeDetailList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getAccountId, Function.identity(), (k1, k2) -> k1));
        } else {
            accountIdList.add(chargePO.getAccountId());
            chargeDetailMap = new HashMap();
            chargeDetailMap.put(chargePO.getAccountId(), chargeDetailList.get(0));
        }
        HashMap<String, BigDecimal> backListMap = new HashMap<String, BigDecimal>();
        accountIdList.forEach(e -> {
            BigDecimal chargeAmountUnion;
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(e);
            BigDecimal chargeAmountCompany = ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getCompanyAmount() == null ? BigDecimal.ZERO : ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getCompanyAmount();
            BigDecimal bigDecimal = chargeAmountUnion = ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getUnionAmount() == null ? BigDecimal.ZERO : ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getUnionAmount();
            if (chargeAmountCompany.compareTo(BigDecimal.ZERO) > 0) {
                this.payBill((Long)e, chargeAmountCompany, 1, reqBO, backListMap);
            }
            if (chargeAmountUnion.compareTo(BigDecimal.ZERO) > 0) {
                this.payBill((Long)e, chargeAmountUnion, 2, reqBO, backListMap);
            }
        });
        return backListMap;
    }

    private void buildMap(HashMap<String, BigDecimal> backListMap, BigDecimal chargeAmount, FscPushUnifyChargeAbilityReqBO reqBO) {
        String busiYear = DateFormatUtils.format((Date)reqBO.getChargeDate(), (String)"yyyy");
        if (null != backListMap.get(busiYear)) {
            BigDecimal bigDecimal = backListMap.get(busiYear);
            backListMap.put(busiYear, bigDecimal.add(chargeAmount));
        } else {
            backListMap.put(busiYear, chargeAmount);
        }
    }

    private void payBill(Long e, BigDecimal chargeAmount, Integer accountType, FscPushUnifyChargeAbilityReqBO reqBO, HashMap<String, BigDecimal> backListMap) {
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setAccountId(e);
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setIsOverPay(Integer.valueOf(0));
        fscPayLogPO.setAccountType(accountType);
        fscPayLogPO.setIsBack(Integer.valueOf(0));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(3);
        fscPayLogPO.setAdvancePayTypeList(list);
        List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            Map<String, List<FscPayLogPO>> fscPayLogPOListGroup = fscPayLogPOList.stream().collect(Collectors.groupingBy(FscPayLogPO::getWelfareChargeCode));
            ArrayList<String> fscPayLogPOListGroupList = new ArrayList<String>(fscPayLogPOListGroup.keySet());
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                block0: for (String welfareChargeCode : fscPayLogPOListGroupList) {
                    List<FscPayLogPO> fscPayLogPOS = fscPayLogPOListGroup.get(welfareChargeCode);
                    for (FscPayLogPO po : fscPayLogPOS) {
                        if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                        FscPayLogPO backPayLog = new FscPayLogPO();
                        backPayLog.setId(po.getId());
                        backPayLog.setBusiOrderId(po.getBusiOrderId());
                        backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                        backPayLog.setBusiTime(po.getBusiTime());
                        BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                        if (chargeAmount.compareTo(notBackAmt) >= 0) {
                            backPayLog.setReimbursementAmount(notBackAmt);
                            chargeAmount = chargeAmount.subtract(notBackAmt);
                        } else {
                            backPayLog.setReimbursementAmount(chargeAmount);
                            chargeAmount = BigDecimal.ZERO;
                        }
                        String busiYear = DateFormatUtils.format((Date)backPayLog.getBusiTime(), (String)"yyyy");
                        if (null != backListMap.get(busiYear)) {
                            BigDecimal bigDecimal = backListMap.get(busiYear);
                            backListMap.put(busiYear, bigDecimal.add(backPayLog.getReimbursementAmount()));
                            continue;
                        }
                        backListMap.put(busiYear, backPayLog.getReimbursementAmount());
                    }
                }
                if (chargeAmount.compareTo(BigDecimal.ZERO) > 0) {
                    this.buildMap(backListMap, chargeAmount, reqBO);
                }
            } else {
                this.buildMap(backListMap, chargeAmount, reqBO);
            }
        } else {
            this.buildMap(backListMap, chargeAmount, reqBO);
        }
    }

    private FscUnifyPayBillBO buildPayInfo(FscPushUnifyChargeAbilityReqBO reqBO) {
        FscAccountChargePO chargePO = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (chargePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5145\u503c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (chargePO.getUnifyPushStatus() != null && chargePO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5145\u503c\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgentAccount())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0agentAccount\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO pebExtUnifySettleTokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        pebExtUnifySettleTokenQryAbilityReqBO.setUserId(reqBO.getAgentAccount());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6token\u5165\u53c2:" + JSONObject.toJSONString((Object)pebExtUnifySettleTokenQryAbilityReqBO));
        PebExtUnifySettleTokenQryAbilityRspBO pebExtUnifySettleTokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(pebExtUnifySettleTokenQryAbilityReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6token\u51fa\u53c2:" + JSONObject.toJSONString((Object)pebExtUnifySettleTokenQryAbilityRspBO));
        if (pebExtUnifySettleTokenQryAbilityRspBO == null || StringUtils.isEmpty((Object)pebExtUnifySettleTokenQryAbilityRspBO.getData())) {
            throw new BusinessException("8888", "\u83b7\u53d6token\u5931\u8d25");
        }
        PebExtUnifySettlePersonQryAbilityReqBO settlePersonQryAbilityReqBO = new PebExtUnifySettlePersonQryAbilityReqBO();
        settlePersonQryAbilityReqBO.setToken(pebExtUnifySettleTokenQryAbilityRspBO.getData());
        settlePersonQryAbilityReqBO.setUSER_NAME(reqBO.getAgentAccount());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u5165\u53c2:" + JSONObject.toJSONString((Object)settlePersonQryAbilityReqBO));
        PebExtUnifySettlePersonQryAbilityRspBO pebExtUnifySettlePersonQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonInfo(settlePersonQryAbilityReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u51fa\u53c2:" + JSONObject.toJSONString((Object)settlePersonQryAbilityReqBO));
        if (!"0000".equals(pebExtUnifySettleTokenQryAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", pebExtUnifySettlePersonQryAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)pebExtUnifySettlePersonQryAbilityRspBO.getRows())) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f");
        }
        if (((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID() == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u673a\u6784ID\u4fe1\u606f");
        }
        UmcQuerySupplierDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcQuerySupplierDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setSupplierId(this.operationOrgId);
        log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)umcEnterpriseOrgQryDetailAbilityReqBO));
        UmcQuerySupplierDetailAbilityRspBO umcQuerySupplierDetailAbilityRspBO = this.umcQuerySupplierDetailAbilityService.querySupplierDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)umcQuerySupplierDetailAbilityRspBO));
        FscUnifyPayBillBO payBillBO = new FscUnifyPayBillBO();
        payBillBO.setToken(pebExtUnifySettleTokenQryAbilityRspBO.getData());
        payBillBO.setCOM_CODE(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getCOM_CODE());
        payBillBO.setPERSON_ID(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getPERSON_ID());
        payBillBO.setPERSON_NAME(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getPERSON_NAME());
        payBillBO.setDEPT_ID(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getDEPT_ID());
        payBillBO.setDEPT_NAME(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getDEPT_NAME());
        payBillBO.setORG_ID(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID());
        payBillBO.setORG_NAME(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_NAME());
        payBillBO.setVENDOR_NAME(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getSupplierName());
        payBillBO.setVENDOR_NUM(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getErpOrgCode());
        payBillBO.setVENDOR_SITE_CODE("\u8bbe\u5907\u6b3e");
        payBillBO.setAMOUNT(chargePO.getChargeAmount().setScale(2, RoundingMode.HALF_UP));
        payBillBO.setDESCRIPTIONS(chargePO.getAuditRemark());
        payBillBO.setSTATUS("N");
        payBillBO.setSTATUS_DIS("\u65b0\u5efa");
        payBillBO.setBANK_NAME(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getBankName());
        payBillBO.setBANK_NUM(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getBankAccount());
        payBillBO.setEG_PREPAY_TYPE("YFK");
        payBillBO.setEG_PREPAY_ID(chargePO.getChargeId());
        payBillBO.setEG_PREPAY_NUM(chargePO.getAdvanceDepositNo());
        payBillBO.setUSER_ID(Convert.toStr((Object)((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getUSER_ID()));
        payBillBO.setBILL_DATE(DateUtil.dateToStr((Date)reqBO.getChargeDate()));
        payBillBO.setBUSINESS_NATURE(chargePO.getBusinessNature());
        return payBillBO;
    }

    private List<FscUnifyPayCapitalBO> buildCapitalInfo(List<FscUnifyPayContractBO> contractList, FscAccountChargePO chargePO, FscPushUnifyChargeAbilityReqBO reqBO) {
        ArrayList<FscUnifyPayCapitalBO> capitalBOList = new ArrayList<FscUnifyPayCapitalBO>();
        List contractNums = contractList.stream().map(FscUnifyPayContractBO::getCONTRACT_NUM).collect(Collectors.toList());
        FscGetContractCapitalPlanListAbilityReqBO fscGetContractCapitalPlanListAbilityReqBO = new FscGetContractCapitalPlanListAbilityReqBO();
        fscGetContractCapitalPlanListAbilityReqBO.setContractNum(contractNums);
        fscGetContractCapitalPlanListAbilityReqBO.setPeriod(DateFormatUtils.format((Date)reqBO.getChargeDate(), (String)"yyyy-MM"));
        fscGetContractCapitalPlanListAbilityReqBO.setCapitalPayType(Integer.valueOf(1));
        fscGetContractCapitalPlanListAbilityReqBO.setAgentAccount(reqBO.getAgentAccount());
        FscGetContractCapitalPlanListAbilityRspBO contractCapitalPlanList = this.fscGetContractCapitalPlanListAbilityService.getContractCapitalPlanList(fscGetContractCapitalPlanListAbilityReqBO);
        if (!"0000".equals(contractCapitalPlanList.getRespCode()) || CollectionUtils.isEmpty((Collection)contractCapitalPlanList.getRows())) {
            throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        for (FscGetContractCapitalPlanListBo fscContractCapitalPlanPo : contractCapitalPlanList.getRows()) {
            FscUnifyPayCapitalBO capitalBO = new FscUnifyPayCapitalBO();
            capitalBO.setPERIOD_M(fscContractCapitalPlanPo.getPeriod());
            capitalBO.setCE_ITEM_ID(fscContractCapitalPlanPo.getItemId());
            capitalBO.setCE_ITEM_NAME(fscContractCapitalPlanPo.getItemName());
            capitalBO.setAMOUNT(fscContractCapitalPlanPo.getPlanAmount().setScale(2, RoundingMode.HALF_UP));
            capitalBO.setFINISH_AMT(fscContractCapitalPlanPo.getExeAmount().add(fscContractCapitalPlanPo.getOccAmount()));
            capitalBO.setRE_AMOUNT(fscContractCapitalPlanPo.getAmount());
            capitalBO.setORG_ID(fscContractCapitalPlanPo.getOrgId());
            capitalBO.setORG_NAME(fscContractCapitalPlanPo.getOrgName());
            capitalBO.setCONTRACT_ID(fscContractCapitalPlanPo.getContractId());
            capitalBO.setEXE_AMOUNT(chargePO.getChargeAmount());
            capitalBO.setCE_HEAD_ID(fscContractCapitalPlanPo.getHeaderId());
            capitalBO.setCE_LINE_ID(fscContractCapitalPlanPo.getLineId());
            capitalBO.setCE_TAB_TYPE(fscContractCapitalPlanPo.getTabType());
            capitalBO.setEG_CONTRACT_NUM(fscContractCapitalPlanPo.getContractNum());
            capitalBO.setEG_PREPAY_NUM(chargePO.getAdvanceDepositNo());
            capitalBOList.add(capitalBO);
        }
        return capitalBOList;
    }

    private void dealFail(Long chargeId, String failMsg) {
        FscPushUnifyFailBusiReqBO failBusiReqBO = new FscPushUnifyFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setChargeId(chargeId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.CHARGE);
        this.fscPushUnifyFailBusiService.dealPushUnifyChargeFail(failBusiReqBO);
    }
}

