/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceCapitalPlanQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceCapitalPlanQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceCapitalPlanQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceCapitalPlanResultMapBO;
import com.tydic.fsc.common.ability.vo.FscFinanceCapitalPlanResultVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceCapitalPlanQryAbilityService"})
public class FscFinanceCapitalPlanQryAbilityServiceImpl
implements FscFinanceCapitalPlanQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceCapitalPlanQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceCapitalPlanList"})
    public FscFinanceCapitalPlanQryRspBO qryFinanceCapitalPlanList(@RequestBody FscFinanceCapitalPlanQryReqBO reqBO) {
        FscFinanceCapitalPlanQryRspBO rspBO;
        this.valid(reqBO);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", financeShareTokenRspBO.getToken());
        log.info("\u83b7\u53d6Token\u4fe1\u606f\uff1a{}", (Object)financeShareTokenRspBO.getToken());
        String reqString = JSONObject.toJSONString((Object)reqBO);
        JSONObject object = JSONObject.parseObject((String)reqString);
        log.debug("\u83b7\u53d6\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)object.toJSONString());
        log.debug("\u83b7\u53d6\u8d44\u91d1\u8ba1\u5212\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm115()));
        String respStr = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm115()), (String)object.toJSONString(), headerMap);
        log.info("\u83b7\u53d6\u8d44\u91d1\u8ba1\u5212\u67e5\u8be2\u63a5\u53e3\u4fe1\u606f\u62a5\u6587\uff1a{}", (Object)respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("191138", "\u83b7\u53d6\u8d44\u91d1\u8ba1\u5212\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            rspBO = this.resolveRreRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u8d44\u91d1\u8ba1\u5212\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private void valid(FscFinanceCapitalPlanQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUnitCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u5355\u4f4d\u7f16\u7801[unitCode]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPeriod())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u671f\u95f4\uff08yyyy-MM\uff09[period]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPlanDayItemList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u65e5\u8ba1\u5212\u9879\u5217\u8868[planDayItemList]\u4e3a\u7a7a");
        }
    }

    private FscFinanceCapitalPlanQryRspBO resolveRreRsp(String respStr) {
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d44\u91d1\u8ba1\u5212\u8fd4\u56de\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscFinanceCapitalPlanQryRspBO rspBO = new FscFinanceCapitalPlanQryRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!Objects.equals(jsonObject.getString("code"), "0")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5931\u8d25\uff01" + jsonObject.getString("msg"));
            return rspBO;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        FscFinanceCapitalPlanResultVO resultVO = (FscFinanceCapitalPlanResultVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data), FscFinanceCapitalPlanResultVO.class);
        if (Objects.nonNull(resultVO)) {
            rspBO.setStatus(resultVO.getStatus());
            rspBO.setUnitCode(resultVO.getUnitCode());
            Map resultMap = resultVO.getResultMap();
            HashMap<String, FscFinanceCapitalPlanResultMapBO> map = new HashMap<String, FscFinanceCapitalPlanResultMapBO>();
            if (!CollectionUtils.isEmpty((Map)resultMap)) {
                for (String key : resultMap.keySet()) {
                    JSONObject value = JSONObject.parseObject((String)JSONObject.toJSONString(resultMap.get(key)));
                    FscFinanceCapitalPlanResultMapBO bo = (FscFinanceCapitalPlanResultMapBO)JSONObject.parseObject((String)value.toJSONString(), FscFinanceCapitalPlanResultMapBO.class);
                    map.put(key, bo);
                }
            }
            rspBO.setResultMap(map);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u89e3\u6790\u8d44\u91d1\u8ba1\u5212\u6570\u636e\u96c6\u5408\uff1a{}", (Object)rspBO);
        return rspBO;
    }
}

