/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.util.PageUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceEstimateBillListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceEstimateBillListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceEstimateBillListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceEstimateBillListQryRspBoBillList;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceEstimateBillListQryAbilityService"})
public class FscFinanceEstimateBillListQryAbilityServiceImpl
implements FscFinanceEstimateBillListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceEstimateBillListQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fsFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceEstimateBillList"})
    public FscFinanceEstimateBillListQryRspBO qryFinanceEstimateBillList(@RequestBody FscFinanceEstimateBillListQryReqBO reqBo) {
        FscFinanceEstimateBillListQryRspBO rspBO = new FscFinanceEstimateBillListQryRspBO();
        this.valid(reqBo);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fsFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainUrl), (String)"\u672a\u914d\u7f6e\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u5efa\u8bbe\u9879\u76ee\u63a5\u53e3");
            HashMap header = Maps.newHashMap();
            header.put("Authorization", financeShareTokenRspBO.getToken());
            JSONObject bodyObj = JSON.parseObject((String)JSON.toJSONString((Object)reqBo));
            bodyObj.put("currentPage", (Object)reqBo.getPageNo());
            bodyObj.put("pageSize", (Object)reqBo.getPageSize());
            bodyObj.put("orgId", (Object)reqBo.getFinanceOrgId());
            bodyObj.put("contractCode", (Object)reqBo.getContractNo());
            String body = JSON.toJSONString((Object)bodyObj);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u6682\u4f30\u5355\u67e5\u8be2\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587 url:{} body:{}", (Object)this.fscShareFinanceServiceConfiguration.getAp113(), (Object)body);
            String json = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getAp113()), (String)body, (Map)header);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u6682\u4f30\u5355\u67e5\u8be2\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)json);
            JSONObject jsonObj = JSON.parseObject((String)json);
            Integer code = jsonObj.getInteger("code");
            String msg = jsonObj.getString("msg");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)json), (String)"\u6570\u636e\u4e3a\u7a7a");
            Assert.isTrue((code == 0 ? 1 : 0) != 0, (String)msg);
            JSONObject data = jsonObj.getJSONObject("data");
            Integer total = data.getInteger("total");
            Integer pageSize = data.getInteger("pageSize");
            Integer currentPage = data.getInteger("currentPage");
            List records = JSON.parseArray((String)data.getString("records"), FscFinanceEstimateBillListQryRspBoBillList.class);
            rspBO.setPageNo(currentPage);
            rspBO.setTotal(Integer.valueOf(PageUtil.totalPage((int)total, (int)pageSize)));
            rspBO.setRecordsTotal(total);
            rspBO.setRows(records);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u6682\u4f30\u5355\u67e5\u8be2\u63a5\u53e3\u62a5\u9519\uff1a%s", e.getMessage()));
        }
        return rspBO;
    }

    private void valid(FscFinanceEstimateBillListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getContractNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5408\u540c\u7f16\u7801[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

