/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundItemListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspListBO;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundItemListQryAbilityService"})
public class FscFinanceRefundItemListQryAbilityServiceImpl
implements FscFinanceRefundItemListQryAbilityService {
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;

    @PostMapping(value={"qryFinanceRefundItemList"})
    public FscFinanceRefundItemListQryRspBO qryFinanceRefundItemList(@RequestBody FscFinanceRefundItemListQryReqBO reqBo) {
        this.valid(reqBo);
        FscFinanceRefundItemListQryRspBO rspBO = new FscFinanceRefundItemListQryRspBO();
        FscFinanceRefundItemPO fscFinanceRefundItemReq = new FscFinanceRefundItemPO();
        fscFinanceRefundItemReq.setRefundId(reqBo.getRefundId());
        fscFinanceRefundItemReq.setContractId(reqBo.getContractId());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getListPageByPayItem(fscFinanceRefundItemReq, page);
        List rspData = JSON.parseArray((String)JSON.toJSONString((Object)fscFinanceRefundItemPOList), FscFinanceRefundItemListQryRspListBO.class);
        if (rspData != null) {
            List payItemIds = rspData.stream().map(FscFinanceRefundItemListQryRspListBO::getPayItemId).collect(Collectors.toList());
            FscFinancePayItemPO fscFinancePayItemReq = new FscFinancePayItemPO();
            fscFinancePayItemReq.setFinancePayItemIds(payItemIds);
            List fscFinancePayItemPOList = this.fscFinancePayItemMapper.getList(fscFinancePayItemReq);
            Map fscFinancePayItemMap = fscFinancePayItemPOList.stream().collect(Collectors.toMap(FscFinancePayItemPO::getFinancePayItemId, Function.identity()));
            BigDecimal sumRefundAmt = BigDecimal.ZERO;
            BigDecimal sumRefundAmtLocal = BigDecimal.ZERO;
            BigDecimal sumNoRefundAmt = BigDecimal.ZERO;
            BigDecimal sumNoRefundAmtLocal = BigDecimal.ZERO;
            for (FscFinanceRefundItemListQryRspListBO rspDatum : rspData) {
                FscFinancePayItemPO fscFinancePayItem = (FscFinancePayItemPO)fscFinancePayItemMap.get(rspDatum.getPayItemId());
                if (fscFinancePayItem == null) continue;
                sumRefundAmt = sumRefundAmt.add(fscFinancePayItem.getRefundAmt());
                sumRefundAmtLocal = sumRefundAmtLocal.add(fscFinancePayItem.getRefundAmtLocal());
                sumNoRefundAmt = sumNoRefundAmt.add(fscFinancePayItem.getPayAmount().subtract(fscFinancePayItem.getRefundAmt()).subtract(fscFinancePayItem.getRefundingAmt()));
                sumNoRefundAmtLocal = sumNoRefundAmtLocal.add(fscFinancePayItem.getPayAmountLocal().subtract(fscFinancePayItem.getRefundAmtLocal()).subtract(fscFinancePayItem.getRefundingAmtLocal()));
                BeanUtils.copyProperties((Object)fscFinancePayItem, (Object)rspDatum);
            }
            rspBO.setSumRefundAmt(sumRefundAmt);
            rspBO.setSumRefundAmtLocal(sumRefundAmtLocal);
            rspBO.setSumNoRefundAmt(sumNoRefundAmt);
            rspBO.setSumNoRefundAmtLocal(sumNoRefundAmtLocal);
        }
        rspBO.setRows(rspData);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundItemListQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRefundId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u51b2\u9500\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

