/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundPayTicketListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundPayTicketListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundPayTicketListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundPayTicketListQryRspListBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundPayTicketListQryAbilityService"})
public class FscFinanceRefundPayTicketListQryAbilityServiceImpl
implements FscFinanceRefundPayTicketListQryAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;

    @PostMapping(value={"qryRefundPayTicketList"})
    public FscFinanceRefundPayTicketListQryRspBO qryRefundPayTicketList(@RequestBody FscFinanceRefundPayTicketListQryReqBO reqBo) {
        FscFinanceRefundPayTicketListQryRspBO rspBO = new FscFinanceRefundPayTicketListQryRspBO();
        this.valid(reqBo);
        FscOrderRefundPO fscOrderRefundReq = new FscOrderRefundPO();
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscOrderRefundMapper.getListPage(fscOrderRefundReq, page);
        List list = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceRefundPayTicketListQryRspListBO.class);
        List refundIds = list.stream().map(FscFinanceRefundPayTicketListQryRspListBO::getRefundId).collect(Collectors.toList());
        List fscPayShouldRefundPOList = this.fscPayShouldRefundMapper.getByRefundIds(refundIds);
        Map<Long, BigDecimal> fscPayShouldRefundMap = fscPayShouldRefundPOList.stream().collect(Collectors.toMap(FscPayShouldRefundPO::getRefundId, FscPayShouldRefundPO::getRefundAmount, BigDecimal::add));
        List fscInvoicePOList = this.fscInvoiceMapper.getInvoiceByRefundIds(refundIds);
        Map<Long, List<FscInvoicePO>> fscInvoicePOMap = fscInvoicePOList.stream().collect(Collectors.groupingBy(FscInvoicePO::getRefundId));
        for (FscFinanceRefundPayTicketListQryRspListBO bo : list) {
            Long refundId = bo.getRefundId();
            bo.setRefundAmount(fscPayShouldRefundMap.get(refundId));
            List<FscInvoicePO> fscInvoice = fscInvoicePOMap.get(refundId);
            if (fscInvoice == null) continue;
            fscInvoice.sort(Comparator.comparing(FscInvoicePO::getInvoiceId));
            String invoiceNoStr = CollUtil.join((Iterable)fscInvoice.stream().map(FscInvoicePO::getInvoiceNo).collect(Collectors.toList()), (CharSequence)",");
            String invoiceCodeStr = CollUtil.join((Iterable)fscInvoice.stream().map(FscInvoicePO::getInvoiceCode).collect(Collectors.toList()), (CharSequence)",");
            bo.setInvoiceCode(invoiceCodeStr);
            bo.setInvoiceNo(invoiceNoStr);
        }
        rspBO.setRows(list);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundPayTicketListQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u51b2\u9500\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

