/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscAccountChargeRefundUpdateBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeRefundUpdateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeRefundUpdateBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeRefundUpdateReqAttachmentBusiBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeRefundUpdateReqUseAccountBusiBO;
import com.tydic.fsc.common.enums.DeleteYnEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountChargeRefundUpdateBusiServiceImpl
implements FscAccountChargeRefundUpdateBusiService {
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;

    @Override
    public FscAccountChargeRefundUpdateBusiRspBO dealChargeRefundUpdate(FscAccountChargeRefundUpdateBusiReqBO reqBo) {
        FscAccountChargeRefundUpdateBusiRspBO rspBO = new FscAccountChargeRefundUpdateBusiRspBO();
        FscAccountChargePO fscAccountChargePO = this.updateAccountCharge(reqBo);
        this.updateAccountChargeDetail(reqBo, fscAccountChargePO);
        this.updateAttachment(reqBo, fscAccountChargePO);
        this.updateRefundFinance(reqBo, fscAccountChargePO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscAccountChargePO updateAccountCharge(FscAccountChargeRefundUpdateBusiReqBO reqBO) {
        FscAccountMainPO qryFscAccountMain = new FscAccountMainPO();
        qryFscAccountMain.setBusiType(reqBO.getBusiType() != 4L ? "1" : null);
        qryFscAccountMain.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPO = this.fscAccountMainMapper.getModelBy(qryFscAccountMain);
        if (ObjectUtil.isEmpty((Object)fscAccountMainPO)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f");
        }
        FscAccountChargePO updateFscAccountCharge = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateFscAccountCharge);
        updateFscAccountCharge.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
        updateFscAccountCharge.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        updateFscAccountCharge.setRecvDeptCode(this.operationOrgCode);
        updateFscAccountCharge.setRecvBankAccount(fscAccountMainPO.getBankAccount());
        updateFscAccountCharge.setSettlePlatform(ObjectUtil.isNotEmpty((Object)reqBO.getFinanceOrgId()) ? FscConstants.SettlePlatform.FINANCE : null);
        updateFscAccountCharge.setUserId(reqBO.getUserId());
        updateFscAccountCharge.setUserName(reqBO.getName());
        updateFscAccountCharge.setCreateTime(new Date());
        this.fscAccountChargeMapper.update(updateFscAccountCharge);
        return updateFscAccountCharge;
    }

    private void updateAccountChargeDetail(FscAccountChargeRefundUpdateBusiReqBO reqBO, FscAccountChargePO fscAccountChargePO) {
        this.fscAccountChargeDetailMapper.deleteByChargeId(reqBO.getChargeId());
        List useDeptIdList = reqBO.getUseAccountBoList().stream().map(FscAccountChargeRefundUpdateReqUseAccountBusiBO::getUseDeptId).distinct().collect(Collectors.toList());
        List fscAccountPOList = this.fscAccountMapper.queryByOrgIds(useDeptIdList, String.valueOf(reqBO.getBusiType()));
        if (CollectionUtils.isEmpty((Collection)fscAccountPOList) || fscAccountPOList.size() != useDeptIdList.size()) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f");
        }
        Map<Long, FscAccountPO> orgIdVsAccountMap = fscAccountPOList.stream().collect(Collectors.toMap(FscAccountPO::getOrgId, po -> po, (k1, k2) -> k1));
        ArrayList<FscAccountChargeDetailPO> addFscAccountChargeDetailList = new ArrayList<FscAccountChargeDetailPO>(1);
        for (FscAccountChargeRefundUpdateReqUseAccountBusiBO useAccount : reqBO.getUseAccountBoList()) {
            if (ObjectUtil.isEmpty((Object)orgIdVsAccountMap.get(useAccount.getUseDeptId()))) {
                throw new FscBusinessException("198888", useAccount.getUseDeptName() + ": \u672a\u67e5\u8be2\u5230\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f");
            }
            FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
            BeanUtils.copyProperties((Object)useAccount, (Object)fscAccountChargeDetailPO);
            fscAccountChargeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAccountChargeDetailPO.setChargeId(fscAccountChargePO.getChargeId());
            fscAccountChargeDetailPO.setAdvanceDepositNo(reqBO.getAdvanceDepositNo());
            fscAccountChargeDetailPO.setAccountId(orgIdVsAccountMap.get(useAccount.getUseDeptId()).getId());
            fscAccountChargeDetailPO.setCreateId(reqBO.getUserId());
            fscAccountChargeDetailPO.setCreateTime(new Date());
            fscAccountChargeDetailPO.setDeleteYn(DeleteYnEnum.NORMAL.getCode());
            addFscAccountChargeDetailList.add(fscAccountChargeDetailPO);
        }
        this.fscAccountChargeDetailMapper.insertBatch(addFscAccountChargeDetailList);
    }

    private void updateAttachment(FscAccountChargeRefundUpdateBusiReqBO reqBO, FscAccountChargePO fscAccountChargePO) {
        FscAttachmentPO deleteFscAttachment = new FscAttachmentPO();
        deleteFscAttachment.setObjId(fscAccountChargePO.getChargeId());
        this.fscAttachmentMapper.deleteBy(deleteFscAttachment);
        if (CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            return;
        }
        ArrayList<FscAttachmentPO> addAttachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (FscAccountChargeRefundUpdateReqAttachmentBusiBO attachment : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachment, (Object)fscAttachmentPO);
            fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPO.setObjId(fscAccountChargePO.getChargeId());
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
            fscAttachmentPO.setCreateUserId(reqBO.getUserId());
            fscAttachmentPO.setCreateUser(reqBO.getName());
            fscAttachmentPO.setCreateTime(new Date());
            addAttachmentList.add(fscAttachmentPO);
        }
        this.fscAttachmentMapper.insertBatch(addAttachmentList);
    }

    private void updateRefundFinance(FscAccountChargeRefundUpdateBusiReqBO reqBO, FscAccountChargePO fscAccountChargePO) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateFscRefundFinanceSet);
        updateFscRefundFinanceSet.setUpdateUserId(reqBO.getUserId());
        updateFscRefundFinanceSet.setUpdateUserName(reqBO.getName());
        updateFscRefundFinanceSet.setUpdateUserAccount(reqBO.getUserName());
        updateFscRefundFinanceSet.setUpdateTime(new Date());
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(fscAccountChargePO.getChargeId());
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }
}

