/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.busi.api.FscComInvoiceListQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComInvoiceListQueryBusiServiceImpl
implements FscComInvoiceListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComInvoiceListQueryBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    private static final Integer SYNC_TYPE_ONE = 1;

    @Override
    public FscComInvoiceListQueryBusiRspBO qryInvoiceList(FscComInvoiceListQueryBusiReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String orderBy = "bill_date desc";
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setOrderBy(orderBy);
        fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePo.setRefundId(reqBO.getRefundId());
        fscInvoicePo.setInvoiceId(reqBO.getInvoiceId());
        fscInvoicePo.setInvoiceIds(reqBO.getInvoiceIds());
        fscInvoicePo.setFscOrderIds(reqBO.getFscOrderIds());
        List fscInvoicePos = this.fscInvoiceMapper.getListPageToEs(fscInvoicePo, page);
        FscComInvoiceListQueryBusiRspBO busiRspBO = new FscComInvoiceListQueryBusiRspBO();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePos)) {
            ArrayList<InvoiceBO> invoiceBos = new ArrayList<InvoiceBO>();
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map invoiceStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_STATUS");
            Map invoiceStatusSettleQueryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_STATUS_SETTLE_QUERY");
            if (SYNC_TYPE_ONE.equals(reqBO.getSyncType())) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setObjType(FscConstants.AttachmentType.REFUND_RED_INVOICE);
                fscAttachmentPo.setObjId(reqBO.getRefundId());
                List attachmentPoList = this.fscAttachmentMapper.getList(fscAttachmentPo);
                for (FscInvoicePO invoicePo : fscInvoicePos) {
                    InvoiceBO invoiceBo = new InvoiceBO();
                    BeanUtils.copyProperties((Object)invoicePo, (Object)invoiceBo);
                    invoiceBo.setInvoiceCategoryStr((String)invoiceCategoryMap.get(String.valueOf(invoiceBo.getInvoiceCategory())));
                    invoiceBo.setInvoiceTypeStr((String)invoiceTypeMap.get(invoiceBo.getInvoiceType()));
                    if (!CollectionUtils.isEmpty((Map)invoiceStatusMap) && invoiceBo.getStatus() != null) {
                        invoiceBo.setStatusStr((String)invoiceStatusMap.get(invoiceBo.getStatus().toString()));
                        invoiceBo.setStatusSettleQueryStr((String)invoiceStatusSettleQueryMap.get(invoiceBo.getStatus().toString()));
                    }
                    if (!CollectionUtils.isEmpty((Collection)attachmentPoList)) {
                        List invoiceAttachment = attachmentPoList.stream().filter(fscAttachment -> invoicePo.getRefundId().equals(fscAttachment.getObjId())).collect(Collectors.toList());
                        invoiceBo.setAttachmentList(JSON.parseArray((String)JSON.toJSONString(invoiceAttachment), AttachmentBO.class));
                    }
                    invoiceBos.add(invoiceBo);
                }
            } else {
                List invoiceIdList = fscInvoicePos.stream().map(FscInvoicePO::getInvoiceId).collect(Collectors.toList());
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setObjType(FscConstants.AttachmentType.INVOICE);
                fscAttachmentPo.setObjIds(invoiceIdList);
                List attachmentPoList = this.fscAttachmentMapper.getList(fscAttachmentPo);
                List mailIdList = fscInvoicePos.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
                FscInvoicePostPO fscInvoicePostPo = new FscInvoicePostPO();
                fscInvoicePostPo.setIds(mailIdList);
                List invoicePostList = this.fscInvoicePostMapper.getList(fscInvoicePostPo);
                Map<Long, FscInvoicePostPO> invoicePostPoMap = invoicePostList.stream().collect(Collectors.toMap(FscInvoicePostPO::getId, v -> v));
                List fscOrderIdList = fscInvoicePos.stream().map(FscInvoicePO::getFscOrderId).distinct().collect(Collectors.toList());
                FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
                fscOrderRelationPo.setFscOrderIds(fscOrderIdList);
                List fscOrderRelationPoList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
                FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
                fscInvoiceItemPO.setFscOrderIdList(fscOrderIdList);
                List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getListForRefund(fscInvoiceItemPO);
                Map<Long, List<FscInvoiceItemPO>> fscInvoiceItemListMap = fscInvoiceItemPOList.stream().collect(Collectors.groupingBy(FscInvoiceItemPO::getInvoiceId));
                FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
                fscInvoiceRefundRelationPO.setFscOrderIdList(fscOrderIdList);
                List fscInvoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.queryAllEffective(fscInvoiceRefundRelationPO);
                HashMap<Long, Object> fscInvoiceRefundRelationMap = new HashMap<Long, Object>();
                for (FscInvoiceRefundRelationPO refundRelationPO : fscInvoiceRefundRelationPOList) {
                    if (fscInvoiceRefundRelationMap.get(refundRelationPO.getInvoiceId()) == null) {
                        ArrayList<Long> refundIds = new ArrayList<Long>();
                        refundIds.add(refundRelationPO.getRefundId());
                        refundRelationPO.setRefundIds(refundIds);
                        fscInvoiceRefundRelationMap.put(refundRelationPO.getInvoiceId(), refundRelationPO);
                        continue;
                    }
                    FscInvoiceRefundRelationPO relationPO = (FscInvoiceRefundRelationPO)fscInvoiceRefundRelationMap.get(refundRelationPO.getInvoiceId());
                    List refundIds = relationPO.getRefundIds();
                    refundIds.add(refundRelationPO.getRefundId());
                    relationPO.setRefundIds(refundIds);
                    relationPO.setRefundAmt(relationPO.getRefundAmt().add(refundRelationPO.getRefundAmt()));
                    fscInvoiceRefundRelationMap.put(refundRelationPO.getInvoiceId(), relationPO);
                }
                List allEffectiveAndLoseRefundRelationPOList = this.fscInvoiceRefundRelationMapper.queryAllEffectiveAndLose(fscInvoiceRefundRelationPO);
                HashMap<Long, FscInvoiceRefundRelationPO> allEffectiveAndLoseInvoiceRefundRelationMap = new HashMap<Long, FscInvoiceRefundRelationPO>();
                if (!CollectionUtils.isEmpty((Collection)allEffectiveAndLoseRefundRelationPOList)) {
                    for (FscInvoiceRefundRelationPO refundRelationPO : allEffectiveAndLoseRefundRelationPOList) {
                        if (allEffectiveAndLoseInvoiceRefundRelationMap.get(refundRelationPO.getInvoiceId()) == null) {
                            ArrayList<Long> refundIds = new ArrayList<Long>();
                            refundIds.add(refundRelationPO.getRefundId());
                            refundRelationPO.setRefundIds(refundIds);
                            allEffectiveAndLoseInvoiceRefundRelationMap.put(refundRelationPO.getInvoiceId(), refundRelationPO);
                            continue;
                        }
                        FscInvoiceRefundRelationPO relationPO = (FscInvoiceRefundRelationPO)allEffectiveAndLoseInvoiceRefundRelationMap.get(refundRelationPO.getInvoiceId());
                        List refundIds = relationPO.getRefundIds();
                        refundIds.add(refundRelationPO.getRefundId());
                        relationPO.setRefundIds(refundIds);
                        relationPO.setRefundAmt(relationPO.getRefundAmt().add(refundRelationPO.getRefundAmt()));
                        allEffectiveAndLoseInvoiceRefundRelationMap.put(refundRelationPO.getInvoiceId(), relationPO);
                    }
                }
                FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
                fscOrderInvoicePo.setFscOrderIdList(fscOrderIdList);
                List fscOrderInvoicePoList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePo);
                Map<Long, FscOrderInvoicePO> fscOrderInvoicePoMap = fscOrderInvoicePoList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, v -> v));
                FscComOrderListPageQueryBusiReqBO fscComOrderListPageQueryBusiReqBO = new FscComOrderListPageQueryBusiReqBO();
                fscComOrderListPageQueryBusiReqBO.setFscOrderIds(fscOrderIdList);
                fscComOrderListPageQueryBusiReqBO.setPageSize(Integer.valueOf(-1));
                if (log.isDebugEnabled()) {
                    log.debug("\u67e5\u8be2es\u4e3b\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscComOrderListPageQueryBusiReqBO));
                }
                FscComOrderListPageQueryBusiRspBO fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(fscComOrderListPageQueryBusiReqBO);
                if (log.isDebugEnabled()) {
                    log.debug("\u67e5\u8be2es\u4e3b\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscComOrderListPageQueryBusiRspBO));
                }
                if (!"0000".equals(fscComOrderListPageQueryBusiRspBO.getRespCode())) {
                    throw new FscBusinessException("193126", fscComOrderListPageQueryBusiRspBO.getRespDesc());
                }
                List fscComOrderListBos = fscComOrderListPageQueryBusiRspBO.getRows();
                Map<Long, FscComOrderListBO> fscComOrderMap = fscComOrderListBos.stream().collect(Collectors.toMap(FscComOrderListBO::getFscOrderId, f -> f));
                for (FscInvoicePO invoicePo : fscInvoicePos) {
                    List invoiceAttachment = attachmentPoList.stream().filter(fscAttachment -> invoicePo.getInvoiceId().equals(fscAttachment.getObjId())).collect(Collectors.toList());
                    List orderNoList = fscOrderRelationPoList.stream().filter(fscOrderRelation -> invoicePo.getFscOrderId().equals(fscOrderRelation.getOrderId())).map(FscOrderRelationPO::getOrderNo).collect(Collectors.toList());
                    List bos = JSON.parseArray((String)JSON.toJSONString(invoiceAttachment), AttachmentBO.class);
                    InvoiceBO invoiceBo = new InvoiceBO();
                    BeanUtils.copyProperties((Object)invoicePo, (Object)invoiceBo);
                    invoiceBo.setOrderNos(orderNoList);
                    invoiceBo.setInvoiceCategoryStr((String)invoiceCategoryMap.get(String.valueOf(invoiceBo.getInvoiceCategory())));
                    invoiceBo.setInvoiceTypeStr((String)invoiceTypeMap.get(invoiceBo.getInvoiceType()));
                    if (!CollectionUtils.isEmpty((Map)invoiceStatusMap) && invoiceBo.getStatus() != null) {
                        invoiceBo.setStatusStr((String)invoiceStatusMap.get(invoiceBo.getStatus().toString()));
                        invoiceBo.setStatusSettleQueryStr((String)invoiceStatusSettleQueryMap.get(invoiceBo.getStatus().toString()));
                    }
                    if (fscInvoiceItemListMap.get(invoiceBo.getInvoiceId()) != null) {
                        invoiceBo.setInvoiceItemBOS(JSON.parseArray((String)JSON.toJSONString(fscInvoiceItemListMap.get(invoiceBo.getInvoiceId())), InvoiceItemBO.class));
                        invoiceBo.setOrderNum(Integer.valueOf(fscInvoiceItemListMap.get(invoiceBo.getInvoiceId()).size()));
                    } else {
                        invoiceBo.setInvoiceItemBOS(new ArrayList(0));
                        invoiceBo.setOrderNum(Integer.valueOf(0));
                    }
                    invoiceBo.setRefundAmt(BigDecimal.ZERO);
                    if (fscInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId()) != null) {
                        invoiceBo.setRefundRelationId(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId())).getRefundId());
                        invoiceBo.setRefundRelationIds(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId())).getRefundIds());
                        invoiceBo.setRefundAmt(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId())).getRefundAmt());
                    }
                    if (allEffectiveAndLoseInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId()) != null) {
                        invoiceBo.setRefundRelationIds(((FscInvoiceRefundRelationPO)allEffectiveAndLoseInvoiceRefundRelationMap.get(invoiceBo.getInvoiceId())).getRefundIds());
                    }
                    invoiceBo.setLeaveRefundAmt(invoiceBo.getAmt().subtract(invoiceBo.getRefundAmt()));
                    invoiceBo.setRefundFlag(FscConstants.FscRefundFlag.YES);
                    if (invoiceBo.getLeaveRefundAmt().compareTo(BigDecimal.ZERO) > 0) {
                        invoiceBo.setRefundFlag(FscConstants.FscRefundFlag.NO);
                    }
                    invoiceBo.setAttachmentList(bos);
                    if (!CollectionUtils.isEmpty(fscOrderInvoicePoMap)) {
                        invoiceBo.setBillTime(fscOrderInvoicePoMap.get(invoicePo.getFscOrderId()).getBillTime());
                    }
                    if (!CollectionUtils.isEmpty(fscComOrderMap)) {
                        invoiceBo.setFscOrderNo(fscComOrderMap.get(invoiceBo.getFscOrderId()).getFscOrderNo());
                        invoiceBo.setSupplierId(fscComOrderMap.get(invoiceBo.getFscOrderId()).getSupplierId());
                        invoiceBo.setPurchaserId(fscComOrderMap.get(invoiceBo.getFscOrderId()).getPurchaserId());
                        invoiceBo.setMakeType(fscComOrderMap.get(invoiceBo.getFscOrderId()).getMakeType());
                        invoiceBo.setReceiveType(fscComOrderMap.get(invoiceBo.getFscOrderId()).getReceiveType());
                        invoiceBo.setOrderType(fscComOrderMap.get(invoiceBo.getFscOrderId()).getOrderType());
                        FscComOrderListBO fscComOrderListBO = fscComOrderMap.get(invoiceBo.getFscOrderId());
                        if (null != fscComOrderListBO.getReceiveType()) {
                            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscComOrderListBO.getReceiveType())) {
                                invoiceBo.setReceiveName(fscComOrderListBO.getPurchaserName());
                            }
                            if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscComOrderListBO.getReceiveType())) {
                                invoiceBo.setReceiveName(fscComOrderListBO.getProOrgName());
                            }
                            if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscComOrderListBO.getReceiveType())) {
                                invoiceBo.setReceiveName(fscComOrderListBO.getSupplierName());
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(invoicePostPoMap)) {
                        invoiceBo.setSignTime(invoicePostPoMap.get(invoicePo.getMailId()).getSignTime());
                        invoiceBo.setMailDesc(this.assembly(invoicePostPoMap.get(invoicePo.getMailId())));
                        invoiceBo.setSignOperId(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperId());
                        invoiceBo.setSignOperName(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperName());
                    }
                    invoiceBos.add(invoiceBo);
                }
            }
            busiRspBO.setRows(invoiceBos);
            busiRspBO.setTotal(page.getTotalPages());
            busiRspBO.setRecordsTotal(page.getTotalCount());
            busiRspBO.setPageNo(page.getPageNo());
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private String assembly(FscInvoicePostPO fscInvoicePostPO) {
        if (StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendCompany()) && StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendOrder())) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u5feb\u9012\u516c\u53f8\uff1a").append(fscInvoicePostPO.getSendCompany()).append("\n").append("\u5feb\u9012\u5355\u53f7\uff1a").append(fscInvoicePostPO.getSendOrder());
            return sb.toString();
        }
        return "";
    }
}

