/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.consumer.bo.OrderForClaimSynAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscShouldPayForOrderClaimMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscShouldPayForOrderClaimPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FscOrderForClaimSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscOrderForClaimSyncServiceConsumer.class);
    @Value(value="${saleOrderTabId:80014}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscShouldPayForOrderClaimMapper fscShouldPayForOrderClaimMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        OrderForClaimSynAbilityReqBO reqBO = new OrderForClaimSynAbilityReqBO();
        try {
            log.debug("---------------\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u540c\u6b65\u7ed3\u7b97\u5e94\u4ed8\u4fe1\u606f\u5f00\u59cb---------------");
            reqBO = (OrderForClaimSynAbilityReqBO)((Object)JSON.parseObject((String)message.getContent(), OrderForClaimSynAbilityReqBO.class));
            log.debug("\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u540c\u6b65\u7ed3\u7b97\u5e94\u4ed8\u4fe1\u606f\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u5165\u53c2\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
            if (CollectionUtils.isEmpty(reqBO.getOrderIds())) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            ArrayList fscOrderPayItemPOs = new ArrayList();
            UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = new UocSalesSingleDetailsListQueryRspBO();
            for (int i = 1; i < 10; ++i) {
                UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
                saleDetailsReqBO.setPageSize(1000);
                saleDetailsReqBO.setOrderIdList(reqBO.getOrderIds());
                saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
                saleDetailsReqBO.setIndividually("1");
                log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
                saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
                if (!"0000".equals(saleDetailsRspBO.getRespCode())) {
                    throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
                }
                if (!CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) break;
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            ArrayList fscShouldPayPOList = new ArrayList();
            boolean i = false;
            for (UocPebUpperOrderAbilityBO e : saleDetailsRspBO.getRows()) {
                if (PebExtConstant.Modelsettle.CH.toString().equals(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getTradeMode())) continue;
                ArrayList<Integer> allowPayType = new ArrayList<Integer>();
                allowPayType.add(0);
                allowPayType.add(1);
                allowPayType.add(2);
                if (((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getPayType() == null || !allowPayType.contains(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getPayType())) continue;
                Long orderId = Long.valueOf(e.getOrderId());
                FscShouldPayForOrderClaimPO fscShouldPayPO = new FscShouldPayForOrderClaimPO();
                Integer tradeMode = StringUtils.isEmpty((Object)((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getTradeMode()) ? null : Integer.valueOf(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getTradeMode());
                BigDecimal purPrice = ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getPurchasingPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sellPrice = ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getSellingPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal purCount = ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getPurchaseCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal returnCount = ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getReturnCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refuseCount = ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getRefuseCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalCount = purCount.subtract(returnCount).subtract(refuseCount);
                BigDecimal purTotalAmt = purPrice.multiply(totalCount);
                BigDecimal sellTotalAmt = sellPrice.multiply(totalCount);
                BigDecimal toPayAmount = BigDecimal.ZERO;
                fscShouldPayPO.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
                fscShouldPayPO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
                fscShouldPayPO.setObjectType(FscConstants.ShouldObjectType.SALE_ORDER);
                fscShouldPayPO.setObjectId(Long.valueOf(e.getOrderId()));
                fscShouldPayPO.setObjectNo(e.getSaleVoucherNo());
                fscShouldPayPO.setOrderId(orderId);
                fscShouldPayPO.setShouldPayAmount(sellTotalAmt);
                fscShouldPayPO.setPaidAmount(BigDecimal.ZERO);
                fscShouldPayPO.setPayingAmount(BigDecimal.ZERO);
                fscShouldPayPO.setToPayAmount(toPayAmount);
                fscShouldPayPO.setOriginalAmount(sellTotalAmt);
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
                fscShouldPayPO.setPayeeId(Long.valueOf(e.getProNo()));
                fscShouldPayPO.setPayeeName(e.getProName());
                fscShouldPayPO.setPayerId(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getCompanyId());
                fscShouldPayPO.setPayerName(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getCompanyName());
                fscShouldPayPO.setCreateOrgId(reqBO.getOrgId());
                fscShouldPayPO.setCreateOrgName(reqBO.getOrgName());
                fscShouldPayPO.setCreateCompanyId(reqBO.getCompanyId());
                fscShouldPayPO.setCreateCompanyName(reqBO.getCompanyName());
                fscShouldPayPO.setCreateId(reqBO.getUserId());
                fscShouldPayPO.setCreateAccount(reqBO.getUserName());
                fscShouldPayPO.setCreateTime(new Date());
                fscShouldPayPO.setContractId(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getModelContractId());
                fscShouldPayPO.setContractNo(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getModelContractNo());
                fscShouldPayPO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayPO.setPenaltyRatio(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getProPayBreakScale());
                fscShouldPayPO.setSaleVoucherId(Long.valueOf(e.getSaleVoucherId()));
                fscShouldPayPO.setBuyerNo(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getBuynerNo());
                fscShouldPayPO.setBuyerName(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getBuynerName());
                fscShouldPayPO.setOrderType(StringUtils.isEmpty((Object)e.getOrderType()) ? null : Integer.valueOf(e.getOrderType()));
                fscShouldPayPO.setOrderSource(StringUtils.isEmpty((Object)e.getOrderSource()) ? null : Integer.valueOf(e.getOrderSource()));
                fscShouldPayPO.setTradeMode(tradeMode);
                fscShouldPayPO.setOrderOperStr(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOperatorId());
                fscShouldPayPO.setOrderCodeStr(e.getSaleVoucherNo());
                fscShouldPayPO.setOperatorName(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOperatorName());
                fscShouldPayPO.setAgreementId(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getProtocolId());
                fscShouldPayPO.setAgreementNo(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getPlaAgreementCode());
                fscShouldPayPO.setPurPlaceOrderName(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getPurPlaceOrderName());
                fscShouldPayPO.setOrderCreateTime(DateUtil.strToDate((String)e.getCreateTime()));
                fscShouldPayPO.setPayMethod(FscPayTypeEnum.ADVANCE_PAY.getCode());
                this.fscShouldPayForOrderClaimMapper.insert(fscShouldPayPO);
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            this.writeStateFailLog(reqBO, e.getMessage());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void writeStateFailLog(OrderForClaimSynAbilityReqBO orderForClaimSynAbilityReqBO, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(JSONObject.toJSONString((Object)((Object)orderForClaimSynAbilityReqBO)));
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_FOR_CLAIM_SYNC_FAIL);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(desc);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

