/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountOverdraftInfoListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountOverdraftInfoListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountOverdraftInfoListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.po.FscAccountCreditPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountOverdraftInfoListQueryAbilityService"})
public class FscAccountOverdraftInfoListQueryAbilityServiceImpl
implements FscAccountOverdraftInfoListQueryAbilityService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountOverdraftInfoList"})
    public FscAccountOverdraftInfoListQueryAbilityRspBO qryAccountOverdraftInfoList(@RequestBody FscAccountOverdraftInfoListQueryAbilityReqBO reqBO) {
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        UmcEnterpriseOrgQryDetailAbilityReqBO enterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        enterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(reqBO.getPayObjId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(enterpriseOrgQryDetailAbilityReqBO);
        if (umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null) {
            if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("1")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(0));
            } else if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("0")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(2));
            }
        }
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        fscAccountCredit.setCreateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setCreateTimeEnd(reqBO.getEndTime());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscAccountCreditPOList = this.fscMerchantMapper.selectOverdraftInfoPage(fscAccountCredit, page);
        Map payRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_PAY_RULE");
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        Map payBusiRangeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_BUSI_SCENE");
        ArrayList<FscAccountCreditInfoListRspBO> rows = new ArrayList<FscAccountCreditInfoListRspBO>();
        for (FscAccountCreditPO fscAccountCreditPO : fscAccountCreditPOList) {
            FscAccountCreditInfoListRspBO creditInfo = new FscAccountCreditInfoListRspBO();
            BeanUtils.copyProperties((Object)fscAccountCreditPO, (Object)creditInfo);
            if (creditInfo.getPayNodeRule() != null) {
                creditInfo.setPayNodeRuleStr((String)payNodeRuleMap.get(creditInfo.getPayNodeRule().toString()));
            }
            if (creditInfo.getPayRule() != null) {
                creditInfo.setPayRuleStr((String)payRuleMap.get(creditInfo.getPayRule().toString()));
            }
            String[] range = creditInfo.getPayBusiSceneRange().split(",");
            StringBuilder rangeStr = new StringBuilder();
            for (int i = 0; i < range.length; ++i) {
                rangeStr.append((String)payBusiRangeMap.get(range[i]));
                if (i == range.length - 1) continue;
                rangeStr.append(",");
            }
            creditInfo.setCreditDate(creditInfo.getCreateTime());
            creditInfo.setPayBusiSceneRangeStr(rangeStr.toString());
            BigDecimal payBreakScale = creditInfo.getPayBreakScale();
            if (null != payBreakScale) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                creditInfo.setCalculationFormula(sb.toString());
            }
            creditInfo.setAvailableAmount(creditInfo.getPayCreditAmount().subtract(creditInfo.getUsedAmount()));
            rows.add(creditInfo);
        }
        FscAccountOverdraftInfoListQueryAbilityRspBO rspBO = new FscAccountOverdraftInfoListQueryAbilityRspBO();
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryAccountOverdraftInfoListWelfare"})
    public FscAccountOverdraftInfoListQueryAbilityRspBO qryAccountOverdraftInfoListWelfare(@RequestBody FscAccountOverdraftInfoListQueryAbilityReqBO reqBO) {
        FscAccountPO qryBo = new FscAccountPO();
        qryBo.setOrgId(reqBO.getPayObjId());
        qryBo.setId(reqBO.getAccountId());
        FscAccountPO accountPO = this.fscAccountMapper.getModelBy(qryBo);
        accountPO.setUnionAvailableOverdraft(accountPO.getUnionAvailableOverdraft().compareTo(BigDecimal.ZERO) > 0 ? accountPO.getUnionAvailableOverdraft() : BigDecimal.ZERO);
        accountPO.setCompanyAvailableOverdraft(accountPO.getCompanyAvailableOverdraft().compareTo(BigDecimal.ZERO) > 0 ? accountPO.getCompanyAvailableOverdraft() : BigDecimal.ZERO);
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        fscAccountCredit.setMerchantCategory(Integer.valueOf(0));
        fscAccountCredit.setOrgId(this.operationOrgId);
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        fscAccountCredit.setUpdateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setUpdateTimeEnd(reqBO.getEndTime());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscAccountCreditPOList = this.fscMerchantMapper.selectOverdraftInfoPageWelfare(fscAccountCredit, page);
        if (fscAccountCreditPOList.size() > 1) {
            fscAccountCreditPOList = fscAccountCreditPOList.stream().filter(e -> e.getExceptionFlag().equals(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION)).collect(Collectors.toList());
        }
        Map payRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_PAY_RULE");
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        Map payBusiRangeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_BUSI_SCENE");
        ArrayList<FscAccountCreditInfoListRspBO> rows = new ArrayList<FscAccountCreditInfoListRspBO>();
        for (FscAccountCreditPO fscAccountCreditPO : fscAccountCreditPOList) {
            if (!FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(fscAccountCreditPO.getPayType())) {
                return new FscAccountOverdraftInfoListQueryAbilityRspBO();
            }
            FscAccountCreditInfoListRspBO creditInfo = new FscAccountCreditInfoListRspBO();
            BeanUtils.copyProperties((Object)fscAccountCreditPO, (Object)creditInfo);
            if (creditInfo.getPayNodeRule() != null) {
                creditInfo.setPayNodeRuleStr((String)payNodeRuleMap.get(creditInfo.getPayNodeRule().toString()));
            }
            if (creditInfo.getPayRule() != null) {
                creditInfo.setPayRuleStr((String)payRuleMap.get(creditInfo.getPayRule().toString()));
            }
            creditInfo.setCreditDate(creditInfo.getUpdateTime());
            creditInfo.setPayBusiSceneRangeStr((String)payBusiRangeMap.get("4"));
            BigDecimal payBreakScale = creditInfo.getPayBreakScale();
            if (null != payBreakScale) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                creditInfo.setCalculationFormula(sb.toString());
            }
            creditInfo.setEmployeeReturnAmount(accountPO.getEmployeeReturnAmount());
            creditInfo.setCompanyTotalCostAmount(accountPO.getCompanyTotalCostAmount());
            creditInfo.setUnionTotalCostAmount(accountPO.getUnionTotalCostAmount());
            creditInfo.setCompanyOverdraft(accountPO.getCompanyOverdraft());
            creditInfo.setCompanyOverdraftAmount(accountPO.getCompanyOverdraftAmount());
            creditInfo.setCompanyAvailableOverdraft(accountPO.getCompanyAvailableOverdraft());
            creditInfo.setUnionOverdraft(accountPO.getUnionOverdraft());
            creditInfo.setUnionOverdraftAmount(accountPO.getUnionOverdraftAmount());
            creditInfo.setUnionAvailableOverdraft(accountPO.getUnionAvailableOverdraft());
            creditInfo.setUnionTotalCostOverdraftAmount(accountPO.getUnionTotalCostOverdraftAmount());
            creditInfo.setCompanyTotalCostOverdraftAmount(accountPO.getCompanyTotalCostOverdraftAmount());
            rows.add(creditInfo);
        }
        FscAccountOverdraftInfoListQueryAbilityRspBO rspBO = new FscAccountOverdraftInfoListQueryAbilityRspBO();
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setRecordsTotal(Integer.valueOf(1));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

