/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscComOrderCancelEngineeringAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscNoticeEcomCancelInvoiceAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelEngineeringAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelEngineeringAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelEngineeringAbilityService"})
public class FscComOrderCancelEngineeringAbilityServiceImpl
implements FscComOrderCancelEngineeringAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelEngineeringAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscNoticeEcomCancelInvoiceAbilityService fscNoticeEcomCancelInvoiceAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    private static final Integer OBJ_TYPE_SEVEN = 7;

    @PostMapping(value={"dealEngineeringOrderCancel"})
    public FscComOrderCancelEngineeringAbilityRspBO dealEngineeringOrderCancel(@RequestBody FscComOrderCancelEngineeringAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderIds]\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u7528\u6237\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
        }
        FscOrderPO qryPO = new FscOrderPO();
        qryPO.setFscOrderIds(reqBO.getOrderIds());
        List list = this.fscOrderMapper.getList(qryPO);
        if (CollectionUtils.isEmpty((Collection)list) || list.size() != reqBO.getOrderIds().size()) {
            throw new FscBusinessException("191125", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        for (FscOrderPO fscOrderPO : list) {
            if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.INVOICING_RJECT.getCode().equals(fscOrderPO.getOrderState())) {
                throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u786e\u8ba4\u72b6\u6001");
            }
            if (!(!FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) || FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_AUDIT_REJECT.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_TO_BE_CONFIRM.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_RJECT.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_AUDITING.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.PUSH_FAIL.getCode().equals(fscOrderPO.getOrderState()))) {
                throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5f85\u786e\u8ba4\u72b6\u6001");
            }
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
                throw new FscBusinessException("191125", "\u7535\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\uff0c\u540e\u7eed\u72b6\u6001\u5f85\u4e0e\u7535\u5546\u5bf9\u63a5\u53d6\u6d88\u53d1\u7968\u63a5\u53e3\u540e\u542f\u7528");
            }
            if (FscBillStatus.INVOICING_AUDITING.getCode().equals(fscOrderPO.getOrderState())) {
                UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
                uacQryAuditLogReqBO.setObjId(fscOrderPO.getFscOrderId().toString());
                uacQryAuditLogReqBO.setObjType(OBJ_TYPE_SEVEN);
                log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u5165\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogReqBO));
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(uacQryAuditLogReqBO);
                log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u51fa\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogRspBO));
                if (uacQryAuditLogRspBO.getLogInfo().getAuditResult() != null) {
                    throw new FscBusinessException("191125", "\u5df2\u6709\u5ba1\u6279\u8bb0\u5f55\uff0c\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
                }
            }
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
                FscNoticeEcomCancelInvoiceAbilityReqBO abilityReqBO = new FscNoticeEcomCancelInvoiceAbilityReqBO();
                abilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                FscNoticeEcomCancelInvoiceAbilityRspBO abilityRspBO = this.fscNoticeEcomCancelInvoiceAbilityService.cancelInvoice(abilityReqBO);
                if (!abilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
                }
            }
            reqBO.setOrderState(fscOrderPO.getOrderState());
            String jsonString = JSON.toJSONString((Object)reqBO);
            FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
            busiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
            busiReqBO.setOrderNo(fscOrderPO.getOrderNo());
            busiReqBO.setIsEngineering(true);
            FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
            if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
                throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
            }
            this.sendMq(reqBO, fscOrderPO);
        }
        return new FscComOrderCancelEngineeringAbilityRspBO();
    }

    private void sendMq(FscComOrderCancelEngineeringAbilityReqBO reqBO, FscOrderPO orderPO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        if (orderPO.getRefundId() != null) {
            FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
            syncAbilityReqBO.setRefundIds(Collections.singletonList(orderPO.getRefundId()));
            this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        }
    }
}

