/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.base.FscReqBaseBO;
import com.tydic.fsc.common.ability.api.FscContractPushFailTaskAbilityService;
import com.tydic.fsc.common.ability.bo.FscContractPushFailTaskAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscContractPushFailTaskAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscPushContractBusiService;
import com.tydic.fsc.common.busi.bo.FscPushContractBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushContractPayBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscPushLogSearchPO;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscContractPushFailTaskAbilityService"})
public class FscContractPushFailTaskAbilityServiceImpl
implements FscContractPushFailTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscContractPushFailTaskAbilityServiceImpl.class);
    @Resource
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscPushContractBusiService fscPushContractBusiService;

    @PostMapping(value={"pushContractFailTask"})
    public FscContractPushFailTaskAbilityRspBO pushContractFailTask(@RequestBody FscContractPushFailTaskAbilityReqBO reqBO) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(FscConstants.FscPushType.PUSH_CONTRACT_SETTLE);
        typeList.add(FscConstants.FscPushType.PUSH_CONTRACT_PAY);
        LocalDate today = LocalDate.now();
        LocalDate previousMonth = today.minusMonths(1L);
        Date beforeDate = Date.from(previousMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
        FscPushLogSearchPO searchPO = new FscPushLogSearchPO();
        searchPO.setTypeList(typeList);
        searchPO.setBeforeDate(beforeDate);
        searchPO.setStatus(FscConstants.FscPushStatus.FAIL);
        List failTaskList = this.fscPushLogMapper.getDealTaskList(searchPO);
        if (!CollectionUtils.isEmpty((Collection)failTaskList)) {
            Set failObjectIdSet = failTaskList.stream().filter(e -> e.getObjectId() != null).map(FscPushLogPO::getObjectId).collect(Collectors.toSet());
            searchPO.setObjectIdList(new ArrayList(failObjectIdSet));
            searchPO.setStatus(FscConstants.FscPushStatus.SUCCESS);
            List successTaskList = this.fscPushLogMapper.getDealTaskList(searchPO);
            if (!CollectionUtils.isEmpty((Collection)successTaskList)) {
                Set successObjectIdSet = successTaskList.stream().filter(e -> e.getObjectId() != null).map(FscPushLogPO::getObjectId).collect(Collectors.toSet());
                failTaskList.removeAll(successTaskList);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)failTaskList)) {
            Map<Long, List<FscPushLogPO>> objMap = failTaskList.stream().filter(e -> e.getObjectId() != null).collect(Collectors.groupingBy(FscPushLogPO::getObjectId));
            for (Long fscOrderId : objMap.keySet()) {
                FscReqBaseBO busiReqBO;
                Integer type = objMap.get(fscOrderId).get(0).getType();
                if (FscConstants.FscPushType.PUSH_CONTRACT_SETTLE.equals(type)) {
                    busiReqBO = new FscPushContractBusiReqBO();
                    busiReqBO.setFscOrderId(fscOrderId);
                    busiReqBO.setIsContractBack(1);
                    try {
                        this.fscPushContractBusiService.dealPushContract((FscPushContractBusiReqBO)busiReqBO);
                    }
                    catch (Exception e2) {
                        log.error("\u5408\u540c\u56de\u8c03\u63a8\u9001\u7ed3\u7b97\u5355\u63a5\u53e3\u5f02\u5e38" + e2.getMessage());
                    }
                }
                if (!FscConstants.FscPushType.PUSH_CONTRACT_PAY.equals(type)) continue;
                busiReqBO = new FscPushContractPayBusiReqBO();
                busiReqBO.setFscOrderId(fscOrderId);
                busiReqBO.setIsContractBack(1);
                try {
                    this.fscPushContractBusiService.dealPushContractPay((FscPushContractPayBusiReqBO)busiReqBO);
                }
                catch (Exception e3) {
                    log.error("\u5408\u540c\u56de\u8c03\u63a8\u9001\u4ed8\u6b3e\u5355\u63a5\u53e3\u5f02\u5e38" + e3.getMessage());
                }
            }
        }
        FscContractPushFailTaskAbilityRspBO rspBO = new FscContractPushFailTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

