/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscStockItemBO;
import com.tydic.fsc.bo.FscStockItemListQryAbilityReqBO;
import com.tydic.fsc.bo.FscStockItemListQryAbilityRspBO;
import com.tydic.fsc.common.ability.api.FscStockItemListQryAbilityService;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscStockItemMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscStockItemListQryAbilityService"})
public class FscStockItemListQryAbilityServiceImpl
implements FscStockItemListQryAbilityService {
    @Autowired
    private FscStockItemMapper fscStockItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryStockItemList"})
    public FscStockItemListQryAbilityRspBO qryStockItemList(@RequestBody FscStockItemListQryAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List fscStockItemBOList = this.fscStockItemMapper.getListPageByCondition(reqBO, page);
        if (CollectionUtils.isEmpty((Collection)fscStockItemBOList)) {
            return new FscStockItemListQryAbilityRspBO();
        }
        List fscOrderIdList = fscStockItemBOList.stream().map(FscStockItemBO::getFscOrderId).collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIdList);
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        Map<Long, FscOrderPO> fscOrderMap = fscOrderPOS.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, m -> m));
        for (FscStockItemBO fscStockItemBO : fscStockItemBOList) {
            FscOrderPO fscOrder;
            if (!StringUtils.isEmpty((Object)fscStockItemBO.getTaxRate())) {
                fscStockItemBO.setTaxRateStr(fscStockItemBO.getTaxRate() + "%");
            }
            if (null == (fscOrder = fscOrderMap.get(fscStockItemBO.getFscOrderId()))) continue;
            fscStockItemBO.setOrderSource(fscOrder.getOrderSource());
        }
        FscStockItemListQryAbilityRspBO rspBO = new FscStockItemListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(fscStockItemBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

