/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundInvoiceTempInvoiceQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceTempInvoiceQryListRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceTempInvoiceQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceTempInvoiceQryRspBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundInvoiceTempInvoiceQryAbilityService"})
public class FscFinanceRefundInvoiceTempInvoiceQryAbilityServiceImpl
implements FscFinanceRefundInvoiceTempInvoiceQryAbilityService {
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryRefundInvoiceTempInvoice"})
    public FscFinanceRefundInvoiceTempInvoiceQryRspBO qryRefundInvoiceTempInvoice(@RequestBody FscFinanceRefundInvoiceTempInvoiceQryReqBO reqBo) {
        FscFinanceRefundInvoiceTempInvoiceQryRspBO rspBO = new FscFinanceRefundInvoiceTempInvoiceQryRspBO();
        this.valid(reqBo);
        FscInvoiceRefundRelationTempPo fscInvoiceRefundRelationTempPoReq = new FscInvoiceRefundRelationTempPo();
        fscInvoiceRefundRelationTempPoReq.setTempId(reqBo.getTempId());
        fscInvoiceRefundRelationTempPoReq.setContractId(reqBo.getContractId());
        fscInvoiceRefundRelationTempPoReq.setRefundType(reqBo.getRefundType());
        fscInvoiceRefundRelationTempPoReq.setRefundId(reqBo.getRefundId());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscInvoiceRefundRelationTempMapper.getListPage(fscInvoiceRefundRelationTempPoReq, page);
        List list = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceRefundInvoiceTempInvoiceQryListRspBO.class);
        if (!list.isEmpty()) {
            List invoiceIds = listPage.stream().map(FscInvoiceRefundRelationTempPo::getInvoiceId).filter(Objects::nonNull).collect(Collectors.toList());
            FscInvoicePO fscInvoicePOReq = new FscInvoicePO();
            fscInvoicePOReq.setFscOrderIds(invoiceIds);
            List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePOReq);
            Map fscInvoiceMap = fscInvoicePOList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, Function.identity()));
            Map fscRefundTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_TYPE");
            Map fscFinanceInvoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_INVOICE_TYPE");
            Map fscInvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            for (FscFinanceRefundInvoiceTempInvoiceQryListRspBO bo : list) {
                FscInvoicePO fscInvoice = (FscInvoicePO)fscInvoiceMap.get(bo.getInvoiceId());
                if (fscInvoice != null) {
                    this.buildInvoice(fscInvoice, bo);
                }
                if (bo.getRefundType() != null) {
                    bo.setRefundTypeStr((String)fscRefundTypeMap.get(bo.getRefundType().toString()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getInvoiceType())) {
                    bo.setInvoiceTypeStr((String)fscFinanceInvoiceTypeMap.get(bo.getInvoiceType()));
                }
                if (bo.getInvoiceCategory() == null) continue;
                bo.setInvoiceCategoryStr((String)fscInvoiceCategoryMap.get(bo.getInvoiceCategory().toString()));
            }
        }
        rspBO.setRows(list);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundInvoiceTempInvoiceQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e34\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u51b2\u9500\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void buildInvoice(FscInvoicePO fscInvoice, FscFinanceRefundInvoiceTempInvoiceQryListRspBO bo) {
        bo.setInvoiceAmt(fscInvoice.getAmt());
        bo.setInvoiceNo(fscInvoice.getInvoiceNo());
        bo.setInvoiceCode(fscInvoice.getInvoiceCode());
        bo.setBuyName(fscInvoice.getBuyName());
        bo.setInvoiceType(fscInvoice.getInvoiceType());
        bo.setInvoiceCategory(fscInvoice.getInvoiceCategory());
        bo.setBillDate(fscInvoice.getBillDate());
    }
}

