/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.bo.finance;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceReqBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceRspBo;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundStatusUpdateBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundStatusUpdateBusiServiceImpl
implements FscFinanceRefundStatusUpdateBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;

    @Override
    public FscFinanceBillStatusUpdateServiceRspBo dealRefundStatusUpdate(FscFinanceBillStatusUpdateServiceReqBo reqBo) {
        ArrayList<Long> refundIds = new ArrayList<Long>(reqBo.getBillIds().size());
        for (String billId : reqBo.getBillIds()) {
            refundIds.add(Long.valueOf(billId));
        }
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundIds(refundIds);
        refundFinancePO.setPostingStatus(Integer.valueOf(reqBo.getBillStatus()));
        refundFinancePO.setPostingDate(new Date());
        this.fscRefundFinanceMapper.updatePostStatus(refundFinancePO);
        FscOrderRefundPO orderRefundPO = new FscOrderRefundPO();
        orderRefundPO.setRefundIdList(refundIds);
        orderRefundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.FINANCE_POST);
        this.fscOrderRefundMapper.updateByRefundIds(orderRefundPO);
        ArrayList<FscOrdStateChgLogPO> chgLogPOList = new ArrayList<FscOrdStateChgLogPO>();
        for (String billId : reqBo.getBillIds()) {
            FscOrdStateChgLogPO chgLogPO = new FscOrdStateChgLogPO();
            chgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            chgLogPO.setFscOrderId(Long.valueOf(billId));
            chgLogPO.setChgTime(new Date());
            chgLogPO.setOldState(FscConstants.RefundInvoiceStatus.FINANCE_AUDITED);
            chgLogPO.setOperId(reqBo.getOperAccount());
            chgLogPO.setNewState(FscConstants.RefundInvoiceStatus.FINANCE_POST);
            chgLogPOList.add(chgLogPO);
        }
        this.fscOrdStateChgLogMapper.insertBatch(chgLogPOList);
        FscFinanceBillStatusUpdateServiceRspBo rspBo = new FscFinanceBillStatusUpdateServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

