/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscBillClaimRefundBackBusiService;
import com.tydic.fsc.common.busi.bo.FscBillClaimRefundBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillClaimRefundBackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillClaimRefundBackBusiServiceImpl
implements FscBillClaimRefundBackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillClaimRefundBackBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u4e1a\u8d22\u9a73\u56de";
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Value(value="${OPER_ORG_ID:436}")
    private String operOrgId;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;

    @Override
    public FscBillClaimRefundBackBusiRspBO dealClaimRefundBack(FscBillClaimRefundBackBusiReqBO reqBO) {
        FscBillClaimRefundBackBusiRspBO rspBO = new FscBillClaimRefundBackBusiRspBO();
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u4fe1\u606f");
        }
        if (!FscConstants.RefundPushStatus.PUSH_SUCCESS.equals(refundPO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u672a\u63a8\u9001");
        }
        if (!FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        int count = 0;
        if (FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
            Long againstId = this.fscOrderRefundMapper.queryRefundIdByRefundId(refundPO.getRefundId());
            FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
            fscClaimDetailPO.setRefundId(refundPO.getRefundId());
            fscClaimDetailPO.setAgainstId(againstId);
            count = this.fscClaimDetailMapper.updateRefundAmtBackByRefundIdChange(fscClaimDetailPO);
        } else {
            count = this.fscClaimDetailMapper.updateRefundAmtBackByRefundId(refundPO.getRefundId());
        }
        if (count <= 0) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u6536\u6b3e\u8ba4\u9886\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        List list = this.fscPayClaimRefundMapper.queryByRefundId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u5173\u8054\u4fe1\u606f");
        }
        for (FscPayClaimRefundPO po : list) {
            po.setRefundAmt(po.getRefundAmt().multiply(new BigDecimal(-1)));
        }
        this.fscPayClaimRefundMapper.updateRefundAmountBatch(list);
        this.fscPayClaimRefundMapper.deleteByRefundId(reqBO.getRefundId());
        this.fscPayClaimRefundDetailMapper.deleteByRefundId(reqBO.getRefundId());
        List payRefundDetailPOS = this.fscPayRefundDetailMapper.queryByRefundId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)payRefundDetailPOS)) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u660e\u7ec6\u5f02\u5e38");
        }
        FscPayRefundDetailPO fscPayRefundDetailPO = (FscPayRefundDetailPO)payRefundDetailPOS.get(0);
        fscPayRefundDetailPO.setClaimAmt(fscPayRefundDetailPO.getClaimAmt().negate());
        fscPayRefundDetailPO.setClaimType(null);
        this.fscPayRefundDetailMapper.updateClaimAmtBatch(Collections.singletonList(fscPayRefundDetailPO));
        refundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_BACK);
        refundPO.setExt2(reqBO.getBackReason());
        this.fscOrderRefundMapper.updateById(refundPO);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("backFlag", FscConstants.BillBackFlag.BACK);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.releasePlan(refundPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void releasePlan(FscOrderRefundPO refundPO) {
        FscBillAddPushLogBusiReqBO logBusiReqBO;
        block8: {
            List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(refundPO.getRefundId());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            logBusiReqBO = new FscBillAddPushLogBusiReqBO();
            logBusiReqBO.setPushStatus(Integer.valueOf(0));
            logBusiReqBO.setObjectId(refundPO.getRefundId());
            logBusiReqBO.setCreateTime(new Date());
            logBusiReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
            try {
                QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
                qryUnifySettleTokenReqBO.setUserId(refundPO.getExt1());
                QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
                if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
                }
                logBusiReqBO.setObjectNo(refundPO.getRefundNo());
                FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
                JSONObject jsonObject = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                for (FscOperateCapitalPlanPO x : list) {
                    JSONObject bo = new JSONObject();
                    bo.put("period", (Object)x.getPeriod());
                    bo.put("itemId", (Object)x.getItemId());
                    bo.put("itemName", (Object)x.getItemName());
                    bo.put("controlMode", (Object)x.getControlMode());
                    bo.put("exeType", (Object)"RZY");
                    if (x.getPlanAmount() != null) {
                        bo.put("planAmount", (Object)x.getPlanAmount().negate());
                    }
                    bo.put("amount", (Object)x.getUseAmount().negate());
                    bo.put("fromSource", (Object)"EBAY");
                    bo.put("contractNum", (Object)x.getContractNum());
                    if ("BILL".equals(x.getControlMode())) {
                        bo.put("billId", (Object)refundPO.getRefundId());
                        bo.put("billNum", (Object)refundPO.getRefundNo());
                    }
                    bo.put("recOrgName", (Object)refundPO.getPayeeName());
                    bo.put("fromBillId", (Object)(refundPO.getRefundId() + ""));
                    bo.put("fromBillLineId", (Object)x.getId());
                    bo.put("deptId", (Object)x.getDeptId());
                    bo.put("deptName", (Object)x.getDeptName());
                    bo.put("orgId", (Object)(x.getOrgId() != null ? x.getOrgId() : this.operOrgId));
                    bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                    bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                    jsonArray.add((Object)bo);
                }
                jsonObject.put("head", (Object)jsonArray);
                JSONArray jsonArray1 = new JSONArray();
                jsonArray1.add((Object)jsonObject);
                logBusiReqBO.setPushData(jsonArray1.toJSONString());
                planReqBO.setJsonObject(jsonArray1);
                planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
                FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
                logBusiReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
                logBusiReqBO.setRespData(fundingPlanRspBO.getRespData());
                logBusiReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
                if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25" + fundingPlanRspBO.getRespDesc());
                }
                logBusiReqBO.setPushStatus(Integer.valueOf(1));
                FscPlanPayItemPo planPayItemPo = new FscPlanPayItemPo();
                planPayItemPo.setFscOrderId(refundPO.getRefundId());
                this.fscPlanPayItemMapper.deleteByFscOrderId(planPayItemPo);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8d44\u91d1\u8ba1\u5212\u5360\u7528/\u91ca\u653e\u63a5\u53e3\u5931\u8d25,\u7ed3\u7b97\u5355id{},\u5165\u53c2{}", (Object)refundPO.getRefundId(), (Object)e.getMessage());
                if (logBusiReqBO.getRespData() != null) break block8;
                logBusiReqBO.setRespData(e.getMessage());
            }
        }
        this.fscBillAddPushLogBusiService.addPurchasePushLog(logBusiReqBO);
    }
}

