/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bill.ability.enums.FscSettleStateEnum;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.common.busi.api.FscFinanceBillStatusUpdateExtBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtReqBo;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtRspBo;
import com.tydic.fsc.common.util.DateUtils;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.base.constants.UocCoreConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceBillStatusUpdateExtBusiServiceImpl
implements FscFinanceBillStatusUpdateExtBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBillStatusUpdateExtBusiServiceImpl.class);
    private static final String BUSI_NAME = "\u5171\u4eab\u5355\u636e\u8fc7\u8d26";
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;

    @Override
    public FscFinanceBillStatusUpdateServiceExtRspBo dealStatusUpdate(FscFinanceBillStatusUpdateServiceExtReqBo reqBo) {
        List<Long> ids = reqBo.getBillIds().stream().map(Long::valueOf).collect(Collectors.toList());
        FscFinanceBillStatusUpdateServiceExtRspBo rspBaseBO = new FscFinanceBillStatusUpdateServiceExtRspBo();
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u6210\u529f");
        if (reqBo.getBillType().equals(6) || reqBo.getBillType().equals(7)) {
            FscFinanceWriteOffAdjustPO set = new FscFinanceWriteOffAdjustPO();
            set.setUpdateTime(new Date());
            set.setBillStatus(FscConstants.WriteOffBillStatus.FINANCE_END);
            FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
            where.setAdjustIds(ids);
            this.fscFinanceWriteOffAdjustMapper.updateBy(set, where);
            return rspBaseBO;
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderIds(ids);
        List list = this.fscOrderFinanceMapper.getList(financePO);
        if (list.size() != ids.size()) {
            rspBaseBO.setRespCode("190000");
            rspBaseBO.setRespDesc("billIds\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (reqBo.getBillType().equals(2)) {
            FscOrderPO orderPO = new FscOrderPO();
            orderPO.setPostingStatus("1");
            orderPO.setFscOrderIds(ids);
            if (!StringUtils.isEmpty((String)reqBo.getOperTime())) {
                orderPO.setPostingDate(DateUtils.strToDate(reqBo.getOperTime()));
            }
            this.fscOrderMapper.updatePostingStatus(orderPO);
            this.fscOrderFinanceMapper.updatePostingStatus(reqBo.getBillIds(), reqBo.getOperTime());
        } else if (reqBo.getBillType().equals(3)) {
            FscOrderPO jgjfOrderPO = new FscOrderPO();
            jgjfOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderIds(ids);
            this.fscOrderMapper.updateBy(jgjfOrderPO, where);
            FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
            fscOrderFinancePO.setBillIds(reqBo.getBillIds());
            fscOrderFinancePO.setPostingDate(DateUtil.strToDate((String)reqBo.getOperTime()));
            fscOrderFinancePO.setUpdateUserId(reqBo.getOperAccount());
            fscOrderFinancePO.setUpdateUserName(reqBo.getOperName());
            this.fscOrderFinanceMapper.updatePostingStatusByIds(fscOrderFinancePO);
            List payOrderIdList = this.fscShouldPayMapper.getFinancePayOrderIdBatch(ids);
            List payOrderStrList = payOrderIdList.stream().map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)payOrderIdList)) {
                FscOrderPO payOrderPO = new FscOrderPO();
                payOrderPO.setPostingStatus("1");
                payOrderPO.setFscOrderIds(payOrderIdList);
                if (!StringUtils.isEmpty((String)reqBo.getOperTime())) {
                    payOrderPO.setPostingDate(DateUtils.strToDate(reqBo.getOperTime()));
                }
                this.fscOrderMapper.updatePostingStatus(payOrderPO);
                fscOrderFinancePO.setBillIds(payOrderStrList);
                this.fscOrderFinanceMapper.updatePostingStatusByIds(fscOrderFinancePO);
            }
        } else {
            FscOrderPO set = new FscOrderPO();
            set.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderIds(ids);
            this.fscOrderMapper.updateBy(set, where);
            this.fscOrderFinanceMapper.updatePostingStatus(reqBo.getBillIds(), reqBo.getOperTime());
            ids.forEach(e -> {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(e);
                FscOrderPO orderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
                try {
                    List<FscShouldPayBO> fscShouldPayBOS = this.dealOrderCheck(orderPO);
                    if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
                        this.createShouldPay(fscShouldPayBOS, orderPO, reqBo);
                    }
                }
                catch (Exception ex) {
                    log.error("\u751f\u6210\u5e94\u4ed8\u62a5\u9519\uff1a" + ex);
                    throw new FscBusinessException("190000", "\u751f\u6210\u5e94\u4ed8\u62a5\u9519\uff1a" + ex);
                }
            });
        }
        return rspBaseBO;
    }

    private List<FscShouldPayBO> dealOrderCheck(FscOrderPO fscOrderPO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            return this.dealAccountRule(fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        }
        FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
        atomReqBO.setRelId(fscOrderPO.getFscOrderId());
        FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
        if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
        }
        fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        return this.dealAccountRule(fscOrderPO, fscOrderInfoBoMap, fscSaleOrderListQueryAtomRspBO.getOrderCodeList(), fscSaleOrderListQueryAtomRspBO.getOrderOperList());
    }

    private List<FscShouldPayBO> dealAccountRule(FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        if (FscConstants.SettleType.ORDER.equals(fscOrderPO.getSettleType())) {
            return fscShouldPayBOS;
        }
        if (this.qryHistoryShouldPay(fscOrderPO)) {
            return fscShouldPayBOS;
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u53d1\u7968\u5217\u8868\u4fe1\u606f");
        }
        Map<Long, List<FscInvoicePO>> invoiceMap = fscInvoicePOList.stream().collect(Collectors.groupingBy(FscInvoicePO::getContractId));
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getListByOrderIdGroupByContractId(fscOrderPO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f");
        }
        FscOrderFinancePO fscOrderFinancePOReq = new FscOrderFinancePO();
        fscOrderFinancePOReq.setFscOrderId(fscOrderPO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePOReq);
        if (Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5171\u4eab\u76f8\u5173\u4fe1\u606f");
        }
        fscOrderRelationPOList.forEach(relationPO -> {
            if (Objects.isNull(relationPO.getContractId())) {
                throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u7684\u5408\u540c\u4fe1\u606f");
            }
            if (!CollectionUtils.isEmpty((Map)invoiceMap) && !invoiceMap.containsKey(relationPO.getContractId())) {
                throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u53d1\u7968\u4fe1\u606f\uff0c \u5408\u540c\u7f16\u7801\uff1a" + relationPO.getContractNo());
            }
            List contractInvoiceList = (List)invoiceMap.get(relationPO.getContractId());
            List invoiceNoList = contractInvoiceList.stream().map(e -> Objects.nonNull(e.getFullElecNo()) ? e.getFullElecNo() : e.getInvoiceNo()).collect(Collectors.toList());
            Optional<String> maxDate = contractInvoiceList.stream().map(FscInvoicePO::getBillDate).max(String::compareTo);
            String billDateMax = maxDate.orElse(null);
            Optional<FscOrderInfoBO> max = fscOrderInfoBoMap.values().stream().filter(e -> relationPO.getContractId().equals(e.getFinanceContractId())).max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime));
            if (!max.isPresent()) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = max.get();
            if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
                if (CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                    return;
                }
                ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
                for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                    if (UocCoreConstant.PayNode.GZ.equals(payListBO.getPayNode()) && FscConstants.PaymentMethod.SHOULD_PAY.equals(payListBO.getPayType()) && payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) > 0 && !FscSettleStateEnum.QUALITY.getCode().equals(relationPO.getSettleState())) {
                        payListBOS.add(payListBO);
                        continue;
                    }
                    if (!UocCoreConstant.PayNode.GZ.equals(payListBO.getPayNode()) || !FscConstants.PaymentMethod.DEPOSIT.equals(payListBO.getPayType()) || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0 || FscSettleStateEnum.INSPECTION.getCode().equals(relationPO.getSettleState())) continue;
                    payListBOS.add(payListBO);
                }
                if (!CollectionUtils.isEmpty(payListBOS)) {
                    payListBOS.forEach(e -> {
                        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                        fscShouldPayBO.setShouldPayType(FscConstants.PaymentMethod.DEPOSIT.equals(e.getPayType()) ? FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY : FscConstants.ShouldPayType.SIGN_PAY);
                        fscShouldPayBO.setShouldPayAmount(relationPO.getSettleAmt().multiply(e.getNodePayRatio()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.POSTING_ORDER);
                        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                        fscShouldPayBO.setPayType(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE);
                        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                        fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                        fscShouldPayBO.setContractId(relationPO.getContractId());
                        fscShouldPayBO.setContractNo(relationPO.getContractNo());
                        fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                        fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                        fscShouldPayBO.setShouldPayDate(this.calShouldPayDateNew(e.getNodePayCycle()));
                        fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                        fscShouldPayBO.setInvoiceNo(String.join((CharSequence)",", invoiceNoList));
                        fscShouldPayBO.setBillDate(billDateMax);
                        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                        fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                        fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                        fscShouldPayBO.setShouldPayMethod(e.getPayType());
                        fscShouldPayBO.setContractName(fscOrderInfoBO.getContractName());
                        fscShouldPayBO.setContractType(!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getUnifyContractType()) ? Integer.valueOf(fscOrderInfoBO.getUnifyContractType()) : null);
                        fscShouldPayBO.setVendorSiteId(fscOrderFinancePO.getVendorSiteId());
                        fscShouldPayBO.setVendorSiteName(fscOrderFinancePO.getVendorSiteName());
                        fscShouldPayBO.setSupplierNo(fscOrderInfoBO.getSupplierNo());
                        fscShouldPayBO.setSupplierErpNo(fscOrderInfoBO.getSupplierErpNo());
                        fscShouldPayBO.setSettlePlatform(fscOrderPO.getSettlePlatform());
                        fscShouldPayBO.setCurrency(fscOrderFinancePO.getCurrency());
                        fscShouldPayBO.setExchangeRate(fscOrderFinancePO.getExchangeRate());
                        fscShouldPayBO.setProContractId(relationPO.getProContractId());
                        fscShouldPayBO.setProContractName(relationPO.getProContractName());
                        fscShouldPayBO.setProContractNo(relationPO.getProContractNo());
                        fscShouldPayBO.setProContractType(relationPO.getProContractType());
                        fscShouldPayBO.setProContractSource(relationPO.getProContractSource());
                        fscShouldPayBOS.add(fscShouldPayBO);
                    });
                }
            }
        });
        return fscShouldPayBOS;
    }

    private Date calShouldPayDateNew(String nodePayCycle) {
        int payDays = 0;
        if (!StringUtils.isEmpty((String)nodePayCycle) && !nodePayCycle.equals("null")) {
            payDays = Integer.parseInt(nodePayCycle);
        }
        Calendar now = Calendar.getInstance();
        now.add(5, payDays);
        return now.getTime();
    }

    private boolean qryHistoryShouldPay(FscOrderPO fscOrderPO) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayPO.setObjectType(FscConstants.ShouldObjectType.POSTING_ORDER);
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        return !CollectionUtils.isEmpty((Collection)shouldPayPOList);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscOrderPO fscOrderPO, FscFinanceBillStatusUpdateServiceExtReqBo reqBo) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBo.getOperAccount());
            fscPayShouldPayCreateAtomReqBO.setName(reqBo.getOperName());
            List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(fscOrderPO.getFscOrderId());
            String acceptOrderCode = String.join((CharSequence)",", acceptOrderCodes);
            for (FscShouldPayBO bo : fscShouldPayBOS) {
                bo.setAcceptOrderCode(acceptOrderCode);
                FscOrderRelationPO relationPO = new FscOrderRelationPO();
                relationPO.setFscOrderId(fscOrderPO.getFscOrderId());
                relationPO.setContractId(bo.getContractId());
                if (FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY.equals(bo.getShouldPayType())) {
                    relationPO.setQualityDate(bo.getShouldPayDate());
                } else {
                    relationPO.setShouldPayDate(bo.getShouldPayDate());
                }
                this.fscOrderRelationMapper.updateShouldPayDate(relationPO);
            }
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }
}

