/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.busi.api.FscFinanceInvoiceRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceInvoiceRefundApprovalBusiServiceImpl
implements FscFinanceInvoiceRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;

    @Override
    public FscFinanceInvoiceRefundApprovalBusiRspBO dealFinanceInvoiceRefundApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO) {
        FscFinanceInvoiceRefundApprovalBusiRspBO rspBO = new FscFinanceInvoiceRefundApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        for (Long refundId : reqBO.getRefundIds()) {
            FscOrderRefundPO fscOrderRefundPO;
            UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, refundId, fscOrderRefundPO = this.getOrderRefund(refundId));
            if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
                refundIds.add(refundId);
            }
            this.updateRefundFinance(reqBO, refundId);
        }
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateRefundFinance(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult()) ? FscConstants.RefundInvoiceStatus.FINANCE_AUDITED : FscConstants.RefundInvoiceStatus.FINANCE_AUDIT_REJECT);
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.FINANCE_PURCHASE_REFUND_INVOICE_PROCESS);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }
}

