/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.common.busi.api.FscFinancePayRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinancePayRefundApprovalBusiServiceImpl
implements FscFinancePayRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscFinanceOccupyRefundInfoAtomService fscFinanceOccupyRefundInfoAtomService;
    @Autowired
    private FscFinanceReleaseRefundInfoAtomService fscFinanceReleaseRefundInfoAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;

    @Override
    public FscFinancePayRefundApprovalBusiRspBO dealFinancePayRefundApproval(FscFinancePayRefundApprovalBusiReqBO reqBO) {
        FscFinancePayRefundApprovalBusiRspBO rspBO = new FscFinancePayRefundApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        for (Long refundId : reqBO.getRefundIds()) {
            FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(refundId);
            FscPayRefundDetailPO fscPayRefundDetailPO = this.getPayRefundDetail(refundId);
            FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(refundId);
            UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, refundId, fscOrderRefundPO);
            if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
                refundIds.add(refundId);
            }
            this.updateRefundFinance(reqBO, refundId);
            this.releaseRefundInfo(refundId, fscOrderRefundPO);
            this.addFinanceBankStatement(reqBO, refundId, fscPayRefundDetailPO);
            this.addFinanceDraftInfo(reqBO, refundId, fscPayRefundDetailPO);
            this.occupyRefundInfo(refundId, fscOrderRefundPO, fscRefundFinancePO);
        }
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addFinanceBankStatement(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(thisRefundId);
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBO.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setRefundId(thisRefundId);
            bankStatement.setRefundDetailId(fscPayRefundDetailPO.getRefundDetailId());
            bankStatement.setRefundShouldPayId(fscPayRefundDetailPO.getRefundShouldPayId());
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceDraftInfo(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(thisRefundId);
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBO.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setRefundId(thisRefundId);
            draftInfo.setRefundDetailId(fscPayRefundDetailPO.getRefundDetailId());
            draftInfo.setRefundShouldPayId(fscPayRefundDetailPO.getRefundShouldPayId());
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateRefundFinance(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        updateFscRefundFinanceSet.setIsAgent(reqBO.getIsAgent());
        updateFscRefundFinanceSet.setAgentCompanyCode(reqBO.getAgentCompanyCode());
        updateFscRefundFinanceSet.setAgentCompanyName(reqBO.getAgentCompanyName());
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.FINANCE_PAY_REFUND_APPROVAL);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private FscPayRefundDetailPO getPayRefundDetail(Long thisRefundId) {
        FscPayRefundDetailPO qryFscPayRefundDetail = new FscPayRefundDetailPO();
        qryFscPayRefundDetail.setRefundId(thisRefundId);
        return this.fscPayRefundDetailMapper.getModelBy(qryFscPayRefundDetail);
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long thisRefundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(thisRefundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscFinanceDraftInfoPO> getFinanceDraftList(Long refundId) {
        FscFinanceDraftInfoPO qryFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        qryFscFinanceDraftInfo.setRefundId(refundId);
        return this.fscFinanceDraftInfoMapper.getList(qryFscFinanceDraftInfo);
    }

    private List<FscFinanceBankStatementPO> getFinanceBankStatementList(Long refundId) {
        FscFinanceBankStatementPO qryFscFinanceBankStatement = new FscFinanceBankStatementPO();
        qryFscFinanceBankStatement.setRefundId(refundId);
        return this.fscFinanceBankStatementMapper.getList(qryFscFinanceBankStatement);
    }

    private void occupyRefundInfo(Long thisRefundId, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO> draftList = new ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomBankBO> bankList = new ArrayList<FscFinanceOccupyRefundInfoAtomBankBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList = new ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO>(1);
        this.packageOccupyRefundInfo(thisRefundId, draftList, bankList, supplyList);
        FscFinanceOccupyRefundInfoAtomReqBO fscFinanceOccupyRefundInfoAtomReqBO = new FscFinanceOccupyRefundInfoAtomReqBO();
        fscFinanceOccupyRefundInfoAtomReqBO.setObjId(fscOrderRefundPO.getRefundId());
        fscFinanceOccupyRefundInfoAtomReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
        fscFinanceOccupyRefundInfoAtomReqBO.setDraftList(draftList);
        fscFinanceOccupyRefundInfoAtomReqBO.setBankList(bankList);
        fscFinanceOccupyRefundInfoAtomReqBO.setSupplyList(supplyList);
        FscFinanceOccupyRefundInfoAtomRspBO fscFinanceOccupyRefundInfoAtomRspBO = this.fscFinanceOccupyRefundInfoAtomService.dealOccupyRefundInfo(fscFinanceOccupyRefundInfoAtomReqBO);
        if (!fscFinanceOccupyRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceOccupyRefundInfoAtomRspBO.getRespCode(), fscFinanceOccupyRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void packageOccupyRefundInfo(Long thisRefundId, List<FscFinanceOccupyRefundInfoAtomDraftBO> draftList, List<FscFinanceOccupyRefundInfoAtomBankBO> bankList, List<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList) {
        List<FscFinanceDraftInfoPO> fscFinanceDraftInfoList = this.getFinanceDraftList(thisRefundId);
        List<FscFinanceBankStatementPO> financeBankStatementList = this.getFinanceBankStatementList(thisRefundId);
        for (FscFinanceDraftInfoPO fscFinanceDraftInfoPO : fscFinanceDraftInfoList) {
            if (FscConstants.FinanceDraftType.SUPPLY.equals(fscFinanceDraftInfoPO.getDraftType())) {
                FscFinanceOccupyRefundInfoAtomSupplyBO fscFinanceOccupyRefundInfoAtomSupplyBO = (FscFinanceOccupyRefundInfoAtomSupplyBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomSupplyBO.class);
                supplyList.add(fscFinanceOccupyRefundInfoAtomSupplyBO);
                continue;
            }
            FscFinanceOccupyRefundInfoAtomDraftBO fscFinanceOccupyRefundInfoAtomDraftBO = (FscFinanceOccupyRefundInfoAtomDraftBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomDraftBO.class);
            draftList.add(fscFinanceOccupyRefundInfoAtomDraftBO);
        }
        for (FscFinanceBankStatementPO fscFinanceBankStatementPO : financeBankStatementList) {
            FscFinanceOccupyRefundInfoAtomBankBO fscFinanceOccupyRefundInfoAtomBankBO = (FscFinanceOccupyRefundInfoAtomBankBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceBankStatementPO), FscFinanceOccupyRefundInfoAtomBankBO.class);
            bankList.add(fscFinanceOccupyRefundInfoAtomBankBO);
        }
    }

    private void releaseRefundInfo(Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        FscFinanceReleaseRefundInfoAtomReqBO fscFinanceReleaseRefundInfoAtomReqBO = new FscFinanceReleaseRefundInfoAtomReqBO();
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundId(thisRefundId);
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundNo(fscOrderRefundPO.getRefundNo());
        FscFinanceReleaseRefundInfoAtomRspBO fscFinanceReleaseRefundInfoAtomRspBO = this.fscFinanceReleaseRefundInfoAtomService.dealReleaseRefundInfo(fscFinanceReleaseRefundInfoAtomReqBO);
        if (!fscFinanceReleaseRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceReleaseRefundInfoAtomRspBO.getRespCode(), fscFinanceReleaseRefundInfoAtomRspBO.getRespDesc());
        }
    }
}

