/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscPayClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscPayClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayClaimConfirmBusiRspBO;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayClaimDetailPO;
import com.tydic.fsc.po.FscPayClaimPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayClaimConfirmBusiServiceImpl
implements FscPayClaimConfirmBusiService {
    @Autowired
    private FscPayClaimMapper fscPayClaimMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    @BigDecimalConvert(value=2)
    public FscPayClaimConfirmBusiRspBO dealPayClaimConfirm(FscPayClaimConfirmBusiReqBO reqBO) {
        Integer operationClaimType = 2;
        FscPayClaimPO payClaimPo = new FscPayClaimPO();
        payClaimPo.setClaimId(reqBO.getClaimId());
        FscPayClaimPO fscPayClaimPo = this.fscPayClaimMapper.getModelBy(payClaimPo);
        if (fscPayClaimPo == null) {
            throw new FscBusinessException("190000", "\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (fscPayClaimPo.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff0c\u8bf7\u52ff\u91cd\u590d\u8ba4\u9886\uff01");
        }
        BigDecimal claimAmt = BigDecimal.ZERO;
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            if (fscClaimDetailBO.getOperationType() == 1) {
                claimAmt = claimAmt.add(fscClaimDetailBO.getClaimAmt());
            } else if (fscClaimDetailBO.getOperationType() == 2) {
                claimAmt = claimAmt.subtract(fscClaimDetailBO.getCancelAmt());
            }
            if (claimAmt.compareTo(fscPayClaimPo.getNoClaimAmt()) <= 0) continue;
            throw new FscBusinessException("190000", "\u672c\u6b21\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u5355\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        if (fscPayClaimPo.getNoClaimAmt().subtract(claimAmt).compareTo(reqBO.getNoClaimAmt()) != 0) {
            throw new FscBusinessException("198888", "\u8ba4\u9886\u5931\u8d25\uff1a\u540e\u7aef\u8ba1\u7b97\u91d1\u989d\u4e0e\u524d\u7aef\u4e0d\u4e00\u81f4\uff01");
        }
        ArrayList<String> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)payClaimPo.getSettleNo()) && payClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(payClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)payClaimPo.getSettleNo())) {
            settleNoList.add(payClaimPo.getSettleNo());
        }
        if (!CollectionUtils.isEmpty(reqBO.getClaimDetailList()) && !StringUtils.isEmpty((Object)reqBO.getClaimDetailList().get(0).getFscOrderNo())) {
            operationClaimType = 1;
        }
        this.dealRecvConfirm(fscPayClaimPo, settleNoList, reqBO, operationClaimType);
        FscPayClaimConfirmBusiRspBO rspBO = new FscPayClaimConfirmBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRecvConfirm(FscPayClaimPO fscPayClaimPo, List<String> settleNoList, FscPayClaimConfirmBusiReqBO reqBO, Integer operationClaimType) {
        LinkedList<FscPayClaimDetailPO> addClaimDetailList = new LinkedList<FscPayClaimDetailPO>();
        LinkedList<FscPayClaimDetailPO> updateClaimDetailList = new LinkedList<FscPayClaimDetailPO>();
        LinkedList<FscOrderRelationPO> relationAddList = new LinkedList<FscOrderRelationPO>();
        LinkedList<FscOrderRelationPO> relationSubList = new LinkedList<FscOrderRelationPO>();
        LinkedList<FscOrderPO> orderPayAddList = new LinkedList<FscOrderPO>();
        LinkedList<FscOrderPO> orderPaySubList = new LinkedList<FscOrderPO>();
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscPayClaimPo.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            FscOrderRelationPO fscOrderRelationPo;
            FscPayClaimDetailPO fscClaimDetailPo = new FscPayClaimDetailPO();
            BeanUtils.copyProperties((Object)fscClaimDetailBO, (Object)fscClaimDetailPo);
            fscClaimDetailPo.setClaimId(reqBO.getClaimId());
            if (fscClaimDetailBO.getOperationType() == null || fscClaimDetailBO.getOperationType() == 1) {
                if (StringUtils.isEmpty((Object)fscClaimDetailPo.getClaimDetailId())) {
                    Object[] objectArray = new Object[1];
                    serialNumber = serialNumber + 1;
                    objectArray[0] = serialNumber;
                    String detailNo = fscPayClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
                    fscClaimDetailPo.setDetailNo(detailNo);
                    fscClaimDetailPo.setStatus(Integer.valueOf(1));
                    fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscClaimDetailPo.setSysSource(Integer.valueOf(1));
                    fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
                    BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)fscClaimDetailBO);
                    addClaimDetailList.add(fscClaimDetailPo);
                } else {
                    fscClaimDetailPo.setStatus(Integer.valueOf(1));
                    updateClaimDetailList.add(fscClaimDetailPo);
                }
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo())) {
                    settleNoList.add(fscClaimDetailBO.getFscOrderNo());
                }
                if (operationClaimType == 1) {
                    fscOrderRelationPo = new FscOrderRelationPO();
                    fscOrderRelationPo.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                    fscOrderRelationPo.setPurchaseClaimAmt(fscClaimDetailBO.getClaimAmt());
                    fscOrderRelationPo.setFscOrderId(fscClaimDetailBO.getFscOrderId());
                    relationAddList.add(fscOrderRelationPo);
                    continue;
                }
                FscOrderPO orderPO = new FscOrderPO();
                orderPO.setFscOrderId(fscClaimDetailBO.getObjectId());
                orderPO.setPurchaseClaimAmt(fscClaimDetailBO.getClaimAmt());
                orderPayAddList.add(orderPO);
                continue;
            }
            if (fscClaimDetailBO.getOperationType() != 2) continue;
            if (fscClaimDetailPo.getClaimId() == null) {
                fscClaimDetailPo.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo()) && settleNoList.size() > 0) {
                settleNoList.remove(fscClaimDetailBO.getFscOrderNo());
            }
            fscClaimDetailPo.setStatus(Integer.valueOf(0));
            fscClaimDetailPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
            fscClaimDetailPo.setCancelClaimDate(fscClaimDetailBO.getCancelClaimDate());
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            updateClaimDetailList.add(fscClaimDetailPo);
            if (operationClaimType == 1 && fscClaimDetailPo.getClaimDetailId() != null) {
                fscOrderRelationPo = new FscOrderRelationPO();
                fscOrderRelationPo.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                fscOrderRelationPo.setFscOrderId(fscClaimDetailPo.getFscOrderId());
                if (fscClaimDetailBO.getCancelAmt() == null) {
                    fscOrderRelationPo.setPurchaseClaimAmt(BigDecimal.ZERO);
                } else {
                    fscOrderRelationPo.setPurchaseClaimAmt(fscClaimDetailBO.getCancelAmt());
                }
                relationSubList.add(fscOrderRelationPo);
            } else if (fscClaimDetailPo.getClaimDetailId() != null) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscClaimDetailBO.getObjectId());
                if (fscClaimDetailBO.getCancelAmt() == null) {
                    fscOrderPO.setPurchaseClaimAmt(BigDecimal.ZERO);
                } else {
                    fscOrderPO.setPurchaseClaimAmt(fscClaimDetailBO.getCancelAmt());
                }
                orderPaySubList.add(fscOrderPO);
            }
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)fscClaimDetailBO);
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList)) {
            this.fscPayClaimDetailMapper.insertBatch(addClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscPayClaimDetailMapper.updateBatch(updateClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(relationAddList)) {
            this.fscOrderRelationMapper.updateClaimAmtAddBatch(relationAddList);
        }
        if (!CollectionUtils.isEmpty(relationSubList)) {
            this.fscOrderRelationMapper.updateClaimAmtSubBatch(relationSubList);
        }
        if (!CollectionUtils.isEmpty(orderPayAddList)) {
            this.fscOrderMapper.updateClaimAmountAdd(orderPayAddList);
        }
        if (!CollectionUtils.isEmpty(orderPaySubList)) {
            this.fscOrderMapper.updateClaimAmountSub(orderPaySubList);
        }
        FscPayClaimPO fscRecvClaim = new FscPayClaimPO();
        fscRecvClaim.setClaimId(reqBO.getClaimId());
        fscRecvClaim.setStatus(Integer.valueOf(0));
        fscRecvClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaim.setPayStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0 && reqBO.getNoClaimAmt().compareTo(fscPayClaimPo.getPayAmt()) != 0) {
            fscRecvClaim.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(fscPayClaimPo.getPayAmt()) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscRecvClaim.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscRecvClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscPayClaimMapper.updateByClaimId(fscRecvClaim);
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscPayClaimPo.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
    }
}

