/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyRecallFlowReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyRecallFlowRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifyRecallFlowService;
import com.tydic.fsc.common.busi.api.FscUnifyRecallFlowBusiService;
import com.tydic.fsc.common.busi.bo.FscUnifyRecallFlowBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscUnifyRecallFlowBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscUnifyRecallFlowBusiServiceImpl
implements FscUnifyRecallFlowBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUnifyRecallFlowBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUnifyRecallFlowService fscUnifyRecallFlowService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    static final String TYPE_ID_INVOICE = "8017";
    static final String TYPE_ID_IADVANCE_PAY = "8013";
    static final String TYPE_ID_SHOULD_PAY = "8018";
    static final String WF_TYPE = "CH";

    @Override
    @FscDuplicateCommitLimit
    public FscUnifyRecallFlowBusiRspBO dealRecallFlow(FscUnifyRecallFlowBusiReqBO reqBO) {
        FscUnifyRecallFlowBusiRspBO rspBO = new FscUnifyRecallFlowBusiRspBO();
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.TY_RECALL)) {
            throw new FscBusinessException("198888", "\u5df2\u64a4\u56de\u6210\u529f\uff01\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002");
        }
        FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
        fscOrderExtPO.setFscOrderId(orderPO.getFscOrderId());
        FscOrderExtPO orderExtPO = this.fscOrderExtMapper.getModelBy(fscOrderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6269\u5c55\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderExtPO fscOrderExtUpdatePO = new FscOrderExtPO();
        fscOrderExtUpdatePO.setUnifyPushStatus(FscConstants.pushState.NO_PUSH);
        this.fscOrderExtMapper.updateById(fscOrderExtUpdatePO);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(reqBO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        Integer shouldPayMethod = null;
        if (FscConstants.OrderFlow.PAY.equals(orderPO.getOrderFlow())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                shouldPayMethod = ((FscOrderPayItemPO)fscOrderPayItemList.get(0)).getShouldPayMethod();
                if (FscPayTypeEnum.WARRANTY.getCode().equals(shouldPayMethod)) {
                    shouldPayMethod = FscPayTypeEnum.SHOULD_PAY.getCode();
                }
            }
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("egbuzId", (Object)orderExtPO.getFscOrderId());
        jsonObject.put("egbuzNum", (Object)orderPO.getOrderNo());
        if (!StringUtils.isEmpty((Object)reqBO.getCause())) {
            jsonObject.put("cause", (Object)reqBO.getCause());
        } else {
            jsonObject.put("cause", (Object)"\u64a4\u56de\u539f\u56e0");
        }
        jsonObject.put("deptId", (Object)orderExtPO.getUnifyDeptId());
        jsonObject.put("instId", (Object)orderExtPO.getInstanceId());
        jsonObject.put("orgId", (Object)orderExtPO.getUnifyOrgId());
        if (FscConstants.OrderFlow.INVOICE.equals(orderPO.getOrderFlow())) {
            jsonObject.put("typeId", (Object)TYPE_ID_INVOICE);
        } else if (FscConstants.OrderFlow.PAY.equals(orderPO.getOrderFlow())) {
            if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(shouldPayMethod)) {
                jsonObject.put("typeId", (Object)TYPE_ID_IADVANCE_PAY);
            } else if (FscPayTypeEnum.SHOULD_PAY.getCode().equals(shouldPayMethod)) {
                jsonObject.put("typeId", (Object)TYPE_ID_SHOULD_PAY);
            }
        }
        jsonObject.put("wfType", (Object)WF_TYPE);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.debug("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u53c2\u6570\u52a0\u5bc6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)encryptionAbilityReqBO));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        FscUnifyRecallFlowReqBO fscUnifyRecallFlowReqBO = new FscUnifyRecallFlowReqBO();
        fscUnifyRecallFlowReqBO.setData(encryptionAbilityRspBO.getData());
        fscUnifyRecallFlowReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscUnifyRecallFlowRspBO fscUnifyRecallFlowRspBO = this.fscUnifyRecallFlowService.dealRecallFlow(fscUnifyRecallFlowReqBO);
        if (!fscUnifyRecallFlowRspBO.getRespCode().equals("0000")) {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.FAIL, FscConstants.FscPurchasePushType.ORDER_RECALL_FLOW);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyRecallFlowRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(fscUnifyRecallFlowRspBO.getMsg());
        } else {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.SUCCESS, FscConstants.FscPurchasePushType.ORDER_RECALL_FLOW);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyRecallFlowRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPurchasePushLogPo buildPushLog(FscOrderPO orderPO, Integer pushStatus, Integer pushType) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(orderPO.getFscOrderId());
        pushLogPo.setObjectNo(orderPO.getOrderNo());
        pushLogPo.setPushStatus(pushStatus);
        pushLogPo.setType(pushType);
        pushLogPo.setCreateTime(new Date());
        return pushLogPo;
    }
}

