/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundInvoiceReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundInvoiceRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinancePushRefundInvoiceService;
import com.tydic.fsc.common.busi.api.finance.FscFinancePushRefundInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePushRefundInvoiceBusiServiceImpl
implements FscFinancePushRefundInvoiceBusiService {
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscFinancePushRefundInvoiceService fscFinancePushRefundInvoiceService;

    @Override
    public FscFinancePushRefundInvoiceBusiRspBO dealPushRefundInvoice(FscFinancePushRefundInvoiceBusiReqBO reqBO) {
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(reqBO.getRefundId());
        refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        if (FscConstants.FscPushStatus.SUCCESS.equals(refundFinancePO.getPushFinanceStatus())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscFinancePushRefundInvoiceReqBO invoiceReqBO = new FscFinancePushRefundInvoiceReqBO();
        invoiceReqBO.setObject(reqBO.getObject());
        invoiceReqBO.setToken(reqBO.getToken());
        FscFinancePushRefundInvoiceRspBO invoiceRspBO = this.fscFinancePushRefundInvoiceService.dealPushRefundInvoice(invoiceReqBO);
        FscRefundFinancePO updatePo = new FscRefundFinancePO();
        updatePo.setRefundId(reqBO.getRefundId());
        FscFinancePushRefundInvoiceBusiRspBO busiRspBO = new FscFinancePushRefundInvoiceBusiRspBO();
        if ("0000".equals(invoiceRspBO.getRespCode())) {
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.SUCCESS);
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
        } else {
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
            updatePo.setPushFinanceRemark(invoiceRspBO.getRespDesc());
            if (updatePo.getPushFinanceRemark().length() > 500) {
                updatePo.setPushFinanceRemark(updatePo.getPushFinanceRemark().substring(0, 500));
            }
            busiRspBO.setRespCode("190000");
            busiRspBO.setRespDesc(invoiceRspBO.getRespDesc());
        }
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setType(FscConstants.FscPurchasePushType.SETTLE);
        abilityReqBO.setObjectId(reqBO.getRefundId());
        abilityReqBO.setObjectNo(reqBO.getRefundNo());
        abilityReqBO.setPushData(reqBO.getObject().toJSONString());
        abilityReqBO.setPushStatus(updatePo.getPushFinanceStatus());
        abilityReqBO.setRespData(invoiceRspBO.getRespStr());
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(abilityReqBO);
        return busiRspBO;
    }

    @Override
    public FscFinancePushRefundInvoiceBusiRspBO updatePushFail(FscFinancePushRefundInvoiceBusiReqBO reqBO) {
        if (!StringUtils.isEmpty((String)reqBO.getFailRemark()) && reqBO.getFailRemark().length() > 500) {
            reqBO.setFailRemark(reqBO.getFailRemark().substring(0, 500));
        }
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        financePO.setRefundId(reqBO.getRefundId());
        financePO.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
        financePO.setUpdateTime(new Date());
        financePO.setPushFinanceRemark(reqBO.getFailRemark());
        this.fscRefundFinanceMapper.updateById(financePO);
        FscFinancePushRefundInvoiceBusiRspBO rspBO = new FscFinancePushRefundInvoiceBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

