/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceTempDeleteReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceTempDeleteRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundInvoiceTempDeleteBusiService;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundInvoiceTempDeleteBusiServiceImpl
implements FscFinanceRefundInvoiceTempDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundInvoiceTempDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinanceRefundInvoiceTempDeleteRspBO dealFinanceRefundInvoiceTempDelete(FscFinanceRefundInvoiceTempDeleteReqBO reqBo) {
        this.valid(reqBo);
        this.fscOrderRelationTempMapper.deleteBatchByTempId(reqBo.getTempId(), reqBo.getContractId());
        this.fscInvoiceRefundRelationTempMapper.deleteBatchByTempId(reqBo.getTempId(), reqBo.getContractId());
        this.fscAttachmentTempMapper.deleteBatchByTempId(Collections.singletonList(reqBo.getTempId()), reqBo.getContractId());
        FscFinanceRefundInvoiceTempDeleteRspBO rspBO = new FscFinanceRefundInvoiceTempDeleteRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundInvoiceTempDeleteReqBO reqBO) {
        if (reqBO.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

