/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscAttachmentBO;
import com.tydic.fsc.common.ability.api.finance.FscFinanceQueryRefundReturnUniqueTempIdAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceQueryRefundReturnUniqueTempIdReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceQueryRefundReturnUniqueTempIdRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempBankStatementReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempDraftInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRefundItemReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRefundTempReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundTempBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealRefundToTempBusiBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealRefundToTempDataReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceSaveRefundTempBusiBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinanceRefundItemTempPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundTempBusiServiceImpl
implements FscFinanceRefundTempBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundTempBusiServiceImpl.class);
    @Resource
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Resource
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Resource
    private FscFinanceRefundItemTempMapper fscFinanceRefundItemTempMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Resource
    private FscFinanceQueryRefundReturnUniqueTempIdAbilityService tempIdAbilityService;

    @Override
    public FscFinanceSaveRefundReturnTempRspBO saveFinanceRefundTemp(FscFinanceSaveRefundTempBusiBO reqBo) {
        this.valid(reqBo);
        ArrayList itemTempPOList = Lists.newArrayList();
        ArrayList draftInfoTempPOList = Lists.newArrayList();
        ArrayList bankStatementTempPOList = Lists.newArrayList();
        ArrayList attachmentTempPOList = Lists.newArrayList();
        Date createTime = new Date();
        for (FscFinanceSaveRefundReturnTempRefundTempReqBO bo : reqBo.getRefundTemp()) {
            Object refundItemTempPO2;
            Long refundId = bo.getRefundId();
            Long tempId = bo.getTempId();
            Long contractId = bo.getContractId();
            List refundItemTempPOList = JSON.parseArray((String)JSON.toJSONString((Object)bo.getRefundItem()), FscFinanceRefundItemTempPO.class);
            for (Object refundItemTempPO2 : refundItemTempPOList) {
                refundItemTempPO2.setRefundItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                refundItemTempPO2.setRefundId(refundId);
                refundItemTempPO2.setTempId(tempId);
                refundItemTempPO2.setContractId(contractId);
                itemTempPOList.add(refundItemTempPO2);
            }
            List draftInfoBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getDraftInfo()), FscFinanceDraftInfoTempPO.class);
            refundItemTempPO2 = draftInfoBo.iterator();
            while (refundItemTempPO2.hasNext()) {
                FscFinanceDraftInfoTempPO draftInfoTempPO = (FscFinanceDraftInfoTempPO)refundItemTempPO2.next();
                draftInfoTempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
                draftInfoTempPO.setTempId(tempId);
                draftInfoTempPO.setContractId(contractId);
                draftInfoTempPO.setCreateTime(createTime);
                draftInfoTempPOList.add(draftInfoTempPO);
            }
            List bankStatementBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getBankStatement()), FscFinanceBankStatementTempPO.class);
            for (FscFinanceBankStatementTempPO bankStatementTempPO : bankStatementBo) {
                bankStatementTempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
                bankStatementTempPO.setTempId(tempId);
                bankStatementTempPO.setContractId(contractId);
                bankStatementTempPO.setCreateTime(createTime);
                bankStatementTempPOList.add(bankStatementTempPO);
            }
            List attachment = JSON.parseArray((String)JSON.toJSONString((Object)bo.getAttachments()), FscAttachmentTempPO.class);
            for (FscAttachmentTempPO attachmentTempPO : attachment) {
                attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentTempPO.setCreateTime(createTime);
                attachmentTempPO.setFscOrderId(tempId);
                attachmentTempPO.setObjId(contractId);
                attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPO.setObjType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPOList.add(attachmentTempPO);
            }
        }
        if (!itemTempPOList.isEmpty()) {
            this.fscFinanceRefundItemTempMapper.insertBatch((List)itemTempPOList);
        }
        if (!draftInfoTempPOList.isEmpty()) {
            this.fscFinanceDraftInfoTempMapper.insertBatch((List)draftInfoTempPOList);
        }
        if (!bankStatementTempPOList.isEmpty()) {
            this.fscFinanceBankStatementTempMapper.insertBatch((List)bankStatementTempPOList);
        }
        if (!attachmentTempPOList.isEmpty()) {
            this.fscAttachmentTempMapper.insertBatch((List)attachmentTempPOList);
        }
        FscFinanceSaveRefundReturnTempRspBO rspBO = new FscFinanceSaveRefundReturnTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceSaveRefundTempBusiBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscFinanceSaveRefundReturnTempRefundTempReqBO bo : reqBo.getRefundTemp()) {
            if (bo.getRefundId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getContractId() != null) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public FscFinanceSaveRefundReturnTempRspBO dealFinanceRefundToTemp(FscFinanceDealRefundToTempBusiBO reqBo) {
        ArrayList refundTemp = Lists.newArrayList();
        for (FscFinanceDealRefundToTempDataReqBO refundData : reqBo.getRefundData()) {
            FscFinanceSaveRefundReturnTempRefundTempReqBO bo = new FscFinanceSaveRefundReturnTempRefundTempReqBO();
            Long tempId = refundData.getTempId();
            Long contractId = refundData.getContractId();
            Long refundId = refundData.getRefundId();
            if (tempId == null) {
                FscFinanceQueryRefundReturnUniqueTempIdRspBO tempIdRspBO = this.tempIdAbilityService.qryRefundReturnUniqueTempID(new FscFinanceQueryRefundReturnUniqueTempIdReqBO());
                if ("0000".equals(tempIdRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u751f\u6210\u4e34\u65f6ID\u5931\u8d25");
                }
                tempId = tempIdRspBO.getTempId();
            }
            bo.setTempId(tempId);
            bo.setContractId(contractId);
            bo.setRefundId(refundId);
            List refundItem = JSON.parseArray((String)JSON.toJSONString(refundData.getRefundItem()), FscFinanceSaveRefundReturnTempRefundItemReqBO.class);
            List draftInfo = JSON.parseArray((String)JSON.toJSONString(refundData.getDraftInfo()), FscFinanceSaveRefundReturnTempDraftInfoReqBO.class);
            List bankStatement = JSON.parseArray((String)JSON.toJSONString(refundData.getBankStatement()), FscFinanceSaveRefundReturnTempBankStatementReqBO.class);
            List attachments = JSON.parseArray((String)JSON.toJSONString(refundData.getAttachments()), FscAttachmentBO.class);
            bo.setRefundItem(refundItem);
            bo.setDraftInfo(draftInfo);
            bo.setBankStatement(bankStatement);
            bo.setAttachments(attachments);
        }
        FscFinanceSaveRefundTempBusiBO saveBusiBo = new FscFinanceSaveRefundTempBusiBO();
        saveBusiBo.setRefundTemp(refundTemp);
        return this.saveFinanceRefundTemp(saveBusiBo);
    }
}

