/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.api.FscPushContractApproveAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultDetailBO;
import com.tydic.fsc.common.busi.api.finance.FscSyncFinanceDealPayResultBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRespBO;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayResultConfirmAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityRspBO;
import com.tydic.fsc.pay.atom.api.FscDealPayResultSuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomRspBO;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSyncFinanceDealPayResultBusiServiceImpl
implements FscSyncFinanceDealPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncFinanceDealPayResultBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscDealPayResultSuccessAtomService fscDealPayResultSuccessAtomService;
    @Autowired
    private FscPayResultConfirmAbilityService fscPayResultConfirmAbilityService;
    @Autowired
    private FscPushContractApproveAbilityService fscPushContractApproveAbilityService;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;

    @Override
    @FscDuplicateCommitLimit
    public FscSyncFinanceDealPayResultRspBO dealFinanceDealPayResult(FscSyncFinanceDealPayResultRespBO reqBO) {
        FscOrderPayItemPO orderPayItemPO;
        FscSyncFinanceDealPayResultRspBO rspBO = new FscSyncFinanceDealPayResultRspBO();
        log.debug("\u91d1\u878d\u4ea4\u6613\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        FscOrderPO queryFscOrderVo = new FscOrderPO();
        queryFscOrderVo.setOrderNo(reqBO.getPayOrderNo());
        queryFscOrderVo.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(queryFscOrderVo);
        FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
        log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
        if (Objects.isNull(fscOrderPO)) {
            FscAccountChargePO queryFscAccountChargeVo = new FscAccountChargePO();
            queryFscAccountChargeVo.setAdvanceDepositNo(reqBO.getPayOrderNo());
            queryFscAccountChargeVo.setChargeId(Long.valueOf(reqBO.getPayOrderId()));
            fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(queryFscAccountChargeVo);
            rspBO.setFscOrderId(fscAccountChargePO.getChargeId());
            log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            if (Objects.isNull(fscAccountChargePO.getChargeId())) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f\u6216\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f!");
            }
        } else {
            rspBO.setFscOrderId(fscOrderPO.getFscOrderId());
        }
        boolean isVoluntaryPayment = true;
        if (Objects.nonNull(fscOrderPO)) {
            FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
            orderFinancePO.setFscOrderId(rspBO.getFscOrderId());
            FscOrderFinancePO orderFinance = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
            if (Objects.nonNull(orderFinance.getPaymentType()) && Objects.equals(orderFinance.getPaymentType(), FscConstants.FinancePaymentType.PASSIVITY)) {
                isVoluntaryPayment = false;
            }
        }
        if (isVoluntaryPayment) {
            FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
            fscOrderFinancePO.setFscOrderId(rspBO.getFscOrderId());
            fscOrderFinancePO.setCurrency(reqBO.getDetailList().get(0).getCurrency());
            fscOrderFinancePO.setExchangeRate(reqBO.getDetailList().get(0).getExchangeRate());
            this.fscOrderFinanceMapper.updateExchangeRate(fscOrderFinancePO);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7684\u8d22\u52a1\u5171\u4eab\u6838\u9500\u8868\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderFinancePO));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayCertificate())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
            for (String attachmentUrl : reqBO.getPayCertificate()) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
                fscAttachmentPO.setAttachmentUrl(attachmentUrl);
                fscAttachmentPO.setCreateTime(new Date());
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u5b58\u5165\u652f\u4ed8\u51ed\u8bc1\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAttachmentPOList));
        }
        List fscOrderPayItemPOS = new ArrayList();
        List fscAccountChargeDetailPOS = new ArrayList();
        if (!Objects.isNull(fscOrderPO)) {
            FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
            payItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderPayItemPOS = this.fscOrderPayItemMapper.getList(payItemPO);
            log.debug("fscOrderPayItemPOS:{}", (Object)JSONObject.toJSONString(fscOrderPayItemPOS));
            if (CollectionUtils.isEmpty(fscOrderPayItemPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        if (!Objects.isNull(fscAccountChargePO.getChargeId())) {
            FscAccountChargeDetailPO accountChargeDetailPO = new FscAccountChargeDetailPO();
            accountChargeDetailPO.setChargeId(fscAccountChargePO.getChargeId());
            fscAccountChargeDetailPOS = this.fscAccountChargeDetailMapper.getListByChargeId(accountChargeDetailPO);
            log.debug("fscAccountChargeDetailPOS:{}", (Object)JSONObject.toJSONString(fscAccountChargeDetailPOS));
            if (CollectionUtils.isEmpty(fscAccountChargeDetailPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u9884\u4ed8\u6b3e\u5145\u503c\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        FscFinancePayItemPO financePayItemPO = new FscFinancePayItemPO();
        financePayItemPO.setFscOrderId(rspBO.getFscOrderId());
        List fscFinancePayItemPOS = this.fscFinancePayItemMapper.getList(financePayItemPO);
        log.debug("fscFinancePayItemPOS:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayItemPOS));
        if (CollectionUtils.isEmpty((Collection)fscFinancePayItemPOS) && isVoluntaryPayment) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u4fe1\u606f\u76f8\u5173\u4fe1\u606f!");
        }
        FscFinanceBankStatementPO bankStatementPO = new FscFinanceBankStatementPO();
        bankStatementPO.setFscOrderId(rspBO.getFscOrderId());
        List bankStatementPOS = this.fscFinanceBankStatementMapper.getList(bankStatementPO);
        log.debug("bankStatementPOS:{}", (Object)JSONObject.toJSONString((Object)bankStatementPOS));
        if (CollectionUtils.isEmpty((Collection)bankStatementPOS) && !isVoluntaryPayment) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d22\u52a1\u5171\u4eab\u94f6\u884c\u6d41\u6c34\u76f8\u5173\u4fe1\u606f!");
        }
        FscFinancePayReducePO financePayReducePO = new FscFinancePayReducePO();
        financePayReducePO.setFscOrderId(rspBO.getFscOrderId());
        List fscFinancePayReducePOS = this.fscFinancePayReduceMapper.getList(financePayReducePO);
        log.debug("fscFinancePayReducePOS:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayReducePOS));
        ArrayList<FscShouldPayPO> fscShouldPaySuccessfulPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscShouldPayPO> fscShouldPayfailPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscFinancePayItemPO> fscFinancePayItemPOList = new ArrayList<FscFinancePayItemPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOList = new ArrayList<FscOrderPayItemPO>();
        ArrayList<FscAccountChargeDetailPO> fscAccountChargeDetailPOList = new ArrayList<FscAccountChargeDetailPO>();
        ArrayList<String> payFailIdList = new ArrayList<String>();
        BigDecimal allShouldPayAmount = BigDecimal.ZERO;
        if (Objects.nonNull(fscOrderPO)) {
            allShouldPayAmount = fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO);
        } else if (Objects.nonNull(fscAccountChargePO.getChargeAmount())) {
            allShouldPayAmount = fscAccountChargePO.getChargeAmount().subtract(fscAccountChargePO.getPaidAmount() != null ? fscAccountChargePO.getPaidAmount() : BigDecimal.ZERO);
        }
        BigDecimal allPayAmount = BigDecimal.ZERO;
        Map<Object, Object> paidAmountMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)fscFinancePayItemPOS) && isVoluntaryPayment) {
            paidAmountMap = fscFinancePayItemPOS.stream().collect(Collectors.toMap(FscFinancePayItemPO::getOrderPayItemId, FscFinancePayItemPO::getPayAmount, BigDecimal::add));
        }
        if (!CollectionUtils.isEmpty((Collection)bankStatementPOS) && !isVoluntaryPayment) {
            paidAmountMap = bankStatementPOS.stream().collect(Collectors.toMap(FscFinanceBankStatementPO::getOrderPayItemId, FscFinanceBankStatementPO::getOccAmt, BigDecimal::add));
        }
        for (FscFinanceDealPayResultDetailBO detailBO : reqBO.getDetailList()) {
            FscFinancePayItemPO fscFinancePayItemPO = fscFinancePayItemPOS.stream().filter(item -> Objects.equals(item.getFinancePayItemId(), Long.valueOf(detailBO.getPayDetailId()))).findFirst().orElse(new FscFinancePayItemPO());
            log.debug("fscFinancePayItemPO:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayItemPO));
            FscFinanceBankStatementPO fscFinanceBankStatementPO = bankStatementPOS.stream().filter(item -> Objects.equals(item.getStatementId(), Long.valueOf(detailBO.getPayDetailId()))).findFirst().orElse(new FscFinanceBankStatementPO());
            log.debug("fscFinanceBankStatementPO:{}", (Object)JSONObject.toJSONString((Object)fscFinanceBankStatementPO));
            if (Objects.isNull(fscFinancePayItemPO.getOrderPayItemId()) && isVoluntaryPayment) {
                payFailIdList.add(detailBO.getPayDetailId());
                continue;
            }
            if (Objects.equals(detailBO.getPayStatus(), "0")) {
                FscOrderPayItemPO orderPayItemPO2;
                if (Objects.nonNull(fscFinancePayItemPO.getFinancePayItemId()) && isVoluntaryPayment) {
                    FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
                    fsFinancePayItemPO.setFinancePayItemId(Long.valueOf(detailBO.getPayDetailId()));
                    fsFinancePayItemPO.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
                    fsFinancePayItemPO.setPaidFailAmount(detailBO.getPayAmt());
                    fsFinancePayItemPO.setPaidFailAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAY_FAIL);
                    fscFinancePayItemPOList.add(fsFinancePayItemPO);
                }
                payFailIdList.add(detailBO.getPayDetailId());
                if (!Objects.nonNull(fscOrderPO) || !Objects.nonNull(orderPayItemPO2 = (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(fscOrderPayItemPO -> Objects.equals(fscOrderPayItemPO.getOrderPayItemId(), fscFinancePayItemPO.getOrderPayItemId())).findFirst().orElse(null))) continue;
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(orderPayItemPO2.getShouldPayId());
                fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
                fscShouldPayfailPOList.add(fscShouldPayPO);
                continue;
            }
            BigDecimal paidAmount = BigDecimal.ZERO;
            if (isVoluntaryPayment && Objects.nonNull(fscFinancePayItemPO.getOrderPayItemId())) {
                paidAmount = paidAmount.add(Objects.nonNull(paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId())) ? (BigDecimal)paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId()) : BigDecimal.ZERO);
            }
            if (!isVoluntaryPayment && Objects.nonNull(fscFinanceBankStatementPO.getOrderPayItemId())) {
                paidAmount = paidAmount.add(Objects.nonNull(paidAmountMap.get(fscFinanceBankStatementPO.getOrderPayItemId())) ? (BigDecimal)paidAmountMap.get(fscFinanceBankStatementPO.getOrderPayItemId()) : BigDecimal.ZERO);
            }
            log.debug("\u5e94\u4ed8\u6b3e\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)paidAmount));
            if (Objects.nonNull(fscOrderPO)) {
                if (paidAmount.compareTo(detailBO.getPayAmt()) >= 0) {
                    FscOrderPayItemPO fscOrderPayItemPO2 = new FscOrderPayItemPO();
                    if (isVoluntaryPayment) {
                        fscOrderPayItemPO2.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
                    } else {
                        fscOrderPayItemPO2.setOrderPayItemId(fscFinanceBankStatementPO.getOrderPayItemId());
                    }
                    fscOrderPayItemPO2.setPayAmount(detailBO.getPayAmt());
                    fscOrderPayItemPO2.setPayAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    paidAmountMap.put(fscFinancePayItemPO.getOrderPayItemId(), paidAmount.subtract(detailBO.getPayAmt()));
                    fscOrderPayItemPOList.add(fscOrderPayItemPO2);
                } else {
                    throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5df2\u4ed8\u6b3e\u91d1\u989d!");
                }
            }
            if (Objects.nonNull(fscAccountChargePO.getChargeId())) {
                if (paidAmount.compareTo(detailBO.getPayAmt()) >= 0) {
                    paidAmount = (BigDecimal)paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId());
                    FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
                    fscAccountChargeDetailPO.setId(fscFinancePayItemPO.getOrderPayItemId());
                    fscAccountChargeDetailPO.setPaidAmount(detailBO.getPayAmt());
                    fscAccountChargeDetailPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    paidAmountMap.put(fscFinancePayItemPO.getOrderPayItemId(), paidAmount.subtract(detailBO.getPayAmt()));
                    fscAccountChargeDetailPOList.add(fscAccountChargeDetailPO);
                } else {
                    throw new FscBusinessException("190000", "\u5145\u503c\u9884\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5df2\u4ed8\u6b3e\u91d1\u989d!");
                }
            }
            if (isVoluntaryPayment) {
                FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
                fsFinancePayItemPO.setFinancePayItemId(Long.valueOf(detailBO.getPayDetailId()));
                fsFinancePayItemPO.setPaidAmount(detailBO.getPayAmt());
                fsFinancePayItemPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                fscFinancePayItemPOList.add(fsFinancePayItemPO);
            }
            allPayAmount = allPayAmount.add(detailBO.getPayAmt());
            if (!Objects.nonNull(fscOrderPO)) continue;
            orderPayItemPO = isVoluntaryPayment ? (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), fscFinancePayItemPO.getOrderPayItemId())).findFirst().orElse(null) : (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), fscFinanceBankStatementPO.getOrderPayItemId())).findFirst().orElse(null);
            log.debug("orderPayItemPO\uff1a" + JSONObject.toJSONString((Object)orderPayItemPO));
            if (Objects.nonNull(orderPayItemPO)) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(orderPayItemPO.getShouldPayId());
                fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
                fscShouldPaySuccessfulPOList.add(fscShouldPayPO);
                log.debug("shouldPay\uff1a" + JSONObject.toJSONString((Object)fscShouldPayPO));
                continue;
            }
            throw new FscBusinessException("190000", "\u901a\u8fc7\u4ed8\u6b3e\u4fe1\u606f\u7684orderPayItemId\u65e0\u6cd5\u67e5\u8be2\u5230\u4ed8\u6b3e\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        if (Objects.nonNull(fscOrderPO)) {
            fscOrderPO.setPaidAmount(allPayAmount);
            fscOrderPO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
            if (allShouldPayAmount.compareTo(allPayAmount) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
            } else if (allPayAmount.compareTo(allShouldPayAmount) < 0 && allPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PART_PAY);
            } else if (allPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAY_FAIL);
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5931\u8d25!");
            }
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7ed3\u7b97\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            if ("1".equals(reqBO.getPaySource())) {
                if (allPayAmount.compareTo(fscOrderPO.getPayingAmount()) > 0) {
                    throw new FscBusinessException("190000", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u4e2d\u91d1\u989d!");
                }
            } else if (allPayAmount.compareTo(fscOrderPO.getToPayAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u672a\u4ed8\u91d1\u989d!");
            }
            fscOrderPO.setPayConfirmId(String.valueOf(reqBO.getOperAccount()));
            fscOrderPO.setPayConfirmName(reqBO.getOperName());
            fscOrderPO.setPayConfirmTime(new Date());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            int fscOrderResult = this.fscOrderMapper.updatePaidAmountAndToPayAmount(fscOrderPO);
            if (fscOrderResult <= 0) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u6570\u636e\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty(fscOrderPayItemPOList)) {
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscOrderPayItemPOList));
                Map<Long, FscOrderPayItemPO> mergedFscOrderPayItemMap = fscOrderPayItemPOList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getOrderPayItemId, po -> {
                    FscOrderPayItemPO newPo = new FscOrderPayItemPO();
                    newPo.setOrderPayItemId(po.getOrderPayItemId());
                    newPo.setPayAmount(po.getPayAmount());
                    newPo.setPayAmountLocal(po.getPayAmountLocal());
                    return newPo;
                }, (po1, po2) -> {
                    po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                    po1.setPayAmountLocal(po1.getPayAmountLocal().add(po2.getPayAmountLocal()));
                    return po1;
                }));
                ArrayList<FscOrderPayItemPO> mergedFscOrderPayItemPOList = new ArrayList<FscOrderPayItemPO>(mergedFscOrderPayItemMap.values());
                for (FscOrderPayItemPO payItemPO : mergedFscOrderPayItemPOList) {
                    orderPayItemPO = fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), payItemPO.getOrderPayItemId())).findFirst().orElse(null);
                    if (Objects.nonNull(orderPayItemPO) && orderPayItemPO.getPayAmount().compareTo(payItemPO.getPayAmount()) == 0) {
                        FscFinancePayReducePO fscFinancePayReducePO;
                        payItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                        if (!Objects.equals(payItemPO.getIsReduce(), 1) || CollectionUtils.isEmpty((Collection)fscFinancePayReducePOS) || !Objects.nonNull(fscFinancePayReducePO = (FscFinancePayReducePO)fscFinancePayReducePOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), payItemPO.getOrderPayItemId())).findFirst().orElse(null)) || CollectionUtils.isEmpty(fscShouldPaySuccessfulPOList)) continue;
                        fscShouldPaySuccessfulPOList.stream().forEach(item -> {
                            if (Objects.equals(item.getShouldPayId(), fscFinancePayReducePO.getShouldPayId())) {
                                item.setPayAmount(item.getPayAmount().add(fscFinancePayReducePO.getReduceAmt()));
                            }
                        });
                        continue;
                    }
                    if (!Objects.nonNull(orderPayItemPO) || orderPayItemPO.getPayAmount().compareTo(payItemPO.getPayAmount()) <= 0) continue;
                    payItemPO.setPayStatus(FscConstants.FscPayOrderState.PART_PAY);
                }
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscOrderPayItemPOList));
                int fscOrderPayItemResult = this.fscOrderPayItemMapper.updatePaidAmountAndPayStatusBatch(mergedFscOrderPayItemPOList);
                if (fscOrderPayItemResult <= 0 || fscOrderPayItemResult != mergedFscOrderPayItemPOList.size()) {
                    throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if (Objects.nonNull(fscAccountChargePO.getChargeId())) {
            fscAccountChargePO.setPaidAmount(allPayAmount);
            fscAccountChargePO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
            if (allShouldPayAmount.compareTo(allPayAmount) == 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_SUCCESS);
            } else if (allPayAmount.compareTo(allShouldPayAmount) < 0 && allPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_PART_SUCCESS);
            } else if (allPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_FAIL);
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5931\u8d25!");
            }
            if (allPayAmount.compareTo(fscAccountChargePO.getChargeAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5145\u503c\u91d1\u989d!");
            }
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u9884\u4ed8\u6b3e\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            int fscAccountChargeResult = this.fscAccountChargeMapper.updatePaidAmount(fscAccountChargePO);
            if (fscAccountChargeResult <= 0) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u9884\u4ed8\u6b3e\u4e3b\u5355\u6570\u636e\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty(fscAccountChargeDetailPOList)) {
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAccountChargeDetailPOList));
                Map<Long, FscAccountChargeDetailPO> mergedFscAccountChargeDetailMap = fscAccountChargeDetailPOList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getId, po -> {
                    FscAccountChargeDetailPO newPo = new FscAccountChargeDetailPO();
                    newPo.setId(po.getId());
                    newPo.setPaidAmount(po.getPaidAmount());
                    newPo.setPaidAmountLocal(po.getPaidAmountLocal());
                    return newPo;
                }, (po1, po2) -> {
                    po1.setPaidAmount(po1.getPaidAmount().add(po2.getPaidAmount()));
                    po1.setPaidAmountLocal(po1.getPaidAmountLocal().add(po2.getPaidAmountLocal()));
                    return po1;
                }));
                ArrayList<FscAccountChargeDetailPO> mergedFscAccountChargeDetailPOList = new ArrayList<FscAccountChargeDetailPO>(mergedFscAccountChargeDetailMap.values());
                for (FscAccountChargeDetailPO fscAccountChargeDetailPO : mergedFscAccountChargeDetailPOList) {
                    FscAccountChargeDetailPO chargeDetailPO = fscAccountChargeDetailPOS.stream().filter(item -> Objects.equals(item.getId(), fscAccountChargeDetailPO.getId())).findFirst().orElse(null);
                    if (Objects.nonNull(chargeDetailPO) && chargeDetailPO.getChargeAmount().compareTo(fscAccountChargeDetailPO.getPaidAmount()) == 0) {
                        fscAccountChargeDetailPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                        continue;
                    }
                    if (!Objects.nonNull(chargeDetailPO) || chargeDetailPO.getChargeAmount().compareTo(fscAccountChargeDetailPO.getPaidAmount()) <= 0) continue;
                    fscAccountChargeDetailPO.setPayStatus(FscConstants.FscPayOrderState.PART_PAY);
                }
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscAccountChargeDetailPOList));
                int fscAccountChargeDetailResult = this.fscAccountChargeDetailMapper.updatePaidAmountAndPayStatusBatch(mergedFscAccountChargeDetailPOList);
                if (fscAccountChargeDetailResult <= 0 || fscAccountChargeDetailResult != mergedFscAccountChargeDetailPOList.size()) {
                    throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscFinancePayItemPOList));
            int fscFinancePayItemResult = this.fscFinancePayItemMapper.updatePayAmountAndPayStatusBatch(fscFinancePayItemPOList);
            if (fscFinancePayItemResult <= 0 || fscFinancePayItemResult != fscFinancePayItemPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty(fscShouldPaySuccessfulPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPaySuccessfulPOList));
            Map<Long, FscShouldPayPO> mergedFscShouldPaySuccessfulPOMap = fscShouldPaySuccessfulPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, po -> {
                FscShouldPayPO newPo = new FscShouldPayPO();
                newPo.setShouldPayId(po.getShouldPayId());
                newPo.setPayAmount(po.getPayAmount());
                return newPo;
            }, (po1, po2) -> {
                po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                return po1;
            }));
            ArrayList<FscShouldPayPO> mergedFscShouldPaySuccessfulPOList = new ArrayList<FscShouldPayPO>(mergedFscShouldPaySuccessfulPOMap.values());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscShouldPaySuccessfulPOList));
            int fscShouldPaySuccessfulResult = this.fscShouldPayMapper.updateByPaySuccessAndStatus(mergedFscShouldPaySuccessfulPOList);
            if (fscShouldPaySuccessfulResult <= 0 || fscShouldPaySuccessfulResult != mergedFscShouldPaySuccessfulPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u6570\u636e\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty(fscShouldPayfailPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u5931\u8d25\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPayfailPOList));
            Map<Long, FscShouldPayPO> mergedFscShouldPayFailPOMap = fscShouldPayfailPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, po -> {
                FscShouldPayPO newPo = new FscShouldPayPO();
                newPo.setShouldPayId(po.getShouldPayId());
                newPo.setPayAmount(po.getPayAmount());
                return newPo;
            }, (po1, po2) -> {
                po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                return po1;
            }));
            ArrayList<FscShouldPayPO> mergedFscShouldPayFailPOList = new ArrayList<FscShouldPayPO>(mergedFscShouldPayFailPOMap.values());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscShouldPayFailPOList));
            int fscShouldPayFailResult = this.fscShouldPayMapper.updateByPayFailAndStatus(mergedFscShouldPayFailPOList);
            if (fscShouldPayFailResult <= 0 || fscShouldPayFailResult != mergedFscShouldPayFailPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u5931\u8d25\u4fe1\u606f\u6570\u636e\u5931\u8d25!");
            }
        }
        if (Objects.nonNull(fscOrderPO)) {
            if (fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2) {
                this.updateOrderStateSuccess(fscOrderPO);
            } else {
                this.updateOrderState(fscOrderPO, reqBO);
            }
        }
        log.info("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\uff0c\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3-------");
        CompletableFuture.runAsync(() -> {
            try {
                FscPushContractPayAbilityReqBO fscPushContractPayAbilityReqBO = new FscPushContractPayAbilityReqBO();
                fscPushContractPayAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                FscPushContractPayAbilityRspBO abilityRspBO = this.fscPushContractApproveAbilityService.dealPushContractPay(fscPushContractPayAbilityReqBO);
                if (Objects.nonNull(abilityRspBO) && "0000".equals(abilityRspBO.getRespCode())) {
                    log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + abilityRspBO.getRespDesc());
                }
            }
            catch (Exception exception) {
                log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + exception);
            }
        });
        rspBO.setPayFailIdList(payFailIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateOrderState(FscOrderPO fscOrderPO, FscSyncFinanceDealPayResultRespBO reqBO) {
        log.debug("\u66f4\u65b0\u540c\u6b65ES\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)JSONObject.toJSONString((Object)DateUtil.dateToStrLong((Date)new Date())));
        FscPayConfirmAbilityReqBO abilityReqBO = new FscPayConfirmAbilityReqBO();
        abilityReqBO.setFscOrderIds(Collections.singletonList(fscOrderPO.getFscOrderId()));
        abilityReqBO.setUserName(reqBO.getOperName());
        abilityReqBO.setUserId(Long.valueOf(reqBO.getOperAccount()));
        abilityReqBO.setYcPayFlag(Boolean.valueOf(true));
        abilityReqBO.setPayFlag(Boolean.valueOf(true));
        abilityReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
        abilityReqBO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
        FscPayConfirmAbilityRspBO fscPayConfirmAbilityRspBO = this.fscPayResultConfirmAbilityService.dealPayResultConfirm(abilityReqBO);
        if (!fscPayConfirmAbilityRspBO.getRespCode().equals("0000")) {
            log.error("\u8c03\u7528\u6d41\u7a0b\u5931\u8d25\uff01" + fscPayConfirmAbilityRspBO.getRespDesc());
            throw new FscBusinessException(fscPayConfirmAbilityRspBO.getRespCode(), fscPayConfirmAbilityRspBO.getRespDesc());
        }
    }

    private void updateOrderStateSuccess(FscOrderPO fscOrderPO) {
        FscDealPayResultSuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPayResultSuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(Arrays.asList(fscOrderPO.getFscOrderId()));
        fscDealPaySuccessAtomReqBO.setPayTime(new Date());
        FscDealPayResultSuccessAtomRspBO fscDealPayResultSuccessAtomRspBO = this.fscDealPayResultSuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!fscDealPayResultSuccessAtomRspBO.getRespCode().equals("0000")) {
            log.error("\u8c03\u7528\u6d41\u7a0b\u5931\u8d25\uff01" + fscDealPayResultSuccessAtomRspBO.getRespDesc());
            throw new FscBusinessException(fscDealPayResultSuccessAtomRspBO.getRespCode(), fscDealPayResultSuccessAtomRspBO.getRespDesc());
        }
    }
}

