/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscOrderInvoicePushToErpAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderInvoicePushToErpAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoicePushToErpAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscSyncPushErpInvoiceServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscSyncPushErpInvoiceServiceConsumer.class);
    @Autowired
    private FscOrderInvoicePushToErpAbilityService fscOrderInvoicePushToErpAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscOrderInvoicePushToErpAbilityReqBO reqBO = (FscOrderInvoicePushToErpAbilityReqBO)JSON.parseObject((String)message.getContent(), FscOrderInvoicePushToErpAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u5f02\u6b65\u63a8\u9001ERP\u53d1\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            List<Long> fscOrderIdList = Collections.singletonList(reqBO.getFscOrderId());
            reqBO.setFscOrderIds(fscOrderIdList);
            FscOrderInvoicePushToErpAbilityRspBO rspBO = this.fscOrderInvoicePushToErpAbilityService.pushInvoiceToErp(reqBO);
            if (!rspBO.getRespCode().equals("0000")) {
                this.writeFailLog(reqBO.getFscOrderId(), (FscRspBaseBO)rspBO);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u63a8\u9001\u4e1a\u8d22\u91c7\u8d2d\u7ed3\u7b97\u5355\u6d88\u8d39\u5931\u8d25\uff01" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void writeFailLog(Long fscOrderId, FscRspBaseBO rspBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_PUSH_ERP_INVOICE_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

