/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.base.FscReqBaseBO;
import com.tydic.fsc.bill.busi.api.FscCheckOneThreadBusiService;
import com.tydic.fsc.bill.busi.bo.FscAccountSerialReqBo;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.bo.FscFinancePayItemBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyChargeAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeBatchAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargeProWelfareBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargePurBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService"})
public class FscAccountChargeAbilityServiceImpl
implements FscAccountChargeAbilityService {
    @Autowired
    private FscAccountChargePurBusiService fscAccountChargePurBusiService;
    @Autowired
    private FscAccountChargeProBusiService fscAccountChargeProBusiService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPushUnifyChargeAbilityService fscPushUnifyChargeAbilityService;
    @Autowired
    private FscAccountChargeProWelfareBusiService fscAccountChargeProWelfareBusiService;
    @Autowired
    private FscCheckOneThreadBusiService fscCheckOneThreadBusiService;
    @Autowired
    private FscAccountChargeClaimAbilityService fscAccountChargeClaimAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    private static final Integer CHARGE_FLAGE = 444;
    private static final String BN = "JJ";

    /*
     * Enabled aggressive block sorting
     */
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountCharge"})
    public FscAccountChargeAbilityRspBO dealAccountCharge(@RequestBody FscAccountChargeAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAccountId()) && !CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(reqBO.getAccountId());
            this.checkInvoiceTitle(queryVo, reqBO.getUseAccountBOList());
        }
        FscAccountChargeBusiReqBO busiReqBO = new FscAccountChargeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBusiRspBO busiRspBO = null;
        if (reqBO.getWebSource() == null || reqBO.getWebSource() == 2) {
            busiRspBO = this.fscAccountChargePurBusiService.dealAccountCharge(busiReqBO);
        } else if ("1".equals(reqBO.getEmployeeChargeFlag())) {
            List collect = reqBO.getUseAccountBOList().stream().map(FscReqBaseBO::getOrgId).collect(Collectors.toList());
            FscAccountSerialReqBo fscAccountSerialReqBo = new FscAccountSerialReqBo();
            fscAccountSerialReqBo.setOrgIds(collect);
            fscAccountSerialReqBo.setSerialNumber(CHARGE_FLAGE);
            List list = this.fscCheckOneThreadBusiService.getList(fscAccountSerialReqBo);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                FscAccountChargeAbilityRspBO fscAccountChargeAbilityRspBO = new FscAccountChargeAbilityRspBO();
                fscAccountChargeAbilityRspBO.setRespCode("7777");
                fscAccountChargeAbilityRspBO.setRespDesc("\u5f53\u524d\u673a\u6784\u6b63\u5728\u5145\u503c\u8bf7\u7a0d\u540e");
                return fscAccountChargeAbilityRspBO;
            }
            ArrayList<FscAccountSerialReqBo> addBos = new ArrayList<FscAccountSerialReqBo>();
            for (Long orgId : collect) {
                FscAccountSerialReqBo fscAccountSerial = new FscAccountSerialReqBo();
                Long serialId = Sequence.getInstance().nextId();
                fscAccountSerial.setSerialId(serialId);
                fscAccountSerial.setOrgId(orgId);
                fscAccountSerial.setSerialNumber(CHARGE_FLAGE);
                addBos.add(fscAccountSerial);
            }
            this.fscCheckOneThreadBusiService.add(addBos);
            busiRspBO = this.fscAccountChargeProWelfareBusiService.dealAccountCharge(busiReqBO);
            List serialIds = addBos.stream().map(FscAccountSerialReqBo::getSerialId).collect(Collectors.toList());
            FscAccountSerialReqBo delete = new FscAccountSerialReqBo();
            delete.setSerialIds(serialIds);
            this.fscCheckOneThreadBusiService.delete(delete);
        } else {
            busiRspBO = this.fscAccountChargeProBusiService.dealAccountCharge(busiReqBO);
        }
        if (busiRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty(busiRspBO.getPushDetailBOList())) {
            this.dealPushYc(busiRspBO);
        }
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void dealPushYc(FscAccountChargeBusiRspBO busiRspBO) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(busiRspBO.getClaimId());
        abilityReqBO.setClaimList(busiRspBO.getPushDetailBOList());
        this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountChargeBatch"})
    public FscAccountChargeAbilityRspBO dealAccountChargeBatch(@RequestBody FscAccountChargeBatchAbilityReqBO reqBO) {
        this.paramVerify(reqBO);
        this.paramEmployeeSupermarketVerify(reqBO);
        boolean isDock = false;
        if (reqBO.getOperationType() == 1 && StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(reqBO.getChargeDeptId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode()) || umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
            throw new FscBusinessException("191000", "\u7528\u6237\u673a\u6784\u67e5\u8be2\u5931\u8d25");
        }
        if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() != null && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() == 1) {
            isDock = true;
        }
        if (isDock) {
            FscAccountChargePO fscAccountChargePO = this.fscAccountChargeMapper.queryOneCheck(reqBO.getChargeDeptId());
            if (null != fscAccountChargePO && fscAccountChargePO.getAuditStatus().equals(1)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u5145\u503c\u5355\u4f4d\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff0c\u4e14\u6709\u672a\u5ba1\u6279\u5b8c\u6210\u5145\u503c\u3002\u8bf7\u7b49\u5ba1\u6279\u8fc7\u540e\u518d\u8fdb\u884c\u5145\u503c");
            }
            if (StringUtils.isEmpty((Object)reqBO.getBusinessNature())) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u5145\u503c\u5355\u4f4d\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBO.getOperationType() == 1 && CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4f7f\u7528\u5355\u4f4d\u96c6\u5408[useAccountBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getChargeDeptId()) && !CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setOrgId(reqBO.getChargeDeptId());
            this.checkInvoiceTitle(queryVo, reqBO.getUseAccountBOList());
        }
        if ("1".equals(reqBO.getEmployeeChargeFlag())) {
            BigDecimal totalAmountCompany = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getCompanyChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmountUnion = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getUnionChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmount = totalAmountCompany.add(totalAmountUnion);
            if (reqBO.getOperationType() == 1 && reqBO.getChargeAmount().compareTo(totalAmount) != 0) {
                throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
            }
        } else {
            BigDecimal totalAmount = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reqBO.getOperationType() == 1 && reqBO.getChargeAmount().compareTo(totalAmount) != 0) {
                throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
            }
        }
        List uniqueAccountList = reqBO.getUseAccountBOList().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FscUseAccountBO>(Comparator.comparing(FscUseAccountBO::getUseDeptId))), ArrayList::new));
        if (reqBO.getOperationType() == 1 && uniqueAccountList.size() != reqBO.getUseAccountBOList().size()) {
            throw new FscBusinessException("198888", "\u5206\u914d\u8d26\u6237\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        FscAccountChargeBatchBusiReqBO busiReqBO = new FscAccountChargeBatchBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        if (isDock) {
            busiReqBO.setIsDock("1");
        } else {
            busiReqBO.setIsDock("0");
        }
        FscAccountChargeBatchBusiRspBO fscAccountChargeBatchBusiRspBO = this.fscAccountChargePurBusiService.dealAccountChargeBatch(busiReqBO);
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)fscAccountChargeBatchBusiRspBO), (Object)rspBO);
        if (isDock) {
            FscPushUnifyChargeAbilityReqBO fscPushUnifyChargeAbilityReqBO = new FscPushUnifyChargeAbilityReqBO();
            fscPushUnifyChargeAbilityReqBO.setChargeId(fscAccountChargeBatchBusiRspBO.getChargeId());
            fscPushUnifyChargeAbilityReqBO.setChargeDate(reqBO.getPayTime());
            fscPushUnifyChargeAbilityReqBO.setAgentAccount(reqBO.getAgentAccount());
            if ("1".equals(reqBO.getEmployeeChargeFlag())) {
                fscPushUnifyChargeAbilityReqBO.setOrderType("5");
            } else {
                fscPushUnifyChargeAbilityReqBO.setOrderType("0");
            }
            this.fscPushUnifyChargeAbilityService.dealPushUnifyCharge(fscPushUnifyChargeAbilityReqBO);
        }
        return rspBO;
    }

    private void checkInvoiceTitle(FscAccountPO queryVo, List<FscUseAccountBO> useAccountBOList) {
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        FscAccountPO queryUseVo = new FscAccountPO();
        List collect = useAccountBOList.stream().map(FscUseAccountBO::getUseDeptId).collect(Collectors.toList());
        queryUseVo.setOrgIds(collect);
        List list = this.fscAccountMapper.getList(queryUseVo);
        if (!CollectionUtils.isEmpty((Collection)list) && null != fscAccountPo && null != fscAccountPo.getInvoiceTitle()) {
            for (FscAccountPO po : list) {
                if (fscAccountPo.getInvoiceTitle().equals(po.getInvoiceTitle())) continue;
                throw new FscBusinessException("198888", "\u5145\u503c\u5355\u4f4d\u540d\u79f0\u4e0e\u4ed8\u6b3e\u65b9\u540d\u79f0\u4e0d\u7b26");
            }
        }
    }

    private void paramEmployeeSupermarketVerify(FscAccountChargeBatchAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOperationType()) || reqBO.getOperationType() != 1) {
            return;
        }
        if (reqBO.getBusiType() != 4) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFinanceOrgId())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                if (!ObjectUtil.isEmpty((Object)fscUseAccountBO.getCompanyChargeAmount()) || !ObjectUtil.isEmpty((Object)fscUseAccountBO.getUnionChargeAmount())) continue;
                throw new FscBusinessException("198888", "\u516c\u53f8\u5145\u503c\u91d1\u989d\u548c\u5de5\u4f1a\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                BigDecimal totalUseAccount = new BigDecimal("0");
                BigDecimal companyChargeAmount = ObjectUtil.isNotEmpty((Object)fscUseAccountBO.getCompanyChargeAmount()) ? fscUseAccountBO.getCompanyChargeAmount() : BigDecimal.ZERO;
                BigDecimal unionChargeAmount = ObjectUtil.isNotEmpty((Object)fscUseAccountBO.getUnionChargeAmount()) ? fscUseAccountBO.getUnionChargeAmount() : BigDecimal.ZERO;
                totalUseAccount = totalUseAccount.add(companyChargeAmount).add(unionChargeAmount);
                if (CollectionUtils.isEmpty((Collection)fscUseAccountBO.getFinanceItemList())) continue;
                BigDecimal totalPayAmount = new BigDecimal("0");
                for (FscFinancePayItemBO fscFinancePayItemBO : fscUseAccountBO.getFinanceItemList()) {
                    BigDecimal payAmount = ObjectUtil.isNotEmpty((Object)fscFinancePayItemBO.getPayAmount()) ? fscFinancePayItemBO.getPayAmount() : BigDecimal.ZERO;
                    totalPayAmount = totalPayAmount.add(payAmount);
                    if (CollectionUtils.isEmpty((Collection)fscFinancePayItemBO.getPlanList())) continue;
                    BigDecimal totalPlanAmount = new BigDecimal("0");
                    for (FscFinancePlanItemBO fscFinancePlanItemBO : fscFinancePayItemBO.getPlanList()) {
                        BigDecimal occAmount = ObjectUtil.isNotEmpty((Object)fscFinancePlanItemBO.getOccAmount()) ? fscFinancePlanItemBO.getOccAmount() : BigDecimal.ZERO;
                        totalPlanAmount = totalPlanAmount.add(occAmount);
                    }
                    if (payAmount.compareTo(totalPlanAmount) == 0) continue;
                    throw new FscBusinessException("198888", fscFinancePayItemBO.getPayItemNo() + "\uff0c\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0e\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u603b\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
                if (totalUseAccount.compareTo(totalPayAmount) == 0) continue;
                throw new FscBusinessException("198888", fscUseAccountBO.getItemNo() + "\uff0c\u4f7f\u7528\u5355\u4f4d\u5145\u503c\u91d1\u989d\u4e0e\u7533\u8bf7\u4ed8\u6b3e\u603b\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
    }

    private void paramVerify(FscAccountChargeBatchAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOperationType()) || reqBO.getOperationType() != 1) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFinanceOrgId())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                if (CollectionUtils.isEmpty((Collection)fscUseAccountBO.getFinanceItemList())) continue;
                for (FscFinancePayItemBO fscFinancePayItemBO : fscUseAccountBO.getFinanceItemList()) {
                    BigDecimal totalOccAmt;
                    if (CollectionUtils.isEmpty((Collection)fscFinancePayItemBO.getDraftList())) continue;
                    for (FscFinanceDraftInfoBO fscFinanceDraftInfoBO : fscFinancePayItemBO.getDraftList()) {
                        if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoBO.getOccAmt())) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoBO.getOccAmtLocal())) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (fscFinanceDraftInfoBO.getOccAmt().compareTo(BigDecimal.ZERO) == 0) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                        }
                        if (fscFinanceDraftInfoBO.getOccAmtLocal().compareTo(BigDecimal.ZERO) != 0) continue;
                        throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a0");
                    }
                    BigDecimal payAmount = ObjectUtil.isNotEmpty((Object)fscFinancePayItemBO.getPayAmount()) ? fscFinancePayItemBO.getPayAmount() : BigDecimal.ZERO;
                    if (payAmount.compareTo(totalOccAmt = fscFinancePayItemBO.getDraftList().stream().map(FscFinanceDraftInfoBO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) == 0) continue;
                    throw new FscBusinessException("198888", fscFinancePayItemBO.getPayItemNo() + "\uff0c\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0e\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0d\u4e00\u81f4");
                }
            }
        }
    }
}

