/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.BillInfoYCBo;
import com.tydic.fsc.busibase.external.api.bo.BillPayTermInfoYCBo;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushNewYcPayBillAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayBillBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayCapitalBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayContractBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayLineBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPaySettleBO;
import com.tydic.fsc.common.busi.api.FscPushNewYcAlreadyExistsBusiService;
import com.tydic.fsc.common.busi.api.FscPushNewYcFailBusiService;
import com.tydic.fsc.common.busi.api.FscPushNewYcPayBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushNewYcFailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscDraftInfoPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocContractInfoQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryReqBO;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdProContractHeadBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushNewYcPayBillAbilityService"})
public class FscPushNewYcPayBillAbilityServiceImpl
implements FscPushNewYcPayBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPayBillAbilityServiceImpl.class);
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscPushNewYcPayBillBusiService fscPushNewYcPayBillBusiService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPushNewYcFailBusiService fscPushNewYcFailBusiService;
    @Autowired
    private FscPushNewYcAlreadyExistsBusiService fscPushNewYcAlreadyExistsBusiService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private UocContractInfoQryAbilityService uocContractInfoQryAbilityService;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${settle.stage:TWO}")
    private String settleStage;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcPayBill"})
    public FscPushNewYcPayBillAbilityRspBO dealPushNewYcPayBill(@RequestBody FscPushNewYcPayBillAbilityReqBO reqBO) {
        FscPushNewYcPayBillBusiRspBO pushRspBO;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4ed8\u6b3e\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        List shouldPayPoList = this.fscShouldPayMapper.getByFscOrderId(orderPO.getFscOrderId());
        FscPushNewYcPayBillAbilityRspBO rspBO = new FscPushNewYcPayBillAbilityRspBO();
        FscPushYcAttachmentAbilityReqBO attachmentReqBO = new FscPushYcAttachmentAbilityReqBO();
        attachmentReqBO.setObjId(reqBO.getFscOrderId());
        attachmentReqBO.setObjNo(orderPO.getOrderNo());
        List<Long> contractIdList = shouldPayPoList.stream().map(FscShouldPayPO::getProContractId).distinct().collect(Collectors.toList());
        if (contractIdList.size() != 1) {
            throw new FscBusinessException("198888", "\u5408\u5e76\u4ed8\u6b3e\u7684\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\uff01");
        }
        UocOrdProContractHeadBO contractHeadBO = this.qryOrderContractInfo(contractIdList);
        if (((FscShouldPayPO)shouldPayPoList.get(0)).getShouldPayMethod().equals(FscConstants.PaymentMethod.PRE_PAY)) {
            FscPushNewYcPayBillBusiReqBO pushReqBO;
            try {
                pushReqBO = this.buildPrePayBillInfo(orderPO, shouldPayPoList, contractHeadBO);
                attachmentReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.PRE_PAY);
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + e);
                e.printStackTrace();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)e.getMessage()) && "\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01".equals(e.getMessage())) {
                    this.dealAlreadyExists(orderPO.getFscOrderId(), e.getMessage());
                } else {
                    this.dealFail(orderPO.getFscOrderId(), e.getMessage());
                }
                this.sendMq(reqBO.getFscOrderId());
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            pushRspBO = this.fscPushNewYcPayBillBusiService.dealPushPayBill(pushReqBO);
        } else {
            FscPushNewYcPayBillBusiReqBO pushReqBO;
            try {
                pushReqBO = this.buildPayBillInfo(orderPO, contractHeadBO);
                attachmentReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.SHOULD_PAY);
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + e);
                e.printStackTrace();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)e.getMessage()) && "\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01".equals(e.getMessage())) {
                    this.dealAlreadyExists(orderPO.getFscOrderId(), e.getMessage());
                } else {
                    this.dealFail(orderPO.getFscOrderId(), e.getMessage());
                }
                this.sendMq(reqBO.getFscOrderId());
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            pushRspBO = this.fscPushNewYcPayBillBusiService.dealPushPayBill(pushReqBO);
        }
        this.sendMq(reqBO.getFscOrderId());
        attachmentReqBO.setAgentName(orderExtPO.getUnifyUserName());
        attachmentReqBO.setAgentAccount(orderExtPO.getAgentAccount());
        this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(attachmentReqBO);
        return (FscPushNewYcPayBillAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)pushRspBO)), FscPushNewYcPayBillAbilityRspBO.class);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcPayBatch"})
    public FscPushNewYcPayBillAbilityRspBO dealPushNewYcPayBatch(@RequestBody FscPushNewYcPayBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355id\u96c6\u5408[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscPushNewYcPayBillAbilityReqBO billAbilityReqBO = new FscPushNewYcPayBillAbilityReqBO();
            billAbilityReqBO.setFscOrderId(fscOrderId);
            FscPushNewYcPayBillAbilityRspBO rspBO = this.dealPushNewYcPayBill(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u7ed3\u7b97\u5355[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushNewYcPayBillAbilityRspBO rspBO = new FscPushNewYcPayBillAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb) && sb.length() > 0) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPushNewYcPayBillBusiReqBO buildPayBillInfo(FscOrderPO orderPO, UocOrdProContractHeadBO contractHeadBO) {
        FscPushNewYcPayBillBusiReqBO pushReqBO = new FscPushNewYcPayBillBusiReqBO();
        FscUnifyPayBillBO payBillBO = this.buildPayInfo(orderPO, false);
        LinkedList<FscUnifyPaySettleBO> settleList = new LinkedList<FscUnifyPaySettleBO>();
        this.buildSettleInfo(orderPO, payBillBO, settleList, contractHeadBO);
        List<FscUnifyPayCapitalBO> capitalList = this.buildCapitalInfo(orderPO, false, contractHeadBO);
        if (!CollectionUtils.isEmpty(capitalList)) {
            BigDecimal capitalAmount = capitalList.stream().map(FscUnifyPayCapitalBO::getEXE_AMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = settleList.stream().map(FscUnifyPaySettleBO::getAMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payAmount.compareTo(capitalAmount) != 0) {
                throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u548c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6b63\u540e\u63d0\u4ea4\uff01");
            }
        }
        List<FscUnifyPayLineBO> payLineList = this.buildPayLine(orderPO);
        List<BillInfoYCBo> billList = this.buildBillInfo(orderPO, false);
        pushReqBO.setFscOrderId(orderPO.getFscOrderId());
        pushReqBO.setIsPrePay(false);
        pushReqBO.setToken(payBillBO.getToken());
        payBillBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillBO);
        jsonObject.put("conLine", settleList);
        jsonObject.put("celine", capitalList);
        jsonObject.put("payLine", payLineList);
        jsonObject.put("billInfo", billList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private FscPushNewYcPayBillBusiReqBO buildPrePayBillInfo(FscOrderPO orderPO, List<FscShouldPayPO> shouldPayPoList, UocOrdProContractHeadBO contractHeadBO) {
        FscPushNewYcPayBillBusiReqBO pushReqBO = new FscPushNewYcPayBillBusiReqBO();
        FscUnifyPayBillBO payBillBO = this.buildPayInfo(orderPO, true);
        List<FscUnifyPayContractBO> contractList = this.buildContractInfo(contractHeadBO, shouldPayPoList, orderPO, payBillBO);
        List<FscUnifyPayCapitalBO> capitalList = this.buildCapitalInfo(orderPO, true, contractHeadBO);
        if (!CollectionUtils.isEmpty(capitalList)) {
            BigDecimal capitalAmount = capitalList.stream().map(FscUnifyPayCapitalBO::getEXE_AMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = contractList.stream().map(FscUnifyPayContractBO::getAMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payAmount.compareTo(capitalAmount) != 0) {
                throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u548c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6b63\u540e\u63d0\u4ea4\uff01");
            }
        }
        List<BillInfoYCBo> billList = this.buildBillInfo(orderPO, true);
        List<BillPayTermInfoYCBo> payTermList = this.buildPayTermInfo(shouldPayPoList, payBillBO);
        pushReqBO.setFscOrderId(orderPO.getFscOrderId());
        pushReqBO.setIsPrePay(true);
        pushReqBO.setToken(payBillBO.getToken());
        payBillBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillBO);
        jsonObject.put("conLine", contractList);
        jsonObject.put("celine", capitalList);
        jsonObject.put("billInfo", billList);
        jsonObject.put("payTermList", payTermList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.info("--------\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u4fe1\u606f\u660e\u6587\u6253\u5370\uff1a" + JSON.toJSON((Object)jsonArray.toJSONString()));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private UocOrdProContractHeadBO qryOrderContractInfo(List<Long> orderIdList) {
        UocContractInfoQryReqBO uocContractInfoQryReqBO = new UocContractInfoQryReqBO();
        uocContractInfoQryReqBO.setContractIds(orderIdList);
        UocContractInfoQryRspBO uocContractInfoQryRspBO = this.uocContractInfoQryAbilityService.qryContractInfo(uocContractInfoQryReqBO);
        if (!uocContractInfoQryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(uocContractInfoQryRspBO.getRespCode(), uocContractInfoQryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocContractInfoQryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return (UocOrdProContractHeadBO)uocContractInfoQryRspBO.getRows().get(0);
    }

    private void buildFileInfo(List<FscUnifyAttachmentBO> attachmentBOList, FscOrderPO orderPO, FscUnifyPayBillBO payBillBO, Boolean isPrePay) {
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(orderPO.getFscOrderId());
        List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
        for (FscAttachmentPO fscAttachmentPO : attachmentPOS) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
            uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setUUID("zjht");
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setUSER_NAME(payBillBO.getPERSON_NAME());
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBOList.add(attachmentBO);
            if (isPrePay.booleanValue()) {
                attachmentBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
                attachmentBO.setDOC_TYPE("8013");
                continue;
            }
            attachmentBO.setEG_BILL_NUM(orderPO.getOrderNo());
            attachmentBO.setDOC_TYPE("8018");
        }
        payBillBO.setDOC_COUNT(Integer.valueOf(attachmentBOList.size()));
    }

    private void buildSettleInfo(FscOrderPO orderPO, FscUnifyPayBillBO payBillBO, List<FscUnifyPaySettleBO> settleBOList, UocOrdProContractHeadBO uocOrdContractBO) {
        List settlePOlist;
        ArrayList shouldPayPoList = this.fscShouldPayMapper.getByFscOrderId(orderPO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)shouldPayPoList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        List settleIdYesList = shouldPayPoList.stream().filter(e -> Objects.nonNull(e.getFscBillOrderNo())).map(FscShouldPayPO::getFscBillOrderId).map(Long::parseLong).collect(Collectors.toList());
        List settleIdNoList = shouldPayPoList.stream().filter(e -> Objects.isNull(e.getFscBillOrderNo())).map(FscShouldPayPO::getObjectId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settleIdYesList) && CollectionUtils.isEmpty(settleIdNoList)) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5bf9\u5e94\u7684\u7ed3\u7b97\u4e3a\u7a7a\uff01");
        }
        ArrayList settleIdList = !CollectionUtils.isEmpty(settleIdNoList) ? new ArrayList(settleIdNoList) : new ArrayList(settleIdYesList);
        if (!CollectionUtils.isEmpty(settleIdNoList) ? CollectionUtils.isEmpty((Collection)(settlePOlist = this.fscOrderMapper.getSettleAndShouldPay(settleIdList))) : CollectionUtils.isEmpty((Collection)(settlePOlist = this.fscOrderMapper.getOrderSettleAndShouldPay(settleIdList)))) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5bf9\u5e94\u7684\u7ed3\u7b97\u4e3a\u7a7a\uff01");
        }
        Map<Long, FscOrderPO> collects = !CollectionUtils.isEmpty(settleIdNoList) ? settlePOlist.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, e -> e, (k1, k2) -> k1)) : settlePOlist.stream().collect(Collectors.toMap(FscOrderPO::getShouldPayId, e -> e, (k1, k2) -> k1));
        ArrayList fscShouldPayPOList = shouldPayPoList;
        HashMap<Long, FscShouldPayPO> newShouldPayPoList = new HashMap<Long, FscShouldPayPO>();
        if (!CollectionUtils.isEmpty(settleIdNoList)) {
            for (FscShouldPayPO fscShouldPayPO : shouldPayPoList) {
                FscShouldPayPO fscShouldPayPO1 = (FscShouldPayPO)newShouldPayPoList.get(fscShouldPayPO.getObjectId());
                if (fscShouldPayPO1 != null) {
                    fscShouldPayPO1.setPayAmount(fscShouldPayPO.getPayAmount().add(fscShouldPayPO1.getPayAmount()));
                    newShouldPayPoList.put(fscShouldPayPO1.getObjectId(), fscShouldPayPO1);
                    continue;
                }
                newShouldPayPoList.put(fscShouldPayPO.getObjectId(), fscShouldPayPO);
            }
            fscShouldPayPOList = new ArrayList(newShouldPayPoList.values());
        }
        for (FscShouldPayPO fscShouldPayPO : fscShouldPayPOList) {
            if (uocOrdContractBO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            FscOrderPO fscOrderPO = !CollectionUtils.isEmpty(settleIdNoList) ? collects.get(fscShouldPayPO.getObjectId()) : collects.get(fscShouldPayPO.getShouldPayId());
            if (fscOrderPO == null) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5bf9\u5e94\u7684\u7ed3\u7b97\u4e3a\u7a7a\uff01");
            }
            FscUnifyPaySettleBO settleBO = new FscUnifyPaySettleBO();
            settleBO.setBALANCE_AMT(fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP));
            settleBO.setBAL_REAMOUNT(fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount()).setScale(2, RoundingMode.HALF_UP));
            settleBO.setAMOUNT(fscShouldPayPO.getPayAmount().setScale(2, RoundingMode.HALF_UP));
            settleBO.setORG_NAME(payBillBO.getORG_NAME());
            settleBO.setORG_ID(payBillBO.getORG_ID());
            settleBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
            settleBO.setEG_BALANCE_NUM(fscOrderPO.getOrderNo());
            settleBO.setCONTRACT_NUM(uocOrdContractBO.getEgContractNum());
            settleBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
            settleBO.setCONTRACT_AMOUNT(uocOrdContractBO.getContractAmount().setScale(2, RoundingMode.HALF_UP));
            settleBOList.add(settleBO);
        }
    }

    private List<FscUnifyPayContractBO> buildContractInfo(UocOrdProContractHeadBO uocOrdContractBO, List<FscShouldPayPO> shouldPayPoList, FscOrderPO orderPO, FscUnifyPayBillBO payBillBO) {
        ArrayList<FscUnifyPayContractBO> contractBOList = new ArrayList<FscUnifyPayContractBO>(shouldPayPoList.size());
        for (FscShouldPayPO shouldPayPO : shouldPayPoList) {
            FscUnifyPayContractBO contractBO = new FscUnifyPayContractBO();
            contractBO.setCONTRACT_NUM(uocOrdContractBO.getEgContractNum());
            contractBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
            contractBO.setCONTRACT_AMT(uocOrdContractBO.getContractAmount().setScale(2, RoundingMode.HALF_UP));
            contractBO.setAMOUNT(shouldPayPO.getPayAmount().setScale(2, RoundingMode.HALF_UP));
            contractBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
            contractBO.setEG_ID(shouldPayPO.getProContractId().toString());
            contractBOList.add(contractBO);
        }
        return contractBOList;
    }

    private List<FscUnifyPayLineBO> buildPayLine(FscOrderPO orderPO) {
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<FscUnifyPayLineBO> fscUnifyPayLineBOList = new ArrayList<FscUnifyPayLineBO>();
        FscUnifyPayLineBO fscUnifyPayLineBO = new FscUnifyPayLineBO();
        if (FscConstants.FscPaymentMethod.BANK_PAY.equals(orderPO.getPaymentMethod())) {
            fscUnifyPayLineBO.setPAY_MODE("\u76f4\u63a5\u4ed8\u6b3e");
        } else if (FscConstants.FscPaymentMethod.INVOICE_PAY.equals(orderPO.getPaymentMethod())) {
            fscUnifyPayLineBO.setPAY_MODE("\u5e94\u4ed8\u7968\u636e");
        }
        fscUnifyPayLineBO.setORG_NAME(orderExtPO.getUnifyOrgName());
        fscUnifyPayLineBO.setORG_ID(orderExtPO.getUnifyOrgId());
        fscUnifyPayLineBO.setEG_PAYMENT_ID(orderPO.getFscOrderId());
        fscUnifyPayLineBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
        fscUnifyPayLineBO.setUSER_ID(orderExtPO.getExt1());
        fscUnifyPayLineBO.setAMOUNT(orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP));
        fscUnifyPayLineBOList.add(fscUnifyPayLineBO);
        return fscUnifyPayLineBOList;
    }

    private FscUnifyPayBillBO buildPayInfo(FscOrderPO orderPO, Boolean isPrePay) {
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (orderExtPO.getUnifyPushStatus() != null && orderExtPO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (StringUtils.isEmpty((Object)orderExtPO.getAgentAccount())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0agentAccount\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        FscUnifyPayBillBO payBillBO = new FscUnifyPayBillBO();
        payBillBO.setToken(tokenQryAbilityRspBO.getData());
        payBillBO.setEG_PAY_TERMS_ID("");
        payBillBO.setCOM_CODE(orderExtPO.getUnifyComCode());
        if (isPrePay.booleanValue()) {
            payBillBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
            payBillBO.setEG_PREPAY_ID(orderPO.getFscOrderId());
        } else {
            payBillBO.setEG_PAYMENT_ID(orderPO.getFscOrderId());
            payBillBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
        }
        payBillBO.setBILL_DATE(DateUtil.dateToStr((Date)orderPO.getCreateTime()));
        payBillBO.setPERSON_ID(orderExtPO.getUnifyUserId());
        payBillBO.setPERSON_NAME(orderExtPO.getUnifyUserName());
        payBillBO.setDEPT_ID(orderExtPO.getUnifyDeptId());
        payBillBO.setDEPT_NAME(orderExtPO.getUnifyDeptName());
        payBillBO.setVENDOR_NAME(orderExtPO.getSupplierErpName());
        payBillBO.setVENDOR_NUM(orderExtPO.getSupplierErpCode());
        if (orderExtPO.getPayDate() != null) {
            payBillBO.setPAY_DATE(DateUtil.dateToStr((Date)orderExtPO.getPayDate()));
        }
        payBillBO.setAMOUNT(orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP));
        payBillBO.setDESCRIPTIONS(orderPO.getRemark());
        payBillBO.setSTATUS("Y");
        payBillBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        payBillBO.setORG_ID(orderExtPO.getUnifyOrgId());
        payBillBO.setORG_NAME(orderExtPO.getUnifyOrgName());
        payBillBO.setBANK_NAME(orderPO.getPayeeBankName());
        payBillBO.setBANK_NUM(orderPO.getPayeeBankAccount());
        payBillBO.setUSER_ID(orderExtPO.getExt1());
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        dicDictionaryExernalPO.setCode(String.valueOf(orderPO.getOrderSource()));
        dicDictionaryExernalPO.setPCode("BUZ_PROPERTY");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        if (CollectionUtils.isEmpty((Collection)fscDicDictionaryExernalPOList)) {
            throw new FscBusinessException("198888", "\u4e1a\u8d22\u4e1a\u52a1\u6027\u8d28\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        payBillBO.setBUZ_PROPERTY_DIS(((FscDicDictionaryExernalPO)fscDicDictionaryExernalPOList.get(0)).getExernalTitle());
        payBillBO.setPAY_TERMS("");
        payBillBO.setPAY_TERMS_ID("");
        payBillBO.setSTAGE(this.settleStage);
        return payBillBO;
    }

    private List<FscUnifyPayCapitalBO> buildCapitalInfo(FscOrderPO orderPO, Boolean isPrePay, UocOrdProContractHeadBO contractHeadBO) {
        ArrayList<FscUnifyPayCapitalBO> capitalBOList = new ArrayList<FscUnifyPayCapitalBO>();
        List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(orderPO.getFscOrderId());
        for (FscOperateCapitalPlanPO po : list) {
            FscUnifyPayCapitalBO capitalBO = new FscUnifyPayCapitalBO();
            capitalBO.setEG_CE_LINE_ID(po.getId());
            capitalBO.setPERIOD_M(po.getPeriod());
            capitalBO.setCE_ITEM_ID(Long.valueOf(po.getItemId()));
            capitalBO.setCE_ITEM_NAME(po.getItemName());
            capitalBO.setCONTROL_MODE(po.getControlMode());
            if (po.getPlanAmount() != null) {
                capitalBO.setAMOUNT(po.getPlanAmount().setScale(2, RoundingMode.HALF_UP));
            }
            capitalBO.setRE_AMOUNT(po.getAmount().setScale(2, RoundingMode.HALF_UP));
            capitalBO.setORG_NAME(orderPO.getOrgName());
            capitalBO.setORG_ID(Long.valueOf(po.getOrgId()));
            capitalBO.setCONTRACT_ID(contractHeadBO.getEgContractId());
            capitalBO.setCONTRACT_NUM(contractHeadBO.getEgContractNum());
            capitalBO.setEXE_AMOUNT(po.getUseAmount().setScale(2, RoundingMode.HALF_UP));
            if (isPrePay.booleanValue()) {
                capitalBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
            } else {
                capitalBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
            }
            capitalBO.setEG_CONTRACT_NUM(po.getContractNum());
            capitalBO.setBILL_ID(po.getBillId());
            capitalBO.setBILL_TYPE(po.getBillType());
            capitalBO.setBILL_NUM(po.getBillNum());
            capitalBO.setOUT_ITEM_NUM(po.getOutItemNum());
            capitalBO.setOUT_ITEM_NAME(po.getOutItemName());
            capitalBO.setDEPT_ID(po.getDeptId());
            capitalBO.setDEPT_NAME(po.getDeptName());
            capitalBO.setCE_ITEM_UUID(po.getUuid());
            capitalBOList.add(capitalBO);
        }
        return capitalBOList;
    }

    private List<BillInfoYCBo> buildBillInfo(FscOrderPO orderPO, Boolean isPrePay) {
        ArrayList<BillInfoYCBo> billInfoList = new ArrayList<BillInfoYCBo>();
        FscDraftInfoPO fscDraftInfoPO = new FscDraftInfoPO();
        fscDraftInfoPO.setFscOrderId(orderPO.getFscOrderId());
        List list = this.fscDraftInfoMapper.selectList(fscDraftInfoPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FscDraftInfoPO po : list) {
                BillInfoYCBo billBo = new BillInfoYCBo();
                billBo.setBILL_ID(po.getDraftId());
                if (!isPrePay.booleanValue()) {
                    billBo.setEG_PREPAY_NUM(orderPO.getOrderNo());
                }
                billInfoList.add(billBo);
            }
        }
        return billInfoList;
    }

    private List<BillPayTermInfoYCBo> buildPayTermInfo(List<FscShouldPayPO> shouldPayList, FscUnifyPayBillBO billInfoBO) {
        ArrayList<BillPayTermInfoYCBo> payTermInfos = new ArrayList<BillPayTermInfoYCBo>();
        for (FscShouldPayPO po : shouldPayList) {
            BillPayTermInfoYCBo billPayTermInfoYCBo = new BillPayTermInfoYCBo();
            billPayTermInfoYCBo.setEG_PAY_TERMS_ID(po.getPayConfId());
            billPayTermInfoYCBo.setPAY_TERMS("\u9884\u4ed8\u6b3e");
            billPayTermInfoYCBo.setPAY_DATE(billInfoBO.getPAY_DATE());
            billPayTermInfoYCBo.setAMOUNT(String.valueOf(po.getPayAmount()));
            billPayTermInfoYCBo.setORG_ID(billInfoBO.getORG_ID());
            billPayTermInfoYCBo.setEG_PREPAY_NUM(billInfoBO.getEG_PREPAY_NUM());
            billPayTermInfoYCBo.setCONTRACT_ID(po.getProContractId());
            billPayTermInfoYCBo.setCONTRACT_NUM(po.getProContractNo());
            billPayTermInfoYCBo.setCONTRACT_NAME(po.getProContractName());
            payTermInfos.add(billPayTermInfoYCBo);
        }
        return payTermInfos;
    }

    private void dealFail(Long fscOrderId, String failMsg) {
        FscPushNewYcFailBusiReqBO failBusiReqBO = new FscPushNewYcFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setFscOrderId(fscOrderId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.PAY);
        this.fscPushNewYcFailBusiService.dealPushNewYcFail(failBusiReqBO);
    }

    private void dealAlreadyExists(Long fscOrderId, String failMsg) {
        FscPushNewYcFailBusiReqBO failBusiReqBO = new FscPushNewYcFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setFscOrderId(fscOrderId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.PAY);
        this.fscPushNewYcAlreadyExistsBusiService.dealPushNewYcAlreadyExists(failBusiReqBO);
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

