/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceBillStatusUpdateService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceReqBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceRspBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultDetailBO;
import com.tydic.fsc.common.busi.api.FscFinanceBillStatusUpdateExtBusiService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundStatusUpdateBusiService;
import com.tydic.fsc.common.busi.api.finance.FscSyncFinanceDealPayResultBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtReqBo;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtRspBo;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRespBO;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceBillStatusUpdateService"})
public class FscFinanceBillStatusUpdateServiceImpl
implements FscFinanceBillStatusUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBillStatusUpdateServiceImpl.class);
    @Autowired
    private FscFinanceBillStatusUpdateExtBusiService fscFinanceBillStatusUpdateExtBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Autowired
    private FscSyncFinanceDealPayResultBusiService fscSyncFinanceDealPayResultBusiService;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscFinanceRefundStatusUpdateBusiService fscFinanceRefundStatusUpdateBusiService;
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;

    @PostMapping(value={"billStatusUpdate"})
    public FscFinanceBillStatusUpdateServiceRspBo billStatusUpdate(@RequestBody FscFinanceBillStatusUpdateServiceReqBo reqBo) {
        if (CollectionUtil.isEmpty((Collection)reqBo.getBillIds())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[billIds]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getBillStatus())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[billStatus]\u4e3a\u7a7a");
        }
        if (null == reqBo.getBillType()) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[billType]\u4e3a\u7a7a");
        }
        if (reqBo.getBillType().equals(4) || reqBo.getBillType().equals(5)) {
            return this.dealRefundInfo(reqBo);
        }
        log.debug("\u5355\u636e\u72b6\u6001\u540c\u6b65\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        boolean result = true;
        if (reqBo.getBillType().equals(2)) {
            result = this.dealFinanceBillStatus(reqBo);
        } else if (reqBo.getBillType().equals(3)) {
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderIds(reqBo.getBillIds().stream().map(Long::valueOf).collect(Collectors.toList()));
            financePO.setPaymentType(FscConstants.FinancePaymentType.PASSIVITY);
            List list = this.fscOrderFinanceMapper.getList(financePO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List payOrderIdList = this.fscShouldPayMapper.getFinancePayOrderIdBatch(list.stream().map(FscOrderFinancePO::getFscOrderId).collect(Collectors.toList()));
                List<String> payOrderStrList = payOrderIdList.stream().map(Object::toString).collect(Collectors.toList());
                result = this.dealFinanceBillStatusJgjf(reqBo, payOrderStrList);
            }
        }
        FscFinanceBillStatusUpdateServiceRspBo rspBo = new FscFinanceBillStatusUpdateServiceRspBo();
        if (!result) {
            rspBo.setRespCode("198888");
            rspBo.setRespDesc("\u5355\u636e\u72b6\u6001\u540c\u6b65\u5931\u8d25\uff01");
            return rspBo;
        }
        FscBillAddPushLogBusiReqBO busiReqBO = new FscBillAddPushLogBusiReqBO();
        busiReqBO.setCreateTime(new Date());
        busiReqBO.setObjectId(Long.valueOf((String)reqBo.getBillIds().get(0)));
        busiReqBO.setPushData(JSONObject.toJSONString((Object)reqBo));
        busiReqBO.setType(FscConstants.FscPurchasePushType.ORDER_STATE_BACK);
        this.fscBillAddPushLogBusiService.addPurchasePushLog(busiReqBO);
        FscFinanceBillStatusUpdateServiceExtRspBo rspBaseBO = this.fscFinanceBillStatusUpdateExtBusiService.dealStatusUpdate((FscFinanceBillStatusUpdateServiceExtReqBo)JUtil.js((Object)reqBo, FscFinanceBillStatusUpdateServiceExtReqBo.class));
        if ("0000".equals(rspBaseBO.getRespCode()) && result) {
            for (String billId : reqBo.getBillIds()) {
                this.sendMq(Long.valueOf(billId));
            }
        }
        rspBo.setRespCode(rspBaseBO.getRespCode());
        rspBo.setRespDesc(rspBaseBO.getRespDesc());
        return rspBo;
    }

    private FscFinanceBillStatusUpdateServiceRspBo dealRefundInfo(FscFinanceBillStatusUpdateServiceReqBo reqBo) {
        FscFinanceBillStatusUpdateServiceRspBo rspBo = this.fscFinanceRefundStatusUpdateBusiService.dealRefundStatusUpdate(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            for (String billId : reqBo.getBillIds()) {
                this.sendRefundMq(Long.valueOf(billId));
            }
        }
        return rspBo;
    }

    private boolean dealFinanceBillStatus(FscFinanceBillStatusUpdateServiceReqBo reqBo) {
        List ids = reqBo.getBillIds().stream().map(Long::valueOf).collect(Collectors.toList());
        List bankStatementList = this.fscFinanceBankStatementMapper.getListByFscOrderIds(ids);
        List orderFinanceList = this.fscOrderFinanceMapper.getListByFscOrderIds(ids);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(ids);
        List orderList = this.fscOrderMapper.getList(fscOrderPO);
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        boolean flag = true;
        for (String id : reqBo.getBillIds()) {
            FscSyncFinanceDealPayResultRspBO rspBO;
            FscOrderFinancePO fscOrderFinancePO = orderFinanceList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).findFirst().orElse(new FscOrderFinancePO());
            if (!Objects.equals(fscOrderFinancePO.getPaymentType(), FscConstants.FinancePaymentType.PASSIVITY)) continue;
            FscOrderPO fscOrder = orderList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).findFirst().orElse(new FscOrderPO());
            FscSyncFinanceDealPayResultRespBO reqSyncFinanceDealPayResultBO = new FscSyncFinanceDealPayResultRespBO();
            reqSyncFinanceDealPayResultBO.setPayOrderId(id);
            reqSyncFinanceDealPayResultBO.setPayTime(reqBo.getOperTime());
            reqSyncFinanceDealPayResultBO.setOperAccount(reqBo.getOperAccount());
            reqSyncFinanceDealPayResultBO.setOperName(reqBo.getOperName());
            reqSyncFinanceDealPayResultBO.setPayOrderNo(fscOrder.getOrderNo());
            List<FscFinanceBankStatementPO> detailList = bankStatementList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).collect(Collectors.toList());
            ArrayList<FscFinanceDealPayResultDetailBO> detailBOList = new ArrayList<FscFinanceDealPayResultDetailBO>();
            if (!CollectionUtil.isEmpty(detailList)) {
                detailList.forEach(item -> {
                    FscFinanceDealPayResultDetailBO detailBO = new FscFinanceDealPayResultDetailBO();
                    detailBO.setPayDetailId(String.valueOf(item.getStatementId()));
                    detailBO.setPayAmt(item.getOccAmt());
                    detailBO.setPayAmtLocal(item.getOccAmtLocal());
                    detailBO.setExchangeRate(fscOrderFinancePO.getExchangeRate() == null ? BigDecimal.ONE : fscOrderFinancePO.getExchangeRate());
                    detailBO.setCurrency(fscOrderFinancePO.getCurrency());
                    detailBO.setCurrencyName((String)currencTypeMap.get(fscOrderFinancePO.getCurrency()));
                    detailBO.setPayStatus("1");
                    detailBOList.add(detailBO);
                });
            }
            reqSyncFinanceDealPayResultBO.setDetailList(detailBOList);
            log.debug("\u8c03\u7528\u4ed8\u6b3e\u56de\u8c03\u63a5\u53e3\u540c\u6b65\u72b6\u6001\uff0creqSyncFinanceDealPayResultBO\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)reqSyncFinanceDealPayResultBO)));
            FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
            logAbilityReqBO.setObjectId(Long.valueOf(id));
            logAbilityReqBO.setObjectNo(fscOrder.getOrderNo());
            logAbilityReqBO.setType(FscConstants.FscPurchasePushType.PAY_CALLBACK);
            logAbilityReqBO.setCreateTime(new Date());
            logAbilityReqBO.setPushData(JSONObject.toJSONString((Object)((Object)reqSyncFinanceDealPayResultBO)));
            this.fscBillAddPushLogAbilityService.savePurchasePushLog(logAbilityReqBO);
            if (FscConstants.OrderFlow.PAY.equals(fscOrder.getOrderFlow())) {
                FscPayBillDetailAssemblyAtomReqBO assetAtomReqBO = new FscPayBillDetailAssemblyAtomReqBO();
                assetAtomReqBO.setPayOrderId(fscOrder.getFscOrderId());
                assetAtomReqBO.setSettlePlatform(fscOrder.getSettlePlatform());
                if (FscConstants.SettleType.INSPECTION.equals(fscOrder.getSettleType())) {
                    this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssembly(assetAtomReqBO);
                } else {
                    this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssemblyByOrder(assetAtomReqBO);
                }
            }
            if ("0000".equals((rspBO = this.fscSyncFinanceDealPayResultBusiService.dealFinanceDealPayResult(reqSyncFinanceDealPayResultBO)).getRespCode())) continue;
            flag = false;
        }
        return flag;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void sendRefundMq(Long refundId) {
        FscComRefundSyncAbilityReqBO abilityReqBO = new FscComRefundSyncAbilityReqBO();
        abilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(abilityReqBO);
    }

    private boolean dealFinanceBillStatusJgjf(FscFinanceBillStatusUpdateServiceReqBo reqBo, List<String> billIds) {
        List ids = billIds.stream().map(Long::valueOf).collect(Collectors.toList());
        List bankStatementList = this.fscFinanceBankStatementMapper.getListByFscOrderIds(ids);
        List orderFinanceList = this.fscOrderFinanceMapper.getListByFscOrderIds(ids);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(ids);
        List orderList = this.fscOrderMapper.getList(fscOrderPO);
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        boolean flag = true;
        for (String id : billIds) {
            FscOrderFinancePO fscOrderFinancePO = orderFinanceList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).findFirst().orElse(new FscOrderFinancePO());
            if (!Objects.equals(fscOrderFinancePO.getPaymentType(), FscConstants.FinancePaymentType.PASSIVITY)) continue;
            FscOrderPO fscOrder = orderList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).findFirst().orElse(new FscOrderPO());
            FscSyncFinanceDealPayResultRespBO reqSyncFinanceDealPayResultBO = new FscSyncFinanceDealPayResultRespBO();
            reqSyncFinanceDealPayResultBO.setPayOrderId(id);
            reqSyncFinanceDealPayResultBO.setPayTime(reqBo.getOperTime());
            reqSyncFinanceDealPayResultBO.setOperAccount(reqBo.getOperAccount());
            reqSyncFinanceDealPayResultBO.setOperName(reqBo.getOperName());
            reqSyncFinanceDealPayResultBO.setPayOrderNo(fscOrder.getOrderNo());
            List<FscFinanceBankStatementPO> detailList = bankStatementList.stream().filter(item -> Objects.equals(item.getFscOrderId(), Long.valueOf(id))).collect(Collectors.toList());
            ArrayList<FscFinanceDealPayResultDetailBO> detailBOList = new ArrayList<FscFinanceDealPayResultDetailBO>();
            if (!CollectionUtil.isEmpty(detailList)) {
                detailList.forEach(item -> {
                    FscFinanceDealPayResultDetailBO detailBO = new FscFinanceDealPayResultDetailBO();
                    detailBO.setPayDetailId(String.valueOf(item.getStatementId()));
                    detailBO.setPayAmt(item.getOccAmt());
                    detailBO.setPayAmtLocal(item.getOccAmtLocal());
                    detailBO.setExchangeRate(fscOrderFinancePO.getExchangeRate() == null ? BigDecimal.ONE : fscOrderFinancePO.getExchangeRate());
                    detailBO.setCurrency(fscOrderFinancePO.getCurrency());
                    detailBO.setCurrencyName((String)currencTypeMap.get(fscOrderFinancePO.getCurrency()));
                    detailBO.setPayStatus("1");
                    detailBOList.add(detailBO);
                });
            }
            reqSyncFinanceDealPayResultBO.setDetailList(detailBOList);
            log.debug("\u8c03\u7528\u4ed8\u6b3e\u56de\u8c03\u63a5\u53e3\u540c\u6b65\u72b6\u6001\uff0creqSyncFinanceDealPayResultBO\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)reqSyncFinanceDealPayResultBO)));
            FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
            logAbilityReqBO.setObjectId(Long.valueOf(id));
            logAbilityReqBO.setObjectNo(fscOrder.getOrderNo());
            logAbilityReqBO.setType(FscConstants.FscPurchasePushType.PAY_CALLBACK);
            logAbilityReqBO.setCreateTime(new Date());
            logAbilityReqBO.setPushData(JSONObject.toJSONString((Object)((Object)reqSyncFinanceDealPayResultBO)));
            this.fscBillAddPushLogAbilityService.savePurchasePushLog(logAbilityReqBO);
            FscSyncFinanceDealPayResultRspBO rspBO = this.fscSyncFinanceDealPayResultBusiService.dealFinanceDealPayResult(reqSyncFinanceDealPayResultBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                flag = false;
                continue;
            }
            this.sendMq(Long.valueOf(id));
        }
        return flag;
    }
}

