/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceBizTypeListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBizTypeListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBizTypeListQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceBizTypeListVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceBizTypeListQryAbilityService"})
public class FscFinanceBizTypeListQryAbilityServiceImpl
implements FscFinanceBizTypeListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBizTypeListQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fsFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceBizTypeList"})
    public FscFinanceBizTypeListQryRspBO qryFinanceBizTypeList(@RequestBody FscFinanceBizTypeListQryReqBO reqBo) {
        FscFinanceBizTypeListQryRspBO rspBO = new FscFinanceBizTypeListQryRspBO();
        this.valid(reqBo);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareToken = this.fsFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainUrl), (String)"\u672a\u914d\u7f6e\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u5efa\u8bbe\u9879\u76ee\u63a5\u53e3");
            HashMap header = Maps.newHashMap();
            header.put("Authorization", financeShareToken.getToken());
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587 url:{} billTypeCode:{}", (Object)this.fscShareFinanceServiceConfiguration.getBa103(), (Object)reqBo.getBillTypeCode());
            String json = SSLClient.doGet((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getBa103() + reqBo.getBillTypeCode()), (Map)header);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)json);
            FscFinanceBizTypeListVO vo = (FscFinanceBizTypeListVO)JSON.parseObject((String)json, FscFinanceBizTypeListVO.class);
            Assert.isTrue((vo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3a\u7a7a");
            Assert.isTrue((vo.getCode() == 0 ? 1 : 0) != 0, (String)vo.getMsg());
            rspBO.setDataList(vo.getData());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2\u63a5\u53e3\uff1a%s", e.getMessage()));
        }
        return rspBO;
    }

    private void valid(FscFinanceBizTypeListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBillTypeCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b[billTypeCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

