/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.bo.FscFinancePayItemBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.common.ability.api.finance.FscFinanceDealChargeAuditAbilityService;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealChargeAuditReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealChargeAuditRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceDealChargeAuditBusiService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealChargeAuditBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealChargeAuditBusiRspBO;
import com.tydic.fsc.common.enums.DeleteYnEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceDealChargeAuditAbilityService"})
public class FscFinanceDealChargeAuditAbilityServiceImpl
implements FscFinanceDealChargeAuditAbilityService {
    @Autowired
    private FscFinanceDealChargeAuditBusiService fscFinanceDealChargeAuditBusiService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceReleasePayInfoBusiService fscFinanceReleasePayInfoBusiService;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TOPIC:FSC_PUSH_FINANCE_CHARGE_TOPIC}")
    private String fscPushFinanceChargeTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TAG:FSC_PUSH_FINANCE_CHARGE_TAG}")
    private String fscPushFinanceChargeTag;
    @Resource(name="fscPushFinanceChargeListMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceChargeListMqServiceProvider;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinanceChargeAudit"})
    public FscFinanceDealChargeAuditRspBO dealFinanceChargeAudit(@RequestBody FscFinanceDealChargeAuditReqBO reqBO) {
        this.valid(reqBO);
        this.paramVerify(reqBO);
        this.paramEmployeeSupermarketVerify(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscFinanceDealChargeAuditBusiReqBO busiReqBO = (FscFinanceDealChargeAuditBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscFinanceDealChargeAuditBusiReqBO.class));
        this.dealFinanceInfo(reqBO, busiReqBO);
        FscFinanceDealChargeAuditBusiRspBO busiRspBO = this.fscFinanceDealChargeAuditBusiService.dealFinanceChargeAudit(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && busiRspBO.getFinish().booleanValue()) {
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderId(reqBO.getChargeId());
            financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
            if (reqBO.getAuditResult() == 0 && financePO != null) {
                FscFinancePushChargeAbilityReqBO abilityReqBO = new FscFinancePushChargeAbilityReqBO();
                abilityReqBO.setChargeId(reqBO.getChargeId());
                this.fscPushFinanceChargeListMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceChargeTopic, this.fscPushFinanceChargeTag, JSONObject.toJSONString((Object)abilityReqBO)));
            } else if (reqBO.getAuditResult() == 1 && financePO != null) {
                FscFinanceReleasePayInfoReqBO infoReqBO = new FscFinanceReleasePayInfoReqBO();
                infoReqBO.setFscOrderId(reqBO.getChargeId());
                this.fscFinanceReleasePayInfoBusiService.dealReleasePayInfo(infoReqBO);
            }
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscFinanceDealChargeAuditRspBO)JSONObject.parseObject((String)respString, FscFinanceDealChargeAuditRspBO.class);
    }

    private void dealFinanceInfo(FscFinanceDealChargeAuditReqBO reqBO, FscFinanceDealChargeAuditBusiReqBO busiReqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            FscAccountChargePO chargePO = new FscAccountChargePO();
            chargePO.setChargeId(reqBO.getChargeId());
            chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
            FscAccountChargeDetailPO detailQueryVo = new FscAccountChargeDetailPO();
            detailQueryVo.setChargeId(reqBO.getChargeId());
            List chargeDetailPOList = this.fscAccountChargeDetailMapper.getList(detailQueryVo);
            Map<Long, FscAccountChargeDetailPO> chargeDetailMap = chargeDetailPOList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getId, e -> e));
            ArrayList<FscAccountChargeDetailPO> updChargeList = new ArrayList<FscAccountChargeDetailPO>();
            ArrayList<FscAccountChargeDetailPO> addChargeList = new ArrayList<FscAccountChargeDetailPO>();
            FscFinanceDraftInfoPO draftInfoQueryVo = new FscFinanceDraftInfoPO();
            draftInfoQueryVo.setFscOrderId(reqBO.getChargeId());
            List draftPOList = this.fscFinanceDraftInfoMapper.getList(draftInfoQueryVo);
            Map<Long, FscFinanceDraftInfoPO> draftMap = draftPOList.stream().collect(Collectors.toMap(FscFinanceDraftInfoPO::getDraftId, e -> e));
            ArrayList<FscFinanceDraftInfoPO> draftUpdList = new ArrayList<FscFinanceDraftInfoPO>();
            ArrayList<FscFinanceDraftInfoPO> draftAddList = new ArrayList<FscFinanceDraftInfoPO>();
            HashSet<String> draftExtIds = new HashSet<String>();
            HashSet<String> supplyExtIds = new HashSet<String>();
            ArrayList<Long> delDraftIds = new ArrayList<Long>();
            FscFinanceCapitalPlanPO capitalPlanQueryVo = new FscFinanceCapitalPlanPO();
            capitalPlanQueryVo.setFscOrderId(reqBO.getChargeId());
            List planList = this.fscFinanceCapitalPlanMapper.getList(capitalPlanQueryVo);
            Map<Long, FscFinanceCapitalPlanPO> planMap = planList.stream().collect(Collectors.toMap(FscFinanceCapitalPlanPO::getCaptialId, e -> e));
            ArrayList<FscFinanceCapitalPlanPO> planUpdList = new ArrayList<FscFinanceCapitalPlanPO>();
            ArrayList<FscFinanceCapitalPlanPO> planAddList = new ArrayList<FscFinanceCapitalPlanPO>();
            ArrayList<FscFinanceCapitalPlanPO> releasePlanList = new ArrayList<FscFinanceCapitalPlanPO>();
            ArrayList<Long> delPlanIds = new ArrayList<Long>();
            FscFinancePayItemPO payItemPO = new FscFinancePayItemPO();
            payItemPO.setFscOrderId(reqBO.getChargeId());
            List financeItemList = this.fscFinancePayItemMapper.getList(payItemPO);
            Map<Long, FscFinancePayItemPO> financeMap = financeItemList.stream().collect(Collectors.toMap(FscFinancePayItemPO::getFinancePayItemId, e -> e));
            ArrayList<FscFinancePayItemPO> financeUpdList = new ArrayList<FscFinancePayItemPO>();
            ArrayList<FscFinancePayItemPO> financeAddList = new ArrayList<FscFinancePayItemPO>();
            BigDecimal chargeAmount = BigDecimal.ZERO;
            String billtypeName = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription();
            String extBizBilltype = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName();
            for (FscUseAccountBO accountBO : reqBO.getUseAccountBOList()) {
                FscFinanceCapitalPlanPO planPO;
                FscFinanceDraftInfoPO draftInfoPO;
                FscFinancePayItemPO financePayItemPO;
                FscAccountChargeDetailPO chargeDetailPO;
                chargeAmount = chargeAmount.add(accountBO.getChargeAmount());
                if (accountBO.getId() == null) {
                    chargeDetailPO = new FscAccountChargeDetailPO();
                    BeanUtils.copyProperties((Object)accountBO, (Object)chargeDetailPO);
                    chargeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    chargeDetailPO.setChargeId(chargePO.getChargeId());
                    chargeDetailPO.setAdvanceDepositNo(chargePO.getAdvanceDepositNo());
                    chargeDetailPO.setCreateId(reqBO.getUserId());
                    chargeDetailPO.setCreateTime(new Date());
                    chargeDetailPO.setUpdateId(reqBO.getUserId());
                    chargeDetailPO.setUpdateTime(new Date());
                    chargeDetailPO.setDeleteYn(DeleteYnEnum.NORMAL.getCode());
                    addChargeList.add(chargeDetailPO);
                    if (CollectionUtils.isEmpty((Collection)accountBO.getFinanceItemList())) continue;
                    for (FscFinancePayItemBO payItemBO : accountBO.getFinanceItemList()) {
                        financePayItemPO = new FscFinancePayItemPO();
                        BeanUtils.copyProperties((Object)payItemBO, (Object)financePayItemPO);
                        financePayItemPO.setFinancePayItemId(Long.valueOf(Sequence.getInstance().nextId()));
                        financePayItemPO.setFscOrderId(reqBO.getChargeId());
                        financePayItemPO.setOrderPayItemId(chargeDetailPO.getId());
                        payItemBO.setFinancePayItemId(financePayItemPO.getFinancePayItemId());
                        financeAddList.add(financePayItemPO);
                        if (!CollectionUtils.isEmpty((Collection)payItemBO.getDraftList())) {
                            for (FscFinanceDraftInfoBO draftInfoBO : payItemBO.getDraftList()) {
                                draftInfoPO = new FscFinanceDraftInfoPO();
                                BeanUtils.copyProperties((Object)draftInfoBO, (Object)draftInfoPO);
                                draftInfoPO.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
                                draftInfoPO.setFinancePayItemId(payItemPO.getFinancePayItemId());
                                draftInfoPO.setFscOrderId(reqBO.getChargeId());
                                draftInfoPO.setCreateTime(new Date());
                                draftInfoPO.setExtbilltypeName(billtypeName);
                                draftInfoPO.setExtBizBilltype(extBizBilltype);
                                draftAddList.add(draftInfoPO);
                            }
                        }
                        if (CollectionUtils.isEmpty((Collection)payItemBO.getPlanList())) continue;
                        for (FscFinancePlanItemBO planItemBO : payItemBO.getPlanList()) {
                            planPO = new FscFinanceCapitalPlanPO();
                            BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                            planPO.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
                            planPO.setFscOrderId(reqBO.getChargeId());
                            planPO.setFinancePayItemId(financePayItemPO.getFinancePayItemId());
                            planAddList.add(planPO);
                        }
                    }
                    continue;
                }
                chargeDetailPO = chargeDetailMap.get(accountBO.getId());
                chargeDetailMap.remove(accountBO.getId());
                if (accountBO.getChargeAmount().compareTo(chargeDetailPO.getChargeAmount()) != 0) {
                    chargeDetailPO.setChargeAmount(accountBO.getChargeAmount());
                    updChargeList.add(chargeDetailPO);
                }
                if (CollectionUtils.isEmpty((Collection)accountBO.getFinanceItemList())) continue;
                for (FscFinancePayItemBO payItemBO : accountBO.getFinanceItemList()) {
                    financePayItemPO = new FscFinancePayItemPO();
                    if (payItemBO.getFinancePayItemId() == null) {
                        BeanUtils.copyProperties((Object)payItemBO, (Object)financePayItemPO);
                        financePayItemPO.setFinancePayItemId(Long.valueOf(Sequence.getInstance().nextId()));
                        financePayItemPO.setFscOrderId(reqBO.getChargeId());
                        financePayItemPO.setOrderPayItemId(chargeDetailPO.getId());
                        payItemBO.setFinancePayItemId(financePayItemPO.getFinancePayItemId());
                        financeAddList.add(financePayItemPO);
                    } else {
                        financeMap.remove(payItemBO.getFinancePayItemId());
                        financePayItemPO = new FscFinancePayItemPO();
                        BeanUtils.copyProperties((Object)payItemBO, (Object)financePayItemPO);
                        financeUpdList.add(financePayItemPO);
                    }
                    if (!CollectionUtils.isEmpty((Collection)payItemBO.getPlanList())) {
                        for (FscFinancePlanItemBO planItemBO : payItemBO.getPlanList()) {
                            if (!(planItemBO.getCaptialId() != null && planItemBO.getPlanItemCode().equals(planMap.get(planItemBO.getCaptialId()).getPlanItemCode()) && payItemBO.getPayItemNo().equals(planMap.get(planItemBO.getCaptialId()).getPayItemNo()) && planItemBO.getPayMethodCode().equals(planMap.get(planItemBO.getCaptialId()).getPayMethodCode()))) {
                                planPO = new FscFinanceCapitalPlanPO();
                                BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                                planPO.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
                                planPO.setFscOrderId(reqBO.getChargeId());
                                planPO.setFinancePayItemId(payItemBO.getFinancePayItemId());
                                planAddList.add(planPO);
                                continue;
                            }
                            planPO = planMap.get(planItemBO.getCaptialId());
                            planMap.remove(planItemBO.getCaptialId());
                            if (planItemBO.getOccAmount().compareTo(planPO.getOccAmount()) == 0) continue;
                            releasePlanList.add(planPO);
                            planPO.setOccAmount(planItemBO.getOccAmount());
                            planUpdList.add(planPO);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)payItemBO.getDraftList())) continue;
                    for (FscFinanceDraftInfoBO draftInfoBO : payItemBO.getDraftList()) {
                        if (draftInfoBO.getDraftId() == null || !draftInfoBO.getFinancePayItemId().equals(draftMap.get(draftInfoBO.getDraftId()).getFinancePayItemId())) {
                            draftInfoPO = new FscFinanceDraftInfoPO();
                            BeanUtils.copyProperties((Object)draftInfoBO, (Object)draftInfoPO);
                            draftInfoPO.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
                            draftInfoPO.setFinancePayItemId(payItemBO.getFinancePayItemId());
                            draftInfoPO.setFscOrderId(reqBO.getChargeId());
                            draftInfoPO.setCreateTime(new Date());
                            draftInfoPO.setExtbilltypeName(billtypeName);
                            draftInfoPO.setExtBizBilltype(extBizBilltype);
                            draftAddList.add(draftInfoPO);
                            continue;
                        }
                        draftInfoPO = draftMap.get(draftInfoBO.getDraftId());
                        draftMap.remove(draftInfoBO.getDraftId());
                        if (draftInfoPO == null) {
                            throw new FscBusinessException("198888", draftInfoBO.getDraftId() + "\u672a\u83b7\u53d6\u5230\u7968\u636e\u4fe1\u606f\uff01");
                        }
                        if (draftInfoPO.getOccAmt().compareTo(draftInfoBO.getOccAmt()) == 0) continue;
                        draftInfoPO.setOccAmt(draftInfoPO.getOccAmt());
                        draftInfoPO.setExtbilltypeName(billtypeName);
                        draftInfoPO.setExtBizBilltype(extBizBilltype);
                        draftUpdList.add(draftInfoPO);
                        if (!StringUtils.isEmpty((Object)draftInfoPO.getExtId()) && FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                            draftExtIds.add(draftInfoPO.getExtId());
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)draftInfoPO.getExtId()) || !FscConstants.FinanceDraftType.RECEIVABLE_SUPPLY.equals(draftInfoPO.getDraftType())) continue;
                        supplyExtIds.add(draftInfoPO.getExtId());
                    }
                }
            }
            if (!CollectionUtils.isEmpty(chargeDetailMap)) {
                busiReqBO.setDelDetailIds(chargeDetailMap.keySet());
            }
            if (!CollectionUtils.isEmpty(financeMap)) {
                busiReqBO.setDelFinanceItemIds(financeMap.keySet());
            }
            if (!CollectionUtils.isEmpty(draftMap)) {
                for (Long draftId : draftMap.keySet()) {
                    FscFinanceDraftInfoPO draftInfoPO = draftMap.get(draftId);
                    if (!StringUtils.isEmpty((Object)draftInfoPO.getExtId()) && FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                        draftExtIds.add(draftInfoPO.getExtId());
                    } else if (!StringUtils.isEmpty((Object)draftInfoPO.getExtId()) && FscConstants.FinanceDraftType.RECEIVABLE_SUPPLY.equals(draftInfoPO.getDraftType())) {
                        supplyExtIds.add(draftInfoPO.getExtId());
                    }
                    delDraftIds.add(draftId);
                }
            }
            if (!CollectionUtils.isEmpty(planMap)) {
                for (Long planId : planMap.keySet()) {
                    FscFinanceCapitalPlanPO planPO = planMap.get(planId);
                    releasePlanList.add(planPO);
                    delPlanIds.add(planPO.getCaptialId());
                }
            }
            busiReqBO.setFinanceAddList(financeAddList);
            busiReqBO.setFinanceUpdList(financeUpdList);
            busiReqBO.setDraftUpdList(draftUpdList);
            busiReqBO.setDraftExtIds(draftExtIds);
            busiReqBO.setSupplyExtIds(supplyExtIds);
            busiReqBO.setDraftAddList(draftAddList);
            busiReqBO.setDelDraftIds(delDraftIds);
            busiReqBO.setPlanAddList(planAddList);
            busiReqBO.setPlanUpdList(planUpdList);
            busiReqBO.setReleasePlanList(releasePlanList);
            busiReqBO.setDelPlanIds(delPlanIds);
            busiReqBO.setChargeNo(chargePO.getAdvanceDepositNo());
            busiReqBO.setChargeAmount(chargeAmount);
            busiReqBO.setUpdChargeList(updChargeList);
        }
    }

    private void valid(FscFinanceDealChargeAuditReqBO reqBO) {
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5145\u503c\u5355id[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuditResult() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c[auditResult]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditRemark())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5ba1\u6279\u610f\u89c1[auditRemark]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void paramEmployeeSupermarketVerify(FscFinanceDealChargeAuditReqBO reqBO) {
        if (reqBO.getBusiType() != 4) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFinanceOrgId())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                if (!ObjectUtil.isEmpty((Object)fscUseAccountBO.getCompanyChargeAmount()) || !ObjectUtil.isEmpty((Object)fscUseAccountBO.getUnionChargeAmount())) continue;
                throw new FscBusinessException("198888", "\u516c\u53f8\u5145\u503c\u91d1\u989d\u548c\u5de5\u4f1a\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                BigDecimal totalUseAccount = new BigDecimal("0");
                BigDecimal companyChargeAmount = ObjectUtil.isNotEmpty((Object)fscUseAccountBO.getCompanyChargeAmount()) ? fscUseAccountBO.getCompanyChargeAmount() : BigDecimal.ZERO;
                BigDecimal unionChargeAmount = ObjectUtil.isNotEmpty((Object)fscUseAccountBO.getUnionChargeAmount()) ? fscUseAccountBO.getUnionChargeAmount() : BigDecimal.ZERO;
                totalUseAccount = totalUseAccount.add(companyChargeAmount).add(unionChargeAmount);
                if (CollectionUtils.isEmpty((Collection)fscUseAccountBO.getFinanceItemList())) continue;
                BigDecimal totalPayAmount = new BigDecimal("0");
                for (FscFinancePayItemBO fscFinancePayItemBO : fscUseAccountBO.getFinanceItemList()) {
                    BigDecimal payAmount = ObjectUtil.isNotEmpty((Object)fscFinancePayItemBO.getPayAmount()) ? fscFinancePayItemBO.getPayAmount() : BigDecimal.ZERO;
                    totalPayAmount = totalPayAmount.add(payAmount);
                    if (CollectionUtils.isEmpty((Collection)fscFinancePayItemBO.getPlanList())) continue;
                    BigDecimal totalPlanAmount = new BigDecimal("0");
                    for (FscFinancePlanItemBO fscFinancePlanItemBO : fscFinancePayItemBO.getPlanList()) {
                        BigDecimal occAmount = ObjectUtil.isNotEmpty((Object)fscFinancePlanItemBO.getOccAmount()) ? fscFinancePlanItemBO.getOccAmount() : BigDecimal.ZERO;
                        totalPlanAmount = totalPlanAmount.add(occAmount);
                    }
                    if (payAmount.compareTo(totalPlanAmount) == 0) continue;
                    throw new FscBusinessException("198888", fscFinancePayItemBO.getPayItemNo() + "\uff0c\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0e\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u603b\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
                if (totalUseAccount.compareTo(totalPayAmount) == 0) continue;
                throw new FscBusinessException("198888", fscUseAccountBO.getItemNo() + "\uff0c\u4f7f\u7528\u5355\u4f4d\u5145\u503c\u91d1\u989d\u4e0e\u7533\u8bf7\u4ed8\u6b3e\u603b\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
    }

    private void paramVerify(FscFinanceDealChargeAuditReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getFinanceOrgId())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            for (FscUseAccountBO fscUseAccountBO : reqBO.getUseAccountBOList()) {
                if (CollectionUtils.isEmpty((Collection)fscUseAccountBO.getFinanceItemList())) continue;
                for (FscFinancePayItemBO fscFinancePayItemBO : fscUseAccountBO.getFinanceItemList()) {
                    BigDecimal totalOccAmt;
                    if (CollectionUtils.isEmpty((Collection)fscFinancePayItemBO.getDraftList())) continue;
                    for (FscFinanceDraftInfoBO fscFinanceDraftInfoBO : fscFinancePayItemBO.getDraftList()) {
                        if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoBO.getOccAmt())) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoBO.getOccAmtLocal())) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (fscFinanceDraftInfoBO.getOccAmt().compareTo(BigDecimal.ZERO) == 0) {
                            throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                        }
                        if (fscFinanceDraftInfoBO.getOccAmtLocal().compareTo(BigDecimal.ZERO) != 0) continue;
                        throw new FscBusinessException("198888", "\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a0");
                    }
                    BigDecimal payAmount = ObjectUtil.isNotEmpty((Object)fscFinancePayItemBO.getPayAmount()) ? fscFinancePayItemBO.getPayAmount() : BigDecimal.ZERO;
                    if (payAmount.compareTo(totalOccAmt = fscFinancePayItemBO.getDraftList().stream().map(FscFinanceDraftInfoBO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) == 0) continue;
                    throw new FscBusinessException("198888", fscFinancePayItemBO.getPayItemNo() + "\uff0c\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0e\u7968\u636e\u4fe1\u606f\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0d\u4e00\u81f4");
                }
            }
        }
    }
}

