/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceSupplyChainClaimListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSupplyChainClaimListDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSupplyChainClaimListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSupplyChainClaimListQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceSupplyChainClaimListResultVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceSupplyChainClaimListQryAbilityService"})
public class FscFinanceSupplyChainClaimListQryAbilityServiceImpl
implements FscFinanceSupplyChainClaimListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSupplyChainClaimListQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceSupplyChainClaimList"})
    public FscFinanceSupplyChainClaimListQryRspBO qryFinanceSupplyChainClaimList(@RequestBody FscFinanceSupplyChainClaimListQryReqBO reqBO) {
        FscFinanceSupplyChainClaimListQryRspBO rspBO;
        this.valid(reqBO);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        log.debug("\u83b7\u53d6Token\u4fe1\u606f\uff1a{}", (Object)financeShareTokenRspBO.getToken());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", financeShareTokenRspBO.getToken());
        String reqString = JSONObject.toJSONString((Object)reqBO);
        JSONObject object = JSONObject.parseObject((String)reqString);
        object.put("currentPage", (Object)reqBO.getPageNo());
        object.put("pageSize", (Object)reqBO.getPageSize());
        object.put("deptId", (Object)reqBO.getFinanceDeptId());
        object.put("orgId", (Object)reqBO.getFinanceOrgId());
        log.debug("\u83b7\u53d6\u4f9b\u5e94\u94fe\u8ba4\u9886\u67e5\u8be2\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)object.toJSONString());
        log.debug("\u83b7\u53d6\u4f9b\u5e94\u94fe\u8ba4\u9886\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm124()));
        String respStr = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm124()), (String)object.toJSONString(), headerMap);
        log.debug("\u83b7\u53d6\u4f9b\u5e94\u94fe\u8ba4\u9886\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("191138", "\u83b7\u53d6\u4f9b\u5e94\u94fe\u8ba4\u9886\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            rspBO = this.resolveRreRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u4f9b\u5e94\u94fe\u8ba4\u9886\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private FscFinanceSupplyChainClaimListQryRspBO resolveRreRsp(String respStr) {
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4f9b\u5e94\u94fe\u8ba4\u9886\u8fd4\u56de\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscFinanceSupplyChainClaimListQryRspBO rspBO = new FscFinanceSupplyChainClaimListQryRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!Objects.equals(jsonObject.getString("code"), "0")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u67e5\u8be2\u4f9b\u5e94\u94fe\u8ba4\u9886\u5931\u8d25\uff01" + jsonObject.getString("msg"));
            return rspBO;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray records = data.getJSONArray("records");
        List resultVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)records), FscFinanceSupplyChainClaimListResultVO.class);
        if (CollectionUtils.isEmpty((Collection)resultVOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List detailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resultVOList), FscFinanceSupplyChainClaimListDetailBO.class);
        if (!CollectionUtils.isEmpty((Collection)detailList)) {
            detailList.forEach(item -> {
                item.setIssuedDate(DateUtil.convertDateFormat((String)item.getIssuedDate()));
                item.setDraftType(FscConstants.FinanceDraftType.SUPPLY);
            });
        }
        Integer total = data.getInteger("total") % data.getInteger("pageSize") > 0 ? data.getInteger("total") / data.getInteger("pageSize") + 1 : data.getInteger("total") / data.getInteger("pageSize");
        rspBO.setPageNo(data.getInteger("currentPage"));
        rspBO.setTotal(total);
        rspBO.setRecordsTotal(data.getInteger("total"));
        rspBO.setRows(detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u89e3\u6790\u4f9b\u5e94\u94fe\u8ba4\u9886\u6570\u636e\u96c6\u5408\uff1a{}", (Object)detailList);
        return rspBO;
    }

    private void valid(FscFinanceSupplyChainClaimListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTicketsStatus())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e\u72b6\u6001[ticketsStatus]\u4e3a\u7a7a");
        }
    }
}

